/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.tasks.LintStandaloneTask;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskContainer;

public class LintPlugin
implements Plugin<Project> {
    private Project project;
    private LintOptions lintOptions;

    public void apply(Project project) {
        System.setProperty("java.awt.headless", "true");
        this.project = project;
        this.createExtension(project);
        BasePlugin.createLintClasspathConfiguration(project);
        this.withJavaPlugin((Action<Plugin>)((Action)plugin -> {
            JavaPluginConvention javaConvention = this.getJavaPluginConvention();
            if (javaConvention != null) {
                LintStandaloneTask task = this.createTask(project, javaConvention);
                task.setLintChecks(TaskManager.createCustomLintChecksConfig((Project)project));
            }
        }));
    }

    private void createExtension(Project project) {
        this.lintOptions = (LintOptions)project.getExtensions().create("lintOptions", LintOptions.class, new Object[0]);
    }

    private void withJavaPlugin(Action<Plugin> action) {
        this.project.getPlugins().withType(JavaBasePlugin.class, action);
    }

    private LintStandaloneTask createTask(Project project, JavaPluginConvention javaConvention) {
        File testResultsDir = javaConvention.getTestResultsDir();
        TaskContainer tasks = project.getTasks();
        LintStandaloneTask task = (LintStandaloneTask)tasks.create("lint", LintStandaloneTask.class);
        String desc = "Run Android Lint analysis on project '" + project.getName() + "'";
        task.setGroup("verification");
        task.setDescription(desc);
        task.setReportDir(testResultsDir);
        task.setLintOptions((com.android.builder.model.LintOptions)this.lintOptions);
        ((Task)tasks.findByName("check")).dependsOn(new Object[]{task});
        return task;
    }

    private JavaPluginConvention getJavaPluginConvention() {
        Convention convention = this.project.getConvention();
        JavaPluginConvention javaConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            this.project.getLogger().warn("Cannot apply lint if the java or kotlin Gradle plugins have also been applied");
            return null;
        }
        return javaConvention;
    }
}

