/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;

/** Factory to create ProductFlavor object using an {@link ObjectFactory} to add the DSL methods. */
public class ProductFlavorFactory implements NamedDomainObjectFactory<ProductFlavor> {

    @NonNull private final ObjectFactory objectFactory;
    @NonNull
    private final Project project;
    @NonNull
    private final Logger logger;
    @NonNull private final DeprecationReporter deprecationReporter;

    public ProductFlavorFactory(
            @NonNull ObjectFactory objectFactory,
            @NonNull Project project,
            @NonNull Logger logger,
            @NonNull DeprecationReporter deprecationReporter) {
        this.objectFactory = objectFactory;
        this.project = project;
        this.logger = logger;
        this.deprecationReporter = deprecationReporter;
    }

    @NonNull
    @Override
    public ProductFlavor create(String name) {
        return objectFactory.newInstance(
                ProductFlavor.class, name, project, objectFactory, logger, deprecationReporter);
    }
}
