/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.builder.testing.MockableJarGenerator;
import com.android.builder.utils.FileCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class MockableAndroidJarTask
extends DefaultTask {
    private File androidJar;
    private File outputFile;
    private FileCache fileCache;
    private boolean returnDefaultValues;

    @TaskAction
    public void createMockableJar() throws IOException, ExecutionException {
        File outputFile = this.getOutputFile();
        if (this.fileCache != null) {
            this.fileCache.createFile(outputFile, this.getCacheInputs(), this::doCreateMockableJar);
        } else {
            this.doCreateMockableJar();
        }
    }

    @Input
    public boolean getReturnDefaultValues() {
        return this.returnDefaultValues;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public File getAndroidJar() {
        return this.androidJar;
    }

    private void doCreateMockableJar() throws IOException {
        MockableJarGenerator generator = new MockableJarGenerator(this.getReturnDefaultValues());
        this.getLogger().info(String.format("Creating %s from %s.", this.outputFile.getAbsolutePath(), this.androidJar.getAbsolutePath()));
        generator.createMockableJar(this.getAndroidJar(), this.outputFile);
    }

    private FileCache.Inputs getCacheInputs() {
        return new FileCache.Inputs.Builder(FileCache.Command.GENERATE_MOCKABLE_JAR).putString("fileName", this.outputFile.getName()).putFile("platformJar", this.androidJar, FileCache.FileProperties.PATH_SIZE_TIMESTAMP).build();
    }

    public static class ConfigAction
    implements TaskConfigAction<MockableAndroidJarTask> {
        private final GlobalScope scope;

        public ConfigAction(GlobalScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return "mockableAndroidJar";
        }

        @Override
        public Class<MockableAndroidJarTask> getType() {
            return MockableAndroidJarTask.class;
        }

        @Override
        public void execute(MockableAndroidJarTask task) {
            task.setGroup("build");
            task.setDescription("Creates a version of android.jar that's suitable for unit tests.");
            task.returnDefaultValues = this.scope.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues();
            task.androidJar = new File(this.scope.getAndroidBuilder().getTarget().getPath(1));
            task.outputFile = this.scope.getMockableAndroidJarFile();
            this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.MOCKABLE_JAR, (Collection<? extends File>)ImmutableList.of((Object)task.outputFile), (Task)task);
            task.fileCache = this.scope.getBuildCache();
        }
    }
}

