/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.MainDexListTransform;
import com.android.builder.multidex.D8MainDexList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004BA\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0011H\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0011H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/build/gradle/internal/transforms/D8MainDexListTransform;", "Lcom/android/build/api/transform/Transform;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "manifestProguardRules", "Ljava/nio/file/Path;", "userProguardRules", "userClasses", "outputMainDexList", "bootClasspath", "Ljava/util/function/Supplier;", "", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/function/Supplier;)V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getInputTypes", "Lcom/google/common/collect/ImmutableSet;", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getParameterInputs", "Lcom/google/common/collect/ImmutableMap;", "", "getReferencedScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "getSecondaryFileOutputs", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "getSecondaryFiles", "", "Lcom/android/build/api/transform/SecondaryFile;", "isCacheable", "", "isIncremental", "transform", "", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle"})
public final class D8MainDexListTransform
extends Transform {
    private final LoggerWrapper logger;
    private final Path manifestProguardRules;
    private final Path userProguardRules;
    private final Path userClasses;
    private final Path outputMainDexList;
    private final Supplier<List<Path>> bootClasspath;

    @NotNull
    public String getName() {
        return "multidexlist";
    }

    @NotNull
    public ImmutableSet<? extends QualifiedContent.ContentType> getInputTypes() {
        ImmutableSet immutableSet = Sets.immutableEnumSet((Enum)((Enum)QualifiedContent.DefaultContentType.CLASSES), (Enum[])new QualifiedContent.DefaultContentType[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"Sets.immutableEnumSet(Qu\u2026faultContentType.CLASSES)");
        return immutableSet;
    }

    @NotNull
    public ImmutableSet<? super QualifiedContent.Scope> getScopes() {
        ImmutableSet immutableSet = ImmutableSet.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
        return immutableSet;
    }

    @NotNull
    public ImmutableSet<? super QualifiedContent.Scope> getReferencedScopes() {
        ImmutableSet immutableSet = Sets.immutableEnumSet((Enum)((Enum)QualifiedContent.Scope.PROJECT), (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.TESTED_CODE});
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"Sets.immutableEnumSet(\n \u2026       Scope.TESTED_CODE)");
        return immutableSet;
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        void var3_3;
        File file;
        File it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOfNotNull((Object[])new Path[]{this.manifestProguardRules, this.userProguardRules, this.userClasses});
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Path path = (Path)item$iv$iv;
            collection = destination$iv$iv;
            file = it.toFile();
            collection.add(file);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            file = SecondaryFile.nonIncremental((File)it);
            collection.add(file);
        }
        return CollectionsKt.toCollection((Iterable)((List)var3_3), (Collection)new ArrayList());
    }

    @NotNull
    public ImmutableList<File> getSecondaryFileOutputs() {
        ImmutableList immutableList = ImmutableList.of((Object)this.outputMainDexList.toFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(outputMainDexList.toFile())");
        return immutableList;
    }

    @NotNull
    public ImmutableMap<String, Object> getParameterInputs() {
        ImmutableMap immutableMap = ImmutableMap.of((Object)"implementation", (Object)D8MainDexListTransform.class.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of(\"impleme\u2026ansform::class.java.name)");
        return immutableMap;
    }

    /*
     * WARNING - void declaration
     */
    public void transform(@NotNull TransformInvocation invocation) {
        Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
        this.logger.verbose("Generating the main dex list using D8.", new Object[0]);
        try {
            void $receiver$iv$iv;
            Object item$iv$iv3;
            void $receiver$iv$iv2;
            Object object;
            Collection collection;
            void $receiver$iv$iv3;
            Iterable $receiver$iv;
            Map<MainDexListTransform.ProguardInput, Set<File>> inputs = MainDexListTransform.getByInputType(invocation);
            Set<File> set = inputs.get((Object)MainDexListTransform.ProguardInput.INPUT_JAR);
            if (set == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = $receiver$iv = (Iterable)set;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv3) {
                void it;
                File file = (File)item$iv$iv2;
                collection = destination$iv$iv;
                object = it.toPath();
                collection.add(object);
            }
            List programFiles = (List)destination$iv$iv;
            Set<File> set2 = inputs.get((Object)MainDexListTransform.ProguardInput.LIBRARY_JAR);
            if (set2 == null) {
                Intrinsics.throwNpe();
            }
            Iterable $receiver$iv2 = set2;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv3 : $receiver$iv$iv2) {
                void it;
                File $i$a$1$map = (File)item$iv$iv3;
                collection = destination$iv$iv2;
                object = it.toPath();
                collection.add(object);
            }
            Collection collection2 = (List)destination$iv$iv2;
            List<Path> list = this.bootClasspath.get();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"bootClasspath.get()");
            List libraryFiles = CollectionsKt.plus((Collection)collection2, (Iterable)list);
            this.logger.verbose("Program files: %s", CollectionsKt.joinToString$default((Iterable)programFiles, null, null, null, (int)0, null, null, (int)63, null));
            this.logger.verbose("Library files: %s", CollectionsKt.joinToString$default((Iterable)libraryFiles, null, null, null, (int)0, null, null, (int)63, null));
            this.logger.verbose("Proguard rule files: %s", CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])new Path[]{this.manifestProguardRules, this.userProguardRules}), null, null, null, (int)0, null, null, (int)63, null));
            List proguardRules = CollectionsKt.listOfNotNull((Object[])new Path[]{this.manifestProguardRules, this.userProguardRules});
            Set mainDexClasses = new LinkedHashSet();
            List<String> list2 = MainDexListTransform.getPlatformRules();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"MainDexListTransform.getPlatformRules()");
            Iterable $receiver$iv3 = list2;
            item$iv$iv3 = $receiver$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv4 : $receiver$iv$iv) {
                void it;
                String $i$f$map = (String)item$iv$iv4;
                collection = destination$iv$iv3;
                object = "-keep " + (String)it;
                collection.add(object);
            }
            List keepRules = (List)destination$iv$iv3;
            List list3 = D8MainDexList.generate((List)keepRules, (List)proguardRules, (Collection)programFiles, (Collection)libraryFiles);
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"D8MainDexList.generate(\n\u2026            libraryFiles)");
            mainDexClasses.addAll(list3);
            if (this.userClasses != null) {
                List<String> list4 = Files.readAllLines(this.userClasses);
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"Files.readAllLines(userClasses)");
                mainDexClasses.addAll((Collection)list4);
            }
            Files.deleteIfExists(this.outputMainDexList);
            Files.write(this.outputMainDexList, (Iterable<? extends CharSequence>)mainDexClasses, new OpenOption[0]);
        }
        catch (D8MainDexList.MainDexListException e) {
            throw (Throwable)new TransformException("Error while generating the main dex list.", (Throwable)e);
        }
    }

    public D8MainDexListTransform(@NotNull Path manifestProguardRules, @Nullable Path userProguardRules, @Nullable Path userClasses, @NotNull Path outputMainDexList, @NotNull Supplier<List<Path>> bootClasspath) {
        Intrinsics.checkParameterIsNotNull((Object)manifestProguardRules, (String)"manifestProguardRules");
        Intrinsics.checkParameterIsNotNull((Object)outputMainDexList, (String)"outputMainDexList");
        Intrinsics.checkParameterIsNotNull(bootClasspath, (String)"bootClasspath");
        this.manifestProguardRules = manifestProguardRules;
        this.userProguardRules = userProguardRules;
        this.userClasses = userClasses;
        this.outputMainDexList = outputMainDexList;
        this.bootClasspath = bootClasspath;
        this.logger = LoggerWrapper.getLogger(D8MainDexListTransform.class);
    }

    public /* synthetic */ D8MainDexListTransform(Path path, Path path2, Path path3, Path path4, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path2 = null;
        }
        if ((n & 4) != 0) {
            path3 = null;
        }
        this(path, path2, path3, path4, supplier);
    }

    public D8MainDexListTransform(final @NotNull VariantScope variantScope) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        Path path = variantScope.getManifestKeepListProguardFile().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"variantScope.manifestKeepListProguardFile.toPath()");
        GradleVariantConfiguration gradleVariantConfiguration = variantScope.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
        File file = gradleVariantConfiguration.getMultiDexKeepProguard();
        Path path2 = file != null ? file.toPath() : null;
        GradleVariantConfiguration gradleVariantConfiguration2 = variantScope.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration2, (String)"variantScope.variantConfiguration");
        File file2 = gradleVariantConfiguration2.getMultiDexKeepFile();
        Path path3 = file2 != null ? file2.toPath() : null;
        Path path4 = variantScope.getMainDexListFile().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"variantScope.mainDexListFile.toPath()");
        this(path, path2, path3, path4, (Supplier<List<Path>>)new Supplier<List<? extends Path>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public final List<Path> get() {
                void var3_3;
                void $receiver$iv$iv;
                GlobalScope globalScope = variantScope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope\n           \u2026             .globalScope");
                List list = globalScope.getAndroidBuilder().getBootClasspath(true);
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variantScope\n           \u2026  .getBootClasspath(true)");
                Iterable $receiver$iv = list;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Path path = it.toPath();
                    collection.add(path);
                }
                return (List)var3_3;
            }
        });
    }
}

