/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.Aapt2ProcessResourcesRunnable;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.BlockingResourceLinker;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;

public class GenerateSplitAbiRes
extends AndroidBuilderTask {
    private final WorkerExecutorFacade workers;
    private Supplier<String> applicationId;
    private String outputBaseName;
    private Supplier<String> versionName;
    private IntSupplier versionCode;
    private AaptGeneration aaptGeneration;
    private Set<String> splits;
    private File outputDirectory;
    private boolean debuggable;
    private AaptOptions aaptOptions;
    private OutputFactory outputFactory;
    private VariantType variantType;
    private VariantScope variantScope;
    Supplier<String> featureNameSupplier;
    private FileCollection applicationIdOverride;
    private FileCollection aapt2FromMaven;

    @Inject
    public GenerateSplitAbiRes(WorkerExecutor workerExecutor) {
        this.workers = Workers.INSTANCE.getWorker(workerExecutor);
    }

    @Input
    public String getApplicationId() {
        return this.applicationId.get();
    }

    @Input
    public int getVersionCode() {
        return this.versionCode.getAsInt();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName.get();
    }

    @Input
    public String getAaptGeneration() {
        return this.aaptGeneration.name();
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    @Input
    @Optional
    public String getFeatureName() {
        return this.featureNameSupplier != null ? this.featureNameSupplier.get() : null;
    }

    @InputFiles
    @Optional
    public FileCollection getApplicationIdOverride() {
        return this.applicationIdOverride;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    @TaskAction
    protected void doFullTaskAction() throws IOException, InterruptedException, ProcessException {
        ImmutableList.Builder buildOutputs = ImmutableList.builder();
        try (WorkerExecutorFacade workerExecutor = this.workers;){
            for (String split : this.getSplits()) {
                File resPackageFile = this.getOutputFileForSplit(split);
                ApkData abiApkData = this.outputFactory.addConfigurationSplit(VariantOutput.FilterType.ABI, split, resPackageFile.getName());
                abiApkData.setVersionCode(this.variantScope.getVariantConfiguration().getVersionCodeSerializableSupplier());
                abiApkData.setVersionName(this.variantScope.getVariantConfiguration().getVersionNameSerializableSupplier());
                if (this.variantScope.getVariantData().variantOutputFactory != null) {
                    this.variantScope.getVariantData().variantOutputFactory.create(abiApkData);
                }
                File manifestFile = this.generateSplitManifest(split, abiApkData);
                AndroidBuilder builder = this.getBuilder();
                AaptPackageConfig aaptConfig = new AaptPackageConfig.Builder().setManifestFile(manifestFile).setOptions(DslAdaptersKt.convert(this.aaptOptions)).setDebuggable(this.debuggable).setResourceOutputApk(resPackageFile).setVariantType(this.variantType).setAndroidTarget(builder.getTarget()).build();
                if (this.aaptGeneration == AaptGeneration.AAPT_V2_DAEMON_SHARED_POOL) {
                    Aapt2ServiceKey aapt2ServiceKey = Aapt2DaemonManagerService.registerAaptService(this.aapt2FromMaven, builder.getBuildToolInfo(), builder.getLogger());
                    Aapt2ProcessResourcesRunnable.Params params = new Aapt2ProcessResourcesRunnable.Params(aapt2ServiceKey, aaptConfig);
                    workerExecutor.submit(Aapt2ProcessResourcesRunnable.class, (Serializable)params);
                } else {
                    try (Aapt aapt = this.makeAapt(builder);){
                        AndroidBuilder.processResources((BlockingResourceLinker)aapt, (AaptPackageConfig)aaptConfig, (ILogger)builder.getLogger());
                    }
                }
                buildOutputs.add((Object)new BuildOutput(InternalArtifactType.ABI_PROCESSED_SPLIT_RES, (ApkInfo)abiApkData, resPackageFile));
            }
        }
        new BuildElements((Collection<BuildOutput>)buildOutputs.build()).save(this.outputDirectory);
    }

    private Aapt makeAapt(AndroidBuilder builder) {
        return AaptGradleFactory.make(this.aaptGeneration, builder, (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new AaptGradleFactory.FilteringLogger(builder.getLogger())), true, this.variantScope.getGlobalScope().getExtension().getAaptOptions().getCruncherProcesses());
    }

    File generateSplitManifest(String split, ApkData abiApkData) throws IOException {
        CharMatcher charMatcher = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'.')).negate();
        String featureName = this.getFeatureName();
        String encodedSplitName = (featureName != null ? featureName + "." : "") + "config." + charMatcher.replaceFrom((CharSequence)split, '_');
        File tmpDirectory = new File(this.outputDirectory, split);
        FileUtils.mkdirs((File)tmpDirectory);
        File tmpFile = new File(tmpDirectory, "AndroidManifest.xml");
        String versionNameToUse = abiApkData.getVersionName();
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(abiApkData.getVersionCode());
        }
        String manifestAppId = this.applicationIdOverride != null && !this.applicationIdOverride.isEmpty() ? ApplicationId.load(this.applicationIdOverride.getSingleFile()).getApplicationId() : this.applicationId.get();
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), "UTF-8");){
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + manifestAppId + "\"\n      android:versionCode=\"" + abiApkData.getVersionCode() + "\"\n      android:versionName=\"" + versionNameToUse + "\"\n");
            if (featureName != null) {
                fileWriter.append("      configForSplit=\"" + featureName + "\"\n");
            }
            fileWriter.append("      split=\"" + encodedSplitName + "\"\n      targetABI=\"" + split + "\">\n       <uses-sdk android:minSdkVersion=\"21\"/>\n</manifest> ");
            fileWriter.flush();
        }
        return tmpFile;
    }

    private File getOutputFileForSplit(String split) {
        return new File(this.outputDirectory, "resources-" + this.getOutputBaseName() + "-" + split + ".ap_");
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateSplitAbiRes> {
        private final VariantScope scope;
        private final FeatureSetMetadata.SupplierProvider provider;

        public ConfigAction(VariantScope scope) {
            this(scope, FeatureSetMetadata.getInstance());
        }

        ConfigAction(VariantScope scope, FeatureSetMetadata.SupplierProvider provider) {
            this.scope = scope;
            this.provider = provider;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "SplitAbiRes");
        }

        @Override
        public Class<GenerateSplitAbiRes> getType() {
            return GenerateSplitAbiRes.class;
        }

        @Override
        public void execute(GenerateSplitAbiRes generateSplitAbiRes) {
            GradleVariantConfiguration config2 = this.scope.getVariantConfiguration();
            VariantType variantType = config2.getType();
            generateSplitAbiRes.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            generateSplitAbiRes.setVariantName(config2.getFullName());
            if (variantType.isFeatureSplit()) {
                generateSplitAbiRes.featureNameSupplier = this.provider.getFeatureNameSupplierForTask(this.scope, (Task)generateSplitAbiRes);
            }
            generateSplitAbiRes.versionCode = config2::getVersionCode;
            generateSplitAbiRes.versionName = config2::getVersionName;
            generateSplitAbiRes.aaptGeneration = AaptGeneration.fromProjectOptions(this.scope.getGlobalScope().getProjectOptions());
            generateSplitAbiRes.variantScope = this.scope;
            generateSplitAbiRes.variantType = variantType;
            generateSplitAbiRes.outputDirectory = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.ABI_PROCESSED_SPLIT_RES, (Task)generateSplitAbiRes, "out");
            generateSplitAbiRes.splits = AbiSplitOptions.getAbiFilters(this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
            generateSplitAbiRes.outputBaseName = config2.getBaseName();
            generateSplitAbiRes.applicationId = config2::getApplicationId;
            generateSplitAbiRes.debuggable = config2.getBuildType().isDebuggable();
            generateSplitAbiRes.aaptOptions = this.scope.getGlobalScope().getExtension().getAaptOptions();
            generateSplitAbiRes.outputFactory = this.scope.getVariantData().getOutputFactory();
            generateSplitAbiRes.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMavenIfEnabled(this.scope.getGlobalScope());
            if (variantType.isBaseModule() && variantType.isHybrid()) {
                generateSplitAbiRes.applicationIdOverride = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_APP_ID_DECLARATION);
            } else if (variantType.isFeatureSplit()) {
                generateSplitAbiRes.applicationIdOverride = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION);
            }
        }
    }
}

