/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.build.gradle.internal.transforms.MainDexListTransform;
import com.android.build.gradle.internal.transforms.MainDexListWriter;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.ProcessException;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.jetbrains.annotations.NotNull;
import proguard.ParseException;

public class MultiDexTransform
extends BaseProguardAction
implements MainDexListWriter {
    private final BuildableArtifact manifestKeepListProguardFile;
    private final File userMainDexKeepProguard;
    private final File userMainDexKeepFile;
    private final VariantScope variantScope;
    private final boolean keepRuntimeAnnotatedClasses;
    private final File configFileOut;
    private File mainDexListFile;

    public MultiDexTransform(VariantScope variantScope, DexOptions dexOptions) {
        super(variantScope);
        this.manifestKeepListProguardFile = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LEGACY_MULTIDEX_AAPT_DERIVED_PROGUARD_RULES);
        this.userMainDexKeepProguard = variantScope.getVariantConfiguration().getMultiDexKeepProguard();
        this.userMainDexKeepFile = variantScope.getVariantConfiguration().getMultiDexKeepFile();
        this.variantScope = variantScope;
        this.configFileOut = new File(variantScope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/multi-dex/" + variantScope.getVariantConfiguration().getDirName() + "/components.flags");
        this.keepRuntimeAnnotatedClasses = dexOptions.getKeepRuntimeAnnotatedClasses();
    }

    @Override
    public void setMainDexListOutputFile(@NotNull File file) {
        this.mainDexListFile = file;
    }

    public String getName() {
        return "multidexlist";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    @Override
    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROVIDED_ONLY, QualifiedContent.Scope.TESTED_CODE});
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)SecondaryFile.nonIncremental((Supplier)this.manifestKeepListProguardFile));
        if (this.userMainDexKeepFile != null) {
            builder.add((Object)SecondaryFile.nonIncremental((File)this.userMainDexKeepFile));
        }
        if (this.userMainDexKeepProguard != null) {
            builder.add((Object)SecondaryFile.nonIncremental((File)this.userMainDexKeepProguard));
        }
        return builder.build();
    }

    public Map<String, Object> getParameterInputs() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"keepRuntimeAnnotatedClasses", (Object)this.keepRuntimeAnnotatedClasses);
        TargetInfo targetInfo = this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo();
        if (targetInfo != null) {
            params.put((Object)"build_tools", (Object)targetInfo.getBuildTools().getRevision().toString());
        }
        return params.build();
    }

    public Collection<File> getSecondaryFileOutputs() {
        return Lists.newArrayList((Object[])new File[]{this.mainDexListFile, this.configFileOut});
    }

    public boolean isIncremental() {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        LoggingManager loggingManager = invocation.getContext().getLogging();
        loggingManager.captureStandardOutput(LogLevel.INFO);
        loggingManager.captureStandardError(LogLevel.WARN);
        try {
            Map<MainDexListTransform.ProguardInput, Set<File>> inputs = MainDexListTransform.getByInputType(invocation);
            File input = (File)Iterables.getOnlyElement((Iterable)inputs.get((Object)MainDexListTransform.ProguardInput.INPUT_JAR));
            this.shrinkWithProguard(input, inputs.get((Object)MainDexListTransform.ProguardInput.LIBRARY_JAR));
            this.computeList(input);
        }
        catch (ProcessException | ParseException e) {
            throw new TransformException(e);
        }
    }

    private void shrinkWithProguard(File input, Set<File> libraryJars) throws IOException, ParseException {
        this.configuration.obfuscate = false;
        this.configuration.optimize = false;
        this.configuration.preverify = false;
        this.dontwarn();
        this.dontnote();
        this.forceprocessing();
        this.applyConfigurationFile(BuildableArtifactUtil.singleFile(this.manifestKeepListProguardFile));
        if (this.userMainDexKeepProguard != null) {
            this.applyConfigurationFile(this.userMainDexKeepProguard);
        }
        MainDexListTransform.getPlatformRules().forEach(this::keep);
        this.libraryJar(this.findShrinkedAndroidJar());
        libraryJars.forEach(this::libraryJar);
        this.inJar(input, null);
        this.outJar(this.variantScope.getProguardComponentsJarFile());
        this.printconfiguration(this.configFileOut);
        this.runProguard();
    }

    private File findShrinkedAndroidJar() {
        Preconditions.checkNotNull((Object)this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo());
        File shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "lib" + File.separatorChar + "shrinkedAndroid.jar");
        if (!shrinkedAndroid.isFile()) {
            shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "multidex" + File.separatorChar + "shrinkedAndroid.jar");
        }
        return shrinkedAndroid;
    }

    private void computeList(File _allClassesJarFile) throws ProcessException, IOException {
        ImmutableSet mainDexClasses = this.callDx(_allClassesJarFile, this.variantScope.getProguardComponentsJarFile());
        if (this.userMainDexKeepFile != null) {
            mainDexClasses = ImmutableSet.builder().addAll(mainDexClasses).addAll((Iterable)Files.readLines((File)this.userMainDexKeepFile, (Charset)Charsets.UTF_8)).build();
        }
        String fileContent = Joiner.on((String)System.getProperty("line.separator")).join(mainDexClasses);
        Files.write((CharSequence)fileContent, (File)this.mainDexListFile, (Charset)Charsets.UTF_8);
    }

    private Set<String> callDx(File allClassesJarFile, File jarOfRoots) throws ProcessException {
        EnumSet<AndroidBuilder.MainDexListOption> mainDexListOptions = EnumSet.noneOf(AndroidBuilder.MainDexListOption.class);
        if (!this.keepRuntimeAnnotatedClasses) {
            mainDexListOptions.add(AndroidBuilder.MainDexListOption.DISABLE_ANNOTATION_RESOLUTION_WORKAROUND);
            Logging.getLogger(MultiDexTransform.class).warn("Not including classes with runtime retention annotations in the main dex.\nThis can cause issues with reflection in older platforms.");
        }
        return this.variantScope.getGlobalScope().getAndroidBuilder().createMainDexList(allClassesJarFile, jarOfRoots, mainDexListOptions);
    }
}

