/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.build.gradle.AbstractAppPlugin;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.internal.AppModelBuilder;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.NativeLibraryFactoryImpl;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.options.BooleanOption;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class AppPlugin
extends AbstractAppPlugin {
    @Inject
    public AppPlugin(ToolingModelBuilderRegistry registry) {
        super(registry, true);
    }

    @Override
    public void apply(Project project) {
        super.apply(project);
        Configuration featureSplit = (Configuration)project.getConfigurations().maybeCreate("feature");
        featureSplit.setCanBeConsumed(false);
        featureSplit.setCanBeResolved(false);
        featureSplit.getAllDependencies().whenObjectAdded((Action)new DeprecatedConfigurationAction("android.dynamicFeatures", "feature", this.extraModelInfo.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.FEATURE_CONFIG));
        if (this.projectOptions.get(BooleanOption.ENABLE_DYNAMIC_APPS)) {
            this.taskManager.getTaskFactory().create("bundle");
        }
    }

    @Override
    protected void registerModelBuilder(ToolingModelBuilderRegistry registry, GlobalScope globalScope, VariantManager variantManager, AndroidConfig config2, ExtraModelInfo extraModelInfo) {
        registry.register((ToolingModelBuilder)new AppModelBuilder(globalScope, this.androidBuilder, variantManager, this.taskManager, (BaseAppModuleExtension)config2, extraModelInfo, this.ndkHandler, (NativeLibraryFactory)new NativeLibraryFactoryImpl(this.ndkHandler), this.getProjectType(), 1));
    }

    @Override
    protected Class<? extends AppExtension> getExtensionClass() {
        return BaseAppModuleExtension.class;
    }

    private static class DeprecatedConfigurationAction
    implements Action<Dependency> {
        private final String newDslElement;
        private final String configName;
        private final DeprecationReporter deprecationReporter;
        private final DeprecationReporter.DeprecationTarget target;
        private boolean warningPrintedAlready = false;

        public DeprecatedConfigurationAction(String newDslElement, String configName, DeprecationReporter deprecationReporter, DeprecationReporter.DeprecationTarget target) {
            this.newDslElement = newDslElement;
            this.configName = configName;
            this.deprecationReporter = deprecationReporter;
            this.target = target;
        }

        public void execute(Dependency dependency) {
            if (!this.warningPrintedAlready) {
                this.warningPrintedAlready = true;
                this.deprecationReporter.reportDeprecatedConfiguration(this.newDslElement, this.configName, this.target);
            }
        }
    }
}

