/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.featuresplit;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTaskKt;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.build.gradle.options.IntegerOption;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0007J\b\u0010\u001f\u001a\u00020 H\u0007R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0007@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR&\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00138\u0007@@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "inputFiles", "getInputFiles", "()Lorg/gradle/api/file/FileCollection;", "setInputFiles$gradle", "(Lorg/gradle/api/file/FileCollection;)V", "", "maxNumberOfFeaturesBeforeOreo", "getMaxNumberOfFeaturesBeforeOreo", "()I", "setMaxNumberOfFeaturesBeforeOreo$gradle", "(I)V", "minSdkVersion", "getMinSdkVersion", "setMinSdkVersion$gradle", "Ljava/io/File;", "outputFile", "getOutputFile", "()Ljava/io/File;", "setOutputFile$gradle", "(Ljava/io/File;)V", "computeFeatureNames", "", "", "features", "", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSplitDeclaration;", "fullTaskAction", "", "ConfigAction", "gradle"})
public class FeatureSetMetadataWriterTask
extends AndroidVariantTask {
    @NotNull
    public FileCollection inputFiles;
    @NotNull
    public File outputFile;
    @Input
    private int minSdkVersion = 1;
    @Input
    private int maxNumberOfFeaturesBeforeOreo;

    @InputFiles
    @NotNull
    public final FileCollection getInputFiles() {
        FileCollection fileCollection = this.inputFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFiles");
        }
        return fileCollection;
    }

    public final void setInputFiles$gradle(@NotNull FileCollection fileCollection) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection, (String)"<set-?>");
        this.inputFiles = fileCollection;
    }

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    public final void setOutputFile$gradle(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputFile = file;
    }

    public final int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public final void setMinSdkVersion$gradle(int n) {
        this.minSdkVersion = n;
    }

    public final int getMaxNumberOfFeaturesBeforeOreo() {
        return this.maxNumberOfFeaturesBeforeOreo;
    }

    public final void setMaxNumberOfFeaturesBeforeOreo$gradle(int n) {
        this.maxNumberOfFeaturesBeforeOreo = n;
    }

    @TaskAction
    public final void fullTaskAction() throws IOException {
        FeatureSetMetadata featureMetadata = new FeatureSetMetadata(this.maxNumberOfFeaturesBeforeOreo);
        FileCollection fileCollection = this.inputFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputFiles");
        }
        FileTree fileTree = fileCollection.getAsFileTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"inputFiles.asFileTree");
        Set featureFiles = fileTree.getFiles();
        List features = new ArrayList();
        for (File file : featureFiles) {
            try {
                FeatureSplitDeclaration featureSplitDeclaration = FeatureSplitDeclaration.load(file);
                Intrinsics.checkExpressionValueIsNotNull((Object)featureSplitDeclaration, (String)"FeatureSplitDeclaration.load(file)");
                features.add(featureSplitDeclaration);
            }
            catch (FileNotFoundException e) {
                throw (Throwable)new BuildException("Cannot read features split declaration file", (Throwable)e);
            }
        }
        Map<String, String> featureNameMap = this.computeFeatureNames(features);
        for (FeatureSplitDeclaration feature : features) {
            String string = feature.getModulePath();
            String string2 = featureNameMap.get(feature.getModulePath());
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            featureMetadata.addFeatureSplit(this.minSdkVersion, string, string2);
        }
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        featureMetadata.save(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> computeFeatureNames(@NotNull List<? extends FeatureSplitDeclaration> features) {
        Map leafMap;
        FeatureSplitDeclaration it;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(features, (String)"features");
        Map result = new LinkedHashMap();
        Iterable entry = features;
        Iterable iterable = entry;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            it = (FeatureSplitDeclaration)element$iv$iv;
            String string = it.getModulePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.modulePath");
            String key$iv$iv = FeatureSetMetadataWriterTaskKt.access$getLeaf(string);
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            it = (FeatureSplitDeclaration)element$iv$iv;
            List list = list$iv$iv;
            String string2 = it.getModulePath();
            list.add(string2);
        }
        destination$iv$iv = leafMap = destination$iv$iv;
        for (Map.Entry entry2 : destination$iv$iv.entrySet()) {
            Object element$iv$iv;
            element$iv$iv = entry2;
            String leaf = (String)element$iv$iv.getKey();
            element$iv$iv = entry2;
            List modules = (List)element$iv$iv.getValue();
            if (modules.size() == 1) {
                element$iv$iv = result;
                Intrinsics.checkExpressionValueIsNotNull(modules.get(0), (String)"modules[0]");
                String string = leaf;
                element$iv$iv.put(it, string);
                continue;
            }
            StringBuilder message = new StringBuilder("Module name '" + leaf + "' is used by multiple modules. All dynamic features must have a unique name.");
            for (String module : modules) {
                message.append("\n\t-> " + module);
            }
            throw (Throwable)new RuntimeException(message.toString());
        }
        return result;
    }

    public FeatureSetMetadataWriterTask() {
        Integer n = FeatureSetMetadata.MAX_NUMBER_OF_SPLITS_BEFORE_O;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"FeatureSetMetadata.MAX_NUMBER_OF_SPLITS_BEFORE_O");
        this.maxNumberOfFeaturesBeforeOreo = n;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/featuresplit/FeatureSetMetadataWriterTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<FeatureSetMetadataWriterTask> {
        private final VariantScope variantScope;

        @Override
        @NotNull
        public String getName() {
            String string = this.variantScope.getTaskName("generate", "FeatureMetadata");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026rate\", \"FeatureMetadata\")");
            return string;
        }

        @Override
        @NotNull
        public Class<FeatureSetMetadataWriterTask> getType() {
            return FeatureSetMetadataWriterTask.class;
        }

        @Override
        public void execute(@NotNull FeatureSetMetadataWriterTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.variantScope.getFullVariantName());
            AndroidVersion androidVersion = this.variantScope.getMinSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"variantScope.minSdkVersion");
            task.setMinSdkVersion$gradle(androidVersion.getApiLevel());
            task.setOutputFile$gradle(this.variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.FEATURE_SET_METADATA, (Task)task, "feature-metadata.json"));
            FileCollection fileCollection = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_FEATURE_DECLARATION);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getArtifact\u2026DECLARATION\n            )");
            task.setInputFiles$gradle(fileCollection);
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            Integer maxNumberOfFeaturesBeforeOreo = globalScope.getProjectOptions().get(IntegerOption.PRE_O_MAX_NUMBER_OF_FEATURES);
            if (maxNumberOfFeaturesBeforeOreo != null) {
                task.setMaxNumberOfFeaturesBeforeOreo$gradle(Integer.min(100, maxNumberOfFeaturesBeforeOreo));
            }
        }

        public ConfigAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            this.variantScope = variantScope;
        }
    }
}

