/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ide.ArtifactDependencyGraph;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class AndroidDependenciesRenderer
extends TextReportRenderer {
    private boolean hasConfigs;
    private boolean hasCyclicDependencies;
    private GraphRenderer renderer;

    public void startProject(Project project) {
        super.startProject(project);
        this.hasConfigs = false;
        this.hasCyclicDependencies = false;
    }

    public void completeProject(Project project) {
        if (!this.hasConfigs) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No dependencies");
        }
        super.completeProject(project);
    }

    public void startVariant(VariantScope variantScope) {
        if (this.hasConfigs) {
            this.getTextOutput().println();
        }
        this.hasConfigs = true;
        this.renderer = new GraphRenderer(this.getTextOutput());
        this.renderer.visit(styledTextOutput -> this.getTextOutput().withStyle(StyledTextOutput.Style.Header).text((Object)variantScope.getFullVariantName()), true);
    }

    public void render(VariantScope variant) {
        ImmutableMap<String, String> buildMapping = ModelBuilder.computeBuildMapping(variant.getGlobalScope().getProject().getGradle());
        Set<ArtifactDependencyGraph.HashableResolvedArtifactResult> compileArtifacts = ArtifactDependencyGraph.getAllArtifacts(variant, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, null, buildMapping);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)variant.getVariantDependencies().getCompileClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for compilation");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ArtifactDependencyGraph.HashableResolvedArtifactResult>)ImmutableList.copyOf(compileArtifacts));
        this.renderer.completeChildren();
        Set<ArtifactDependencyGraph.HashableResolvedArtifactResult> runtimeArtifacts = ArtifactDependencyGraph.getAllArtifacts(variant, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, null, buildMapping);
        this.getTextOutput().println();
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)variant.getVariantDependencies().getRuntimeClasspath().getName());
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).text((Object)" - Dependencies for runtime/packaging");
        this.getTextOutput().println();
        this.renderer.startChildren();
        this.render((List<ArtifactDependencyGraph.HashableResolvedArtifactResult>)ImmutableList.copyOf(runtimeArtifacts));
        this.renderer.completeChildren();
    }

    public void complete() {
        if (this.hasCyclicDependencies) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"\n(*) - dependencies omitted (listed previously)");
        }
        super.complete();
    }

    private void render(List<ArtifactDependencyGraph.HashableResolvedArtifactResult> artifacts) {
        int count = artifacts.size();
        for (int i = 0; i < count; ++i) {
            ArtifactDependencyGraph.HashableResolvedArtifactResult artifact = artifacts.get(i);
            this.renderer.visit(styledTextOutput -> {
                String text;
                ComponentIdentifier id = artifact.getId().getComponentIdentifier();
                if (id instanceof ProjectComponentIdentifier) {
                    if (artifact.isWrappedModule()) {
                        String project = ((ProjectComponentIdentifier)id).getProjectPath();
                        String file = artifact.getFile().getAbsolutePath();
                        text = String.format("%s (file: %s)", project, file);
                    } else if (artifact.getDependencyType() == ArtifactDependencyGraph.DependencyType.ANDROID) {
                        String project = ((ProjectComponentIdentifier)id).getProjectPath();
                        String variant = ArtifactDependencyGraph.getVariant(artifact);
                        text = String.format("%s (variant: %s)", project, variant);
                    } else {
                        text = ((ProjectComponentIdentifier)id).getProjectPath();
                    }
                } else {
                    text = id instanceof ModuleComponentIdentifier ? ArtifactDependencyGraph.computeAddress(artifact) : artifact.getFile().getAbsolutePath();
                }
                this.getTextOutput().text((Object)text);
            }, i == count - 1);
        }
    }
}

