/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res;

import com.android.SdkConstants;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.Aapt2Version;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.StringOption;
import com.android.builder.model.Version;
import com.google.common.base.Strings;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"AAPT2_CONFIG_NAME", "", "TYPE_EXTRACTED_AAPT2_BINARY", "getAapt2FromMaven", "Lorg/gradle/api/file/FileCollection;", "globalScope", "Lcom/android/build/gradle/internal/scope/GlobalScope;", "project", "Lorg/gradle/api/Project;", "getAapt2FromMavenIfEnabled", "getArtifactCollection", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "gradle"})
@JvmName(name="Aapt2MavenUtils")
public final class Aapt2MavenUtils {
    private static final String TYPE_EXTRACTED_AAPT2_BINARY = "_internal-android-aapt2-binary";
    private static final String AAPT2_CONFIG_NAME = "_internal_aapt2_binary";

    @Nullable
    public static final FileCollection getAapt2FromMavenIfEnabled(@NotNull GlobalScope globalScope) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        if (!globalScope.getProjectOptions().get(BooleanOption.USE_AAPT2_FROM_MAVEN)) {
            return null;
        }
        return Aapt2MavenUtils.getAapt2FromMaven(globalScope);
    }

    @NotNull
    public static final FileCollection getAapt2FromMaven(@NotNull GlobalScope globalScope) {
        Intrinsics.checkParameterIsNotNull((Object)globalScope, (String)"globalScope");
        String customAapt2 = globalScope.getProjectOptions().get(StringOption.AAPT2_FROM_MAVEN_OVERRIDE);
        if (!Strings.isNullOrEmpty((String)customAapt2)) {
            String string = customAapt2;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"customAapt2!!");
            String string2 = SdkConstants.FN_AAPT2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SdkConstants.FN_AAPT2");
            if (!StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                String string3 = "Custom AAPT2 location does not point to an AAPT2 executable: " + customAapt2;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            ConfigurableFileCollection configurableFileCollection = globalScope.getProject().files(new Object[]{new File(customAapt2).getParentFile()});
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"globalScope.project.file\u2026(customAapt2).parentFile)");
            return (FileCollection)configurableFileCollection;
        }
        Project project = globalScope.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"globalScope.project");
        return Aapt2MavenUtils.getAapt2FromMaven(project);
    }

    @NotNull
    public static final FileCollection getAapt2FromMaven(@NotNull Project project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Configuration existingConfig = (Configuration)project.getConfigurations().findByName(AAPT2_CONFIG_NAME);
        if (existingConfig != null) {
            return Aapt2MavenUtils.getArtifactCollection(existingConfig);
        }
        Configuration config2 = (Configuration)project.getConfigurations().create(AAPT2_CONFIG_NAME, (Action)getAapt2FromMaven.config.1.INSTANCE);
        switch (SdkConstants.currentPlatform()) {
            case 2: {
                string = "windows";
                break;
            }
            case 3: {
                string = "osx";
                break;
            }
            case 1: {
                string = "linux";
                break;
            }
            default: {
                String string2 = "Unknown platform '" + System.getProperty("os.name") + '\'';
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        String classifier = string;
        String version = "" + Version.ANDROID_GRADLE_PLUGIN_VERSION + '-' + Aapt2Version.INSTANCE.getBUILD_NUMBER();
        DependencyHandler dependencyHandler = project.getDependencies();
        Configuration configuration = config2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        dependencyHandler.add(configuration.getName(), (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"com.android.tools.build"), TuplesKt.to((Object)"name", (Object)"aapt2"), TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"classifier", (Object)classifier)}));
        project.getDependencies().registerTransform((Action)getAapt2FromMaven.1.INSTANCE);
        return Aapt2MavenUtils.getArtifactCollection(config2);
    }

    private static final FileCollection getArtifactCollection(Configuration configuration) {
        ArtifactView artifactView = configuration.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection;
    }
}

