/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginCrashReporter;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.DesugarIncrementalTransformHelper;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderCacheHandler;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.android.build.gradle.internal.workeractions.WorkerActionServiceRegistry;
import com.android.builder.core.DexOptions;
import com.android.builder.core.SerializableMessageReceiver;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.builder.utils.FileCache;
import com.android.dx.command.dexer.DxContext;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.gradle.tooling.BuildException;
import org.gradle.workers.IsolationMode;
import org.jetbrains.annotations.NotNull;

public class DexArchiveBuilderTransform
extends Transform {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
    public static final int DEFAULT_BUFFER_SIZE_IN_KB = 100;
    public static final int NUMBER_OF_SLICES_FOR_PROJECT_CLASSES = 10;
    private static final int DEFAULT_NUM_BUCKETS = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
    private final Supplier<List<File>> androidJarClasspath;
    private final DexOptions dexOptions;
    private final MessageReceiver messageReceiver;
    final WaitableExecutor executor;
    private final int minSdkVersion;
    private final DexerTool dexer;
    private String projectVariant;
    private boolean enableIncrementalDesugaring;
    private final DexArchiveBuilderCacheHandler cacheHandler;
    private final boolean useGradleWorkers;
    private final int inBufferSize;
    private final int outBufferSize;
    private final boolean isDebuggable;
    private final VariantScope.Java8LangSupport java8LangSupportType;
    private final int numberOfBuckets;
    private final boolean includeFeaturesInScopes;
    private boolean isInstantRun;

    DexArchiveBuilderTransform(Supplier<List<File>> androidJarClasspath, DexOptions dexOptions, MessageReceiver messageReceiver, FileCache userLevelCache, int minSdkVersion, DexerTool dexer, boolean useGradleWorkers, Integer inBufferSize, Integer outBufferSize, boolean isDebuggable, VariantScope.Java8LangSupport java8LangSupportType, String projectVariant, boolean enableIncrementalDesugaring, Integer numberOfBuckets, boolean includeFeaturesInScopes, boolean isInstantRun) {
        this.androidJarClasspath = androidJarClasspath;
        this.dexOptions = dexOptions;
        this.messageReceiver = messageReceiver;
        this.minSdkVersion = minSdkVersion;
        this.dexer = dexer;
        this.projectVariant = projectVariant;
        this.enableIncrementalDesugaring = enableIncrementalDesugaring;
        this.executor = WaitableExecutor.useGlobalSharedThreadPool();
        this.cacheHandler = new DexArchiveBuilderCacheHandler(userLevelCache, dexOptions, minSdkVersion, isDebuggable, dexer);
        this.useGradleWorkers = useGradleWorkers;
        this.inBufferSize = (inBufferSize == null ? 100 : inBufferSize) * 1024;
        this.outBufferSize = (outBufferSize == null ? 100 : outBufferSize) * 1024;
        this.isDebuggable = isDebuggable;
        this.java8LangSupportType = java8LangSupportType;
        this.numberOfBuckets = isInstantRun ? 10 : (numberOfBuckets == null ? DEFAULT_NUM_BUCKETS : numberOfBuckets);
        this.includeFeaturesInScopes = includeFeaturesInScopes;
        this.isInstantRun = isInstantRun;
    }

    public String getName() {
        return "dexBuilder";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        if (this.includeFeaturesInScopes) {
            return TransformManager.SCOPE_FULL_WITH_IR_AND_FEATURES;
        }
        return TransformManager.SCOPE_FULL_WITH_IR_FOR_DEXING;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return ImmutableSet.of((Object)QualifiedContent.Scope.PROVIDED_ONLY, (Object)QualifiedContent.Scope.TESTED_CODE);
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            params.put("optimize", !this.dexOptions.getAdditionalParameters().contains("--no-optimize"));
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("min-sdk-version", this.minSdkVersion);
            params.put("dex-builder-tool", this.dexer.name());
            params.put("instant-run", this.isInstantRun);
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, IOException, InterruptedException {
        DesugarIncrementalTransformHelper desugarIncrementalTransformHelper;
        Object additionalPaths;
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        Preconditions.checkNotNull((Object)outputProvider, (Object)"Missing output provider.");
        if (this.dexOptions.getAdditionalParameters().contains("--no-optimize")) {
            logger.warning("Disabling dex optimization produces wrong local debug info, b.android.com/82031.", new Object[0]);
        }
        logger.verbose("Task is incremental : %b ", transformInvocation.isIncremental());
        if (!transformInvocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        if (!this.enableIncrementalDesugaring || this.java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            additionalPaths = ImmutableSet.of();
            desugarIncrementalTransformHelper = null;
        } else {
            desugarIncrementalTransformHelper = new DesugarIncrementalTransformHelper(this.projectVariant, transformInvocation, this.executor);
            additionalPaths = desugarIncrementalTransformHelper.getAdditionalPaths().stream().map(Path::toFile).collect(Collectors.toSet());
        }
        ArrayList<DexArchiveBuilderCacheHandler.CacheableItem> cacheableItems = new ArrayList<DexArchiveBuilderCacheHandler.CacheableItem>();
        boolean isIncremental = transformInvocation.isIncremental();
        List<Path> classpath = DexArchiveBuilderTransform.getClasspath(transformInvocation, this.java8LangSupportType).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        List<Path> bootclasspath = DexArchiveBuilderTransform.getBootClasspath(this.androidJarClasspath, this.java8LangSupportType).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        ClasspathServiceKey bootclasspathServiceKey = null;
        ClasspathServiceKey classpathServiceKey = null;
        try (ClassFileProviderFactory bootClasspathProvider = new ClassFileProviderFactory(bootclasspath);
             ClassFileProviderFactory libraryClasspathProvider = new ClassFileProviderFactory(classpath);){
            bootclasspathServiceKey = new ClasspathServiceKey(bootClasspathProvider.getId());
            classpathServiceKey = new ClasspathServiceKey(libraryClasspathProvider.getId());
            WorkerActionServiceRegistry.INSTANCE.registerService(bootclasspathServiceKey, () -> new ClasspathService(bootClasspathProvider));
            WorkerActionServiceRegistry.INSTANCE.registerService(classpathServiceKey, () -> new ClasspathService(libraryClasspathProvider));
            for (TransformInput input : transformInvocation.getInputs()) {
                for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                    logger.verbose("Dir input %s", dirInput.getFile().toString());
                    this.convertToDexArchive(transformInvocation.getContext(), (QualifiedContent)dirInput, outputProvider, isIncremental, bootclasspathServiceKey, classpathServiceKey, (Set<File>)additionalPaths);
                }
                for (JarInput jarInput : input.getJarInputs()) {
                    logger.verbose("Jar input %s", jarInput.getFile().toString());
                    D8DesugaringCacheInfo cacheInfo = this.getD8DesugaringCacheInfo(desugarIncrementalTransformHelper, bootclasspath, classpath, jarInput);
                    List<File> dexArchives = this.processJarInput(transformInvocation.getContext(), isIncremental, jarInput, outputProvider, bootclasspathServiceKey, classpathServiceKey, (Set<File>)additionalPaths, cacheInfo);
                    if (cacheInfo == D8DesugaringCacheInfo.DONT_CACHE || dexArchives.isEmpty()) continue;
                    cacheableItems.add(new DexArchiveBuilderCacheHandler.CacheableItem((QualifiedContent)jarInput, dexArchives, cacheInfo.orderedD8DesugaringDependencies));
                }
            }
            if (this.useGradleWorkers) {
                transformInvocation.getContext().getWorkerExecutor().await();
            } else {
                this.executor.waitForTasksWithQuickFail(true);
            }
            if (transformInvocation.isIncremental()) {
                for (TransformInput transformInput : transformInvocation.getInputs()) {
                    this.removeDeletedEntries(outputProvider, transformInput);
                }
            }
            if (!cacheableItems.isEmpty()) {
                this.cacheHandler.populateCache(cacheableItems);
            }
            logger.verbose("Done with all dex archive conversions", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransformException((Throwable)e);
        }
        catch (Exception e) {
            PluginCrashReporter.maybeReportException(e);
            logger.error(null, Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            throw new TransformException((Throwable)e);
        }
        finally {
            if (classpathServiceKey != null) {
                WorkerActionServiceRegistry.INSTANCE.removeService(classpathServiceKey);
            }
            if (bootclasspathServiceKey != null) {
                WorkerActionServiceRegistry.INSTANCE.removeService(bootclasspathServiceKey);
            }
        }
    }

    private D8DesugaringCacheInfo getD8DesugaringCacheInfo(DesugarIncrementalTransformHelper desugarIncrementalTransformHelper, List<Path> bootclasspath, List<Path> classpath, JarInput jarInput) {
        if (this.java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return D8DesugaringCacheInfo.NO_INFO;
        }
        if (!this.enableIncrementalDesugaring) {
            return new D8DesugaringCacheInfo(Stream.concat(bootclasspath.stream(), classpath.stream()).distinct().collect(Collectors.toList()));
        }
        Preconditions.checkNotNull((Object)desugarIncrementalTransformHelper);
        Set<Path> unorderedD8DesugaringDependencies = desugarIncrementalTransformHelper.getDependenciesPaths(jarInput.getFile().toPath());
        if (unorderedD8DesugaringDependencies.stream().anyMatch(path -> !path.toString().endsWith(".jar"))) {
            return D8DesugaringCacheInfo.DONT_CACHE;
        }
        List bootclasspathPaths = bootclasspath.stream().distinct().collect(Collectors.toList());
        List classpathJars = classpath.stream().distinct().filter(unorderedD8DesugaringDependencies::contains).collect(Collectors.toList());
        ArrayList allDependencies = new ArrayList(bootclasspathPaths.size() + classpathJars.size());
        allDependencies.addAll(bootclasspathPaths);
        allDependencies.addAll(classpathJars);
        return new D8DesugaringCacheInfo(allDependencies);
    }

    private void removeDeletedEntries(TransformOutputProvider outputProvider, TransformInput transformInput) throws IOException {
        for (DirectoryInput input : transformInput.getDirectoryInputs()) {
            for (Map.Entry entry : input.getChangedFiles().entrySet()) {
                if (entry.getValue() != Status.REMOVED) continue;
                File file = (File)entry.getKey();
                Path relativePath = input.getFile().toPath().relativize(file.toPath());
                String fileToDelete = file.getName().endsWith(".class") ? ClassFileEntry.withDexExtension((String)relativePath.toString()) : relativePath.toString();
                int bucketId = DexArchiveBuilderTransform.getBucketForFile((QualifiedContent)input, file.toString(), this.numberOfBuckets, this.isInstantRun);
                File outputFile = this.getOutputForDir(outputProvider, input, bucketId);
                FileUtils.deleteRecursivelyIfExists((File)outputFile.toPath().resolve(fileToDelete).toFile());
            }
        }
    }

    private List<File> processJarInput(Context context, boolean isIncremental, JarInput jarInput, TransformOutputProvider transformOutputProvider, ClasspathServiceKey bootclasspath, ClasspathServiceKey classpath, Set<File> additionalPaths, D8DesugaringCacheInfo cacheInfo) throws Exception {
        if (!isIncremental || additionalPaths.contains(jarInput.getFile())) {
            Preconditions.checkState((boolean)jarInput.getFile().exists(), (String)"File %s does not exist, yet it is reported as input. Try \ncleaning the build directory.", (Object)jarInput.getFile().toString());
            return this.convertJarToDexArchive(context, jarInput, transformOutputProvider, bootclasspath, classpath, cacheInfo);
        }
        if (jarInput.getStatus() != Status.NOTCHANGED) {
            for (int bucketId = 0; bucketId < this.numberOfBuckets; ++bucketId) {
                File shardedOutput = DexArchiveBuilderTransform.getOutputForJar(transformOutputProvider, jarInput, bucketId);
                FileUtils.deleteIfExists((File)shardedOutput);
                if (jarInput.getStatus() == Status.REMOVED) continue;
                FileUtils.mkdirs((File)shardedOutput.getParentFile());
            }
            File nonShardedOutput = DexArchiveBuilderTransform.getOutputForJar(transformOutputProvider, jarInput, null);
            FileUtils.deleteIfExists((File)nonShardedOutput);
            if (jarInput.getStatus() != Status.REMOVED) {
                FileUtils.mkdirs((File)nonShardedOutput.getParentFile());
            }
            if (jarInput.getStatus() == Status.ADDED || jarInput.getStatus() == Status.CHANGED) {
                return this.convertJarToDexArchive(context, jarInput, transformOutputProvider, bootclasspath, classpath, cacheInfo);
            }
        }
        return ImmutableList.of();
    }

    private List<File> convertJarToDexArchive(Context context, JarInput toConvert, TransformOutputProvider transformOutputProvider, ClasspathServiceKey bootclasspath, ClasspathServiceKey classpath, D8DesugaringCacheInfo cacheInfo) throws Exception {
        File cachedVersion;
        if (cacheInfo != D8DesugaringCacheInfo.DONT_CACHE && (cachedVersion = this.cacheHandler.getCachedVersionIfPresent(toConvert, cacheInfo.orderedD8DesugaringDependencies)) != null) {
            File outputFile = DexArchiveBuilderTransform.getOutputForJar(transformOutputProvider, toConvert, null);
            Files.copy(cachedVersion.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return ImmutableList.of();
        }
        return this.convertToDexArchive(context, (QualifiedContent)toConvert, transformOutputProvider, false, bootclasspath, classpath, (Set<File>)ImmutableSet.of());
    }

    private static DexArchiveBuilder getDexArchiveBuilder(int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, ClasspathServiceKey bootClasspath, ClasspathServiceKey classpath, DexerTool dexer, boolean isDebuggable, boolean d8DesugaringEnabled, OutputStream outStream, OutputStream errStream, MessageReceiver messageReceiver) {
        DexArchiveBuilder dexArchiveBuilder;
        switch (dexer) {
            case DX: {
                boolean optimizedDex = !dexAdditionalParameters.contains("--no-optimize");
                DxContext dxContext = new DxContext(outStream, errStream);
                DexArchiveBuilderConfig config2 = new DexArchiveBuilderConfig(dxContext, optimizedDex, inBufferSize, minSdkVersion, DexerTool.DX, outBufferSize, DexArchiveBuilderCacheHandler.isJumboModeEnabledForDx());
                dexArchiveBuilder = DexArchiveBuilder.createDxDexBuilder((DexArchiveBuilderConfig)config2);
                break;
            }
            case D8: {
                dexArchiveBuilder = DexArchiveBuilder.createD8DexBuilder((int)minSdkVersion, (boolean)isDebuggable, (ClassFileProviderFactory)WorkerActionServiceRegistry.INSTANCE.getService(bootClasspath).getService(), (ClassFileProviderFactory)WorkerActionServiceRegistry.INSTANCE.getService(classpath).getService(), (boolean)d8DesugaringEnabled, (MessageReceiver)messageReceiver);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown dexer type: " + dexer.name()));
            }
        }
        return dexArchiveBuilder;
    }

    private List<File> convertToDexArchive(Context context, QualifiedContent input, TransformOutputProvider outputProvider, boolean isIncremental, ClasspathServiceKey bootClasspath, ClasspathServiceKey classpath, Set<File> additionalPaths) {
        logger.verbose("Dexing %s", input.getFile().getAbsolutePath());
        ImmutableList.Builder dexArchives = ImmutableList.builder();
        for (int bucketId = 0; bucketId < this.numberOfBuckets; ++bucketId) {
            File preDexOutputFile;
            if (input instanceof DirectoryInput) {
                preDexOutputFile = this.getOutputForDir(outputProvider, (DirectoryInput)input, bucketId);
                FileUtils.mkdirs((File)preDexOutputFile);
            } else {
                preDexOutputFile = DexArchiveBuilderTransform.getOutputForJar(outputProvider, (JarInput)input, bucketId);
            }
            dexArchives.add((Object)preDexOutputFile);
            DexConversionParameters parameters = new DexConversionParameters(input, bootClasspath, classpath, preDexOutputFile, this.numberOfBuckets, bucketId, this.minSdkVersion, this.dexOptions.getAdditionalParameters(), this.inBufferSize, this.outBufferSize, this.dexer, this.isDebuggable, isIncremental, this.java8LangSupportType, additionalPaths, (MessageReceiver)new SerializableMessageReceiver(this.messageReceiver), this.isInstantRun);
            if (this.useGradleWorkers) {
                context.getWorkerExecutor().submit(DexConversionWorkAction.class, configuration -> {
                    configuration.setIsolationMode(IsolationMode.NONE);
                    configuration.setParams(new Object[]{parameters});
                });
                continue;
            }
            this.executor.execute(() -> {
                ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)logger), new MessageReceiver[]{this.messageReceiver});
                ProcessOutput output2 = null;
                try (ProcessOutput ignored = output2 = outputHandler.createOutput();){
                    DexArchiveBuilderTransform.launchProcessing(parameters, output2.getStandardOutput(), output2.getErrorOutput(), this.messageReceiver);
                }
                finally {
                    if (output2 != null) {
                        try {
                            outputHandler.handleOutput(output2);
                        }
                        catch (ProcessException processException) {}
                    }
                }
                return null;
            });
        }
        return dexArchives.build();
    }

    private static void launchProcessing(DexConversionParameters dexConversionParameters, OutputStream outStream, OutputStream errStream, MessageReceiver receiver) throws IOException, URISyntaxException {
        DexArchiveBuilder dexArchiveBuilder = DexArchiveBuilderTransform.getDexArchiveBuilder(dexConversionParameters.minSdkVersion, dexConversionParameters.dexAdditionalParameters, dexConversionParameters.inBufferSize, dexConversionParameters.outBufferSize, dexConversionParameters.bootClasspath, dexConversionParameters.classpath, dexConversionParameters.dexer, dexConversionParameters.isDebuggable, VariantScope.Java8LangSupport.D8 == dexConversionParameters.java8LangSupportType, outStream, errStream, receiver);
        Path inputPath = dexConversionParameters.input.getFile().toPath();
        Predicate<String> bucketFilter = dexConversionParameters::belongsToThisBucket;
        boolean hasIncrementalInfo = dexConversionParameters.isDirectoryBased() && dexConversionParameters.isIncremental;
        Predicate<String> toProcess = hasIncrementalInfo ? path -> {
            File resolved = inputPath.resolve((String)path).toFile();
            if (dexConversionParameters.additionalPaths.contains(resolved)) {
                return true;
            }
            Map changedFiles = ((DirectoryInput)dexConversionParameters.input).getChangedFiles();
            Status status = (Status)changedFiles.get(resolved);
            return status == Status.ADDED || status == Status.CHANGED;
        } : path -> true;
        bucketFilter = bucketFilter.and(toProcess);
        logger.verbose("Dexing '" + inputPath + "' to '" + dexConversionParameters.output + "'", new Object[0]);
        try (ClassFileInput input = ClassFileInputs.fromPath((Path)inputPath);
             Stream entries = input.entries(bucketFilter);){
            dexArchiveBuilder.convert(entries, Paths.get(new URI(dexConversionParameters.output)), dexConversionParameters.isDirectoryBased());
        }
        catch (DexArchiveBuilderException ex) {
            throw new DexArchiveBuilderException("Failed to process " + inputPath.toString(), (Throwable)ex);
        }
    }

    private static List<String> getClasspath(TransformInvocation transformInvocation, VariantScope.Java8LangSupport java8LangSupportType) {
        if (java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return Collections.emptyList();
        }
        ImmutableList.Builder classpathEntries = ImmutableList.builder();
        Iterable dependencies = Iterables.concat((Iterable)transformInvocation.getInputs(), (Iterable)transformInvocation.getReferencedInputs());
        classpathEntries.addAll(TransformInputUtil.getDirectories(dependencies).stream().map(File::getPath).distinct().iterator());
        classpathEntries.addAll(Streams.stream((Iterable)dependencies).flatMap(transformInput -> transformInput.getJarInputs().stream()).filter(jarInput -> jarInput.getStatus() != Status.REMOVED).map(jarInput -> jarInput.getFile().getPath()).distinct().iterator());
        return classpathEntries.build();
    }

    private static List<String> getBootClasspath(Supplier<List<File>> androidJarClasspath, VariantScope.Java8LangSupport java8LangSupportType) {
        if (java8LangSupportType != VariantScope.Java8LangSupport.D8) {
            return Collections.emptyList();
        }
        ImmutableList.Builder classpathEntries = ImmutableList.builder();
        classpathEntries.addAll(androidJarClasspath.get().stream().map(File::getPath).iterator());
        return classpathEntries.build();
    }

    private static File getOutputForJar(TransformOutputProvider output2, JarInput qualifiedContent, Integer bucketId) {
        return output2.getContentLocation(qualifiedContent.getName() + (bucketId == null ? "" : "-" + bucketId), (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), qualifiedContent.getScopes(), Format.JAR);
    }

    private File getOutputForDir(TransformOutputProvider output2, DirectoryInput directoryInput, int bucketId) {
        String name = this.isInstantRun && Sets.difference((Set)directoryInput.getScopes(), TransformManager.SCOPE_IR_FOR_SLICING).isEmpty() ? DexArchiveBuilderTransform.getSliceName(bucketId) : directoryInput.getName();
        return output2.getContentLocation(name, (Set)ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE)), directoryInput.getScopes(), Format.DIRECTORY);
    }

    public static String getSliceName(int bucketId) {
        return "slice_" + bucketId;
    }

    private static int getBucketForFile(QualifiedContent content2, String path, int numberOfBuckets, boolean isInstantRun) {
        if (!isInstantRun || !(content2 instanceof DirectoryInput)) {
            return Math.abs(path.hashCode()) % numberOfBuckets;
        }
        Path filePath = Paths.get(path, new String[0]);
        Preconditions.checkArgument((boolean)filePath.isAbsolute(), (Object)("Path should be absolute: " + path));
        Path packagePath = filePath.getParent();
        if (packagePath == null) {
            return 0;
        }
        return Math.abs(packagePath.toString().hashCode()) % numberOfBuckets;
    }

    private static class D8DesugaringCacheInfo {
        private static final D8DesugaringCacheInfo NO_INFO = new D8DesugaringCacheInfo(Collections.emptyList());
        private static final D8DesugaringCacheInfo DONT_CACHE = new D8DesugaringCacheInfo(Collections.emptyList());
        private final List<Path> orderedD8DesugaringDependencies;

        private D8DesugaringCacheInfo(List<Path> orderedD8DesugaringDependencies) {
            this.orderedD8DesugaringDependencies = orderedD8DesugaringDependencies;
        }
    }

    public static class DexConversionWorkAction
    implements Runnable {
        private final DexConversionParameters dexConversionParameters;

        @Inject
        public DexConversionWorkAction(DexConversionParameters dexConversionParameters) {
            this.dexConversionParameters = dexConversionParameters;
        }

        @Override
        public void run() {
            try {
                DexArchiveBuilderTransform.launchProcessing(this.dexConversionParameters, System.out, System.err, this.dexConversionParameters.messageReceiver);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class DexConversionParameters
    implements Serializable {
        private final QualifiedContent input;
        private final ClasspathServiceKey bootClasspath;
        private final ClasspathServiceKey classpath;
        private final String output;
        private final int numberOfBuckets;
        private final int buckedId;
        private final int minSdkVersion;
        private final List<String> dexAdditionalParameters;
        private final int inBufferSize;
        private final int outBufferSize;
        private final DexerTool dexer;
        private final boolean isDebuggable;
        private final boolean isIncremental;
        private final VariantScope.Java8LangSupport java8LangSupportType;
        private final Set<File> additionalPaths;
        @Nonnull
        private final MessageReceiver messageReceiver;
        private final boolean isInstantRun;

        public DexConversionParameters(QualifiedContent input, ClasspathServiceKey bootClasspath, ClasspathServiceKey classpath, File output2, int numberOfBuckets, int buckedId, int minSdkVersion, List<String> dexAdditionalParameters, int inBufferSize, int outBufferSize, DexerTool dexer, boolean isDebuggable, boolean isIncremental, VariantScope.Java8LangSupport java8LangSupportType, Set<File> additionalPaths, @Nonnull MessageReceiver messageReceiver, boolean isInstantRun) {
            this.input = input;
            this.bootClasspath = bootClasspath;
            this.classpath = classpath;
            this.numberOfBuckets = numberOfBuckets;
            this.buckedId = buckedId;
            this.output = output2.toURI().toString();
            this.minSdkVersion = minSdkVersion;
            this.dexAdditionalParameters = dexAdditionalParameters;
            this.inBufferSize = inBufferSize;
            this.outBufferSize = outBufferSize;
            this.dexer = dexer;
            this.isDebuggable = isDebuggable;
            this.isIncremental = isIncremental;
            this.java8LangSupportType = java8LangSupportType;
            this.additionalPaths = additionalPaths;
            this.messageReceiver = messageReceiver;
            this.isInstantRun = isInstantRun;
        }

        public boolean belongsToThisBucket(String path) {
            return DexArchiveBuilderTransform.getBucketForFile(this.input, path, this.numberOfBuckets, this.isInstantRun) == this.buckedId;
        }

        public boolean isDirectoryBased() {
            return this.input instanceof DirectoryInput;
        }
    }

    public static final class ClasspathService
    implements WorkerActionServiceRegistry.RegisteredService<ClassFileProviderFactory> {
        private final ClassFileProviderFactory providerFactory;

        public ClasspathService(ClassFileProviderFactory providerFactory) {
            this.providerFactory = providerFactory;
        }

        @Override
        @NotNull
        public ClassFileProviderFactory getService() {
            return this.providerFactory;
        }

        @Override
        public void shutdown() {
        }
    }

    public static final class ClasspathServiceKey
    implements WorkerActionServiceRegistry.ServiceKey<ClassFileProviderFactory> {
        private final long id;

        public ClasspathServiceKey(long id) {
            this.id = id;
        }

        @Override
        @NotNull
        public Class<ClassFileProviderFactory> getType() {
            return ClassFileProviderFactory.class;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClasspathServiceKey that = (ClasspathServiceKey)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

