/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.shrinker.ProguardConfig;
import com.android.build.gradle.shrinker.parser.ProguardFlags;
import com.android.build.gradle.shrinker.parser.UnsupportedFlagsHandler;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckProguardFiles
extends DefaultTask {
    private static final Logger logger = LoggerFactory.getLogger(CheckProguardFiles.class);
    private List<File> proguardFiles;

    @TaskAction
    public void run() {
        ProguardConfig proguardConfig = new ProguardConfig();
        HashMap<File, ProguardFiles.ProguardFile> oldFiles = new HashMap<File, ProguardFiles.ProguardFile>();
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.OPTIMIZE.fileName, this.getProject()).getAbsoluteFile(), ProguardFiles.ProguardFile.OPTIMIZE);
        oldFiles.put(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.DONT_OPTIMIZE.fileName, this.getProject()).getAbsoluteFile(), ProguardFiles.ProguardFile.DONT_OPTIMIZE);
        for (File file : this.proguardFiles) {
            if (oldFiles.containsKey(file.getAbsoluteFile())) {
                String name = ((ProguardFiles.ProguardFile)((Object)oldFiles.get((Object)file.getAbsoluteFile()))).fileName;
                throw new InvalidUserDataException(name + " should not be used together with the new postprocessing DSL. The new DSL includes sensible settings by default, you can override this using `postprocessing { proguardFiles = []}`");
            }
            try {
                proguardConfig.parse(file, UnsupportedFlagsHandler.NO_OP);
            }
            catch (Exception e) {
                logger.info("Failed to parse " + file.getAbsolutePath(), (Throwable)e);
                continue;
            }
            ProguardFlags flags = proguardConfig.getFlags();
            if (!flags.isDontShrink() && !flags.isDontOptimize() && !flags.isDontObfuscate()) continue;
            throw new InvalidUserDataException(file.getAbsolutePath() + ": When postprocessing features are configured in the DSL, corresponding flags (e.g. -dontobfuscate) cannot be used.");
        }
    }

    @InputFiles
    public List<File> getProguardFiles() {
        return this.proguardFiles;
    }

    public static class ConfigAction
    implements TaskConfigAction<CheckProguardFiles> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("check", "ProguardFiles");
        }

        @Override
        public Class<CheckProguardFiles> getType() {
            return CheckProguardFiles.class;
        }

        @Override
        public void execute(CheckProguardFiles task) {
            task.proguardFiles = this.scope.getProguardFiles();
        }
    }
}

