/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.FeatureExtension;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.process.JarSigner;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.BundleTaskKt;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.options.StringOption;
import com.android.builder.packaging.PackagingUtils;
import com.android.bundle.Config;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.tools.build.bundletool.commands.BuildBundleCommand;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0004ABCDB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010?\u001a\u00020@H\u0007R2\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\r8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u001a8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR&\u0010!\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020 8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R*\u0010)\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00078\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010(\"\u0004\b+\u0010,R*\u0010-\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00078\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010(\"\u0004\b/\u0010,R*\u00100\u001a\u0004\u0018\u00010\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u00178\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0019\"\u0004\b2\u00103R*\u00104\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00078\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010(\"\u0004\b6\u0010,R*\u00107\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0010\"\u0004\b9\u0010\u0012R*\u0010:\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\r8\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u0010\"\u0004\b<\u0010\u0012R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "", "", "aaptOptionsNoCompress", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "setAaptOptionsNoCompress", "(Ljava/util/Collection;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "baseModuleZip", "getBaseModuleZip", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBaseModuleZip", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "bundleFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "bundleLocation", "Ljava/io/File;", "getBundleLocation", "()Ljava/io/File;", "Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;", "bundleOptions", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;", "setBundleOptions", "(Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;)V", "Lorg/gradle/api/file/FileCollection;", "featureZips", "getFeatureZips", "()Lorg/gradle/api/file/FileCollection;", "setFeatureZips", "(Lorg/gradle/api/file/FileCollection;)V", "fileName", "getFileName", "()Ljava/lang/String;", "keyAlias", "getKeyAlias", "setKeyAlias", "(Ljava/lang/String;)V", "keyPassword", "getKeyPassword", "setKeyPassword", "keystoreFile", "getKeystoreFile", "setKeystoreFile", "(Ljava/io/File;)V", "keystorePassword", "getKeystorePassword", "setKeystorePassword", "mainDexList", "getMainDexList", "setMainDexList", "obsfuscationMappingFile", "getObsfuscationMappingFile", "setObsfuscationMappingFile", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "bundleModules", "", "BundleOptions", "BundleToolRunnable", "ConfigAction", "Params", "gradle"})
public class BundleTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact baseModuleZip;
    @NotNull
    private FileCollection featureZips;
    @Nullable
    private BuildableArtifact mainDexList;
    @Nullable
    private BuildableArtifact obsfuscationMappingFile;
    @NotNull
    private Collection<String> aaptOptionsNoCompress;
    @NotNull
    private BundleOptions bundleOptions;
    @Nullable
    private File keystoreFile;
    @Nullable
    private String keystorePassword;
    @Nullable
    private String keyAlias;
    @Nullable
    private String keyPassword;
    private Provider<RegularFile> bundleFile;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final BuildableArtifact getBaseModuleZip() {
        BuildableArtifact buildableArtifact = this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    private final void setBaseModuleZip(BuildableArtifact buildableArtifact) {
        this.baseModuleZip = buildableArtifact;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public final FileCollection getFeatureZips() {
        FileCollection fileCollection = this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    private final void setFeatureZips(FileCollection fileCollection) {
        this.featureZips = fileCollection;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Nullable
    public final BuildableArtifact getMainDexList() {
        return this.mainDexList;
    }

    private final void setMainDexList(BuildableArtifact buildableArtifact) {
        this.mainDexList = buildableArtifact;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Nullable
    public final BuildableArtifact getObsfuscationMappingFile() {
        return this.obsfuscationMappingFile;
    }

    private final void setObsfuscationMappingFile(BuildableArtifact buildableArtifact) {
        this.obsfuscationMappingFile = buildableArtifact;
    }

    @Input
    @NotNull
    public final Collection<String> getAaptOptionsNoCompress() {
        Collection<String> collection = this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    private final void setAaptOptionsNoCompress(Collection<String> collection) {
        this.aaptOptionsNoCompress = collection;
    }

    @Nested
    @NotNull
    public final BundleOptions getBundleOptions() {
        BundleOptions bundleOptions = this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    private final void setBundleOptions(BundleOptions bundleOptions) {
        this.bundleOptions = bundleOptions;
    }

    @InputFile
    @Optional
    @Nullable
    public final File getKeystoreFile() {
        return this.keystoreFile;
    }

    private final void setKeystoreFile(File file) {
        this.keystoreFile = file;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeystorePassword() {
        return this.keystorePassword;
    }

    private final void setKeystorePassword(String string) {
        this.keystorePassword = string;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeyAlias() {
        return this.keyAlias;
    }

    private final void setKeyAlias(String string) {
        this.keyAlias = string;
    }

    @Input
    @Optional
    @Nullable
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    private final void setKeyPassword(String string) {
        this.keyPassword = string;
    }

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final File getBundleLocation() {
        Provider<RegularFile> provider = this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"bundleFile.get().asFile.parentFile");
        return file2;
    }

    @Input
    @NotNull
    public final String getFileName() {
        Provider<RegularFile> provider = this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        Object object = provider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bundleFile.get().asFile.name");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void bundleModules() {
        JarSigner.Signature signature;
        if (this.keystoreFile != null) {
            File file = this.keystoreFile;
            if (file == null) {
                Intrinsics.throwNpe();
            }
            signature = new JarSigner.Signature(file, this.keystorePassword, this.keyAlias, this.keyPassword);
        } else {
            signature = null;
        }
        JarSigner.Signature signature2 = signature;
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            BuildableArtifact buildableArtifact = this.baseModuleZip;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
            }
            File file = BuildableArtifactUtil.singleFile(buildableArtifact);
            FileCollection fileCollection = this.featureZips;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
            }
            Set set = fileCollection.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"featureZips.files");
            BuildableArtifact buildableArtifact2 = this.mainDexList;
            File file2 = buildableArtifact2 != null ? BuildableArtifactUtil.singleFile(buildableArtifact2) : null;
            BuildableArtifact buildableArtifact3 = this.obsfuscationMappingFile;
            File file3 = buildableArtifact3 != null ? BuildableArtifactUtil.singleFile(buildableArtifact3) : null;
            Collection<String> collection = this.aaptOptionsNoCompress;
            if (collection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
            }
            BundleOptions bundleOptions = this.bundleOptions;
            if (bundleOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
            }
            Provider<RegularFile> provider = this.bundleFile;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
            }
            Object object = provider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bundleFile.get()");
            File file4 = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"bundleFile.get().asFile");
            it.submit(BundleToolRunnable.class, (Serializable)new Params(file, set, file2, file3, collection, bundleOptions, signature2, file4));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public BundleTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
    }

    @NotNull
    public static final /* synthetic */ Provider access$getBundleFile$p(BundleTask $this) {
        Provider<RegularFile> provider = $this.bundleFile;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleFile");
        }
        return provider;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getBaseModuleZip$p(BundleTask $this) {
        BuildableArtifact buildableArtifact = $this.baseModuleZip;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"baseModuleZip");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getFeatureZips$p(BundleTask $this) {
        FileCollection fileCollection = $this.featureZips;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureZips");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ Collection access$getAaptOptionsNoCompress$p(BundleTask $this) {
        Collection<String> collection = $this.aaptOptionsNoCompress;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptionsNoCompress");
        }
        return collection;
    }

    @NotNull
    public static final /* synthetic */ BundleOptions access$getBundleOptions$p(BundleTask $this) {
        BundleOptions bundleOptions = $this.bundleOptions;
        if (bundleOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundleOptions");
        }
        return bundleOptions;
    }

    @Nullable
    public static final /* synthetic */ BuildableArtifact access$getMainDexList$p(BundleTask $this) {
        return $this.mainDexList;
    }

    @Nullable
    public static final /* synthetic */ BuildableArtifact access$getObsfuscationMappingFile$p(BundleTask $this) {
        return $this.obsfuscationMappingFile;
    }

    @Nullable
    public static final /* synthetic */ File access$getKeystoreFile$p(BundleTask $this) {
        return $this.keystoreFile;
    }

    @Nullable
    public static final /* synthetic */ String access$getKeystorePassword$p(BundleTask $this) {
        return $this.keystorePassword;
    }

    @Nullable
    public static final /* synthetic */ String access$getKeyAlias$p(BundleTask $this) {
        return $this.keyAlias;
    }

    @Nullable
    public static final /* synthetic */ String access$getKeyPassword$p(BundleTask $this) {
        return $this.keyPassword;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003Jk\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\nH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$Params;", "Ljava/io/Serializable;", "baseModuleFile", "Ljava/io/File;", "featureFiles", "", "mainDexList", "obfuscationMappingFile", "aaptOptionsNoCompress", "", "", "bundleOptions", "Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;", "signature", "Lcom/android/build/gradle/internal/process/JarSigner$Signature;", "bundleFile", "(Ljava/io/File;Ljava/util/Set;Ljava/io/File;Ljava/io/File;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;Lcom/android/build/gradle/internal/process/JarSigner$Signature;Ljava/io/File;)V", "getAaptOptionsNoCompress", "()Ljava/util/Collection;", "getBaseModuleFile", "()Ljava/io/File;", "getBundleFile", "getBundleOptions", "()Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;", "getFeatureFiles", "()Ljava/util/Set;", "getMainDexList", "getObfuscationMappingFile", "getSignature", "()Lcom/android/build/gradle/internal/process/JarSigner$Signature;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File baseModuleFile;
        @NotNull
        private final Set<File> featureFiles;
        @Nullable
        private final File mainDexList;
        @Nullable
        private final File obfuscationMappingFile;
        @NotNull
        private final Collection<String> aaptOptionsNoCompress;
        @NotNull
        private final BundleOptions bundleOptions;
        @Nullable
        private final JarSigner.Signature signature;
        @NotNull
        private final File bundleFile;

        @NotNull
        public final File getBaseModuleFile() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> getFeatureFiles() {
            return this.featureFiles;
        }

        @Nullable
        public final File getMainDexList() {
            return this.mainDexList;
        }

        @Nullable
        public final File getObfuscationMappingFile() {
            return this.obfuscationMappingFile;
        }

        @NotNull
        public final Collection<String> getAaptOptionsNoCompress() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions getBundleOptions() {
            return this.bundleOptions;
        }

        @Nullable
        public final JarSigner.Signature getSignature() {
            return this.signature;
        }

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        public Params(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @Nullable JarSigner.Signature signature, @NotNull File bundleFile) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            this.baseModuleFile = baseModuleFile;
            this.featureFiles = featureFiles;
            this.mainDexList = mainDexList;
            this.obfuscationMappingFile = obfuscationMappingFile;
            this.aaptOptionsNoCompress = aaptOptionsNoCompress;
            this.bundleOptions = bundleOptions;
            this.signature = signature;
            this.bundleFile = bundleFile;
        }

        @NotNull
        public final File component1() {
            return this.baseModuleFile;
        }

        @NotNull
        public final Set<File> component2() {
            return this.featureFiles;
        }

        @Nullable
        public final File component3() {
            return this.mainDexList;
        }

        @Nullable
        public final File component4() {
            return this.obfuscationMappingFile;
        }

        @NotNull
        public final Collection<String> component5() {
            return this.aaptOptionsNoCompress;
        }

        @NotNull
        public final BundleOptions component6() {
            return this.bundleOptions;
        }

        @Nullable
        public final JarSigner.Signature component7() {
            return this.signature;
        }

        @NotNull
        public final File component8() {
            return this.bundleFile;
        }

        @NotNull
        public final Params copy(@NotNull File baseModuleFile, @NotNull Set<? extends File> featureFiles, @Nullable File mainDexList, @Nullable File obfuscationMappingFile, @NotNull Collection<String> aaptOptionsNoCompress, @NotNull BundleOptions bundleOptions, @Nullable JarSigner.Signature signature, @NotNull File bundleFile) {
            Intrinsics.checkParameterIsNotNull((Object)baseModuleFile, (String)"baseModuleFile");
            Intrinsics.checkParameterIsNotNull(featureFiles, (String)"featureFiles");
            Intrinsics.checkParameterIsNotNull(aaptOptionsNoCompress, (String)"aaptOptionsNoCompress");
            Intrinsics.checkParameterIsNotNull((Object)bundleOptions, (String)"bundleOptions");
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            return new Params(baseModuleFile, featureFiles, mainDexList, obfuscationMappingFile, aaptOptionsNoCompress, bundleOptions, signature, bundleFile);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, File file, Set set, File file2, File file3, Collection collection, BundleOptions bundleOptions, JarSigner.Signature signature, File file4, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.baseModuleFile;
            }
            if ((n & 2) != 0) {
                set = params.featureFiles;
            }
            if ((n & 4) != 0) {
                file2 = params.mainDexList;
            }
            if ((n & 8) != 0) {
                file3 = params.obfuscationMappingFile;
            }
            if ((n & 0x10) != 0) {
                collection = params.aaptOptionsNoCompress;
            }
            if ((n & 0x20) != 0) {
                bundleOptions = params.bundleOptions;
            }
            if ((n & 0x40) != 0) {
                signature = params.signature;
            }
            if ((n & 0x80) != 0) {
                file4 = params.bundleFile;
            }
            return params.copy(file, set, file2, file3, collection, bundleOptions, signature, file4);
        }

        public String toString() {
            return "Params(baseModuleFile=" + this.baseModuleFile + ", featureFiles=" + this.featureFiles + ", mainDexList=" + this.mainDexList + ", obfuscationMappingFile=" + this.obfuscationMappingFile + ", aaptOptionsNoCompress=" + this.aaptOptionsNoCompress + ", bundleOptions=" + this.bundleOptions + ", signature=" + this.signature + ", bundleFile=" + this.bundleFile + ")";
        }

        public int hashCode() {
            File file = this.baseModuleFile;
            Set<File> set = this.featureFiles;
            File file2 = this.mainDexList;
            File file3 = this.obfuscationMappingFile;
            Collection<String> collection = this.aaptOptionsNoCompress;
            BundleOptions bundleOptions = this.bundleOptions;
            JarSigner.Signature signature = this.signature;
            File file4 = this.bundleFile;
            return (((((((file != null ? ((Object)file).hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (bundleOptions != null ? ((Object)bundleOptions).hashCode() : 0)) * 31 + (signature != null ? ((Object)signature).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.baseModuleFile, (Object)params.baseModuleFile) || !Intrinsics.areEqual(this.featureFiles, params.featureFiles) || !Intrinsics.areEqual((Object)this.mainDexList, (Object)params.mainDexList) || !Intrinsics.areEqual((Object)this.obfuscationMappingFile, (Object)params.obfuscationMappingFile) || !Intrinsics.areEqual(this.aaptOptionsNoCompress, params.aaptOptionsNoCompress) || !Intrinsics.areEqual((Object)this.bundleOptions, (Object)params.bundleOptions) || !Intrinsics.areEqual((Object)this.signature, (Object)params.signature) || !Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/BundleTask$Params;", "(Lcom/android/build/gradle/internal/tasks/BundleTask$Params;)V", "getBundlePath", "Ljava/nio/file/Path;", "folder", "Ljava/io/File;", "run", "", "gradle"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            File it;
            File file;
            File bundleFile = this.params.getBundleFile();
            FileUtils.cleanOutputDir((File)bundleFile.getParentFile());
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.getBundlePath(this.params.getBaseModuleFile()));
            Iterable $receiver$iv = this.params.getFeatureFiles();
            for (Object element$iv : $receiver$iv) {
                File it2 = (File)element$iv;
                builder.add((Object)this.getBundlePath(it2));
            }
            List noCompressGlobsForBundle = PackagingUtils.getNoCompressGlobsForBundle(this.params.getAaptOptionsNoCompress());
            Config.SplitsConfig.Builder builder2 = Config.SplitsConfig.newBuilder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"Config.SplitsConfig.newBuilder()");
            Config.SplitsConfig.Builder splitsConfig = BundleTaskKt.access$splitBy(BundleTaskKt.access$splitBy(BundleTaskKt.access$splitBy(builder2, Config.SplitDimension.Value.ABI, this.params.getBundleOptions().getEnableAbi()), Config.SplitDimension.Value.SCREEN_DENSITY, this.params.getBundleOptions().getEnableDensity()), Config.SplitDimension.Value.LANGUAGE, this.params.getBundleOptions().getEnableLanguage());
            Config.BundleConfig.Builder bundleConfig = Config.BundleConfig.newBuilder().setCompression(Config.Compression.newBuilder().addAllUncompressedGlob((Iterable)noCompressGlobsForBundle)).setOptimizations(Config.Optimizations.newBuilder().setSplitsConfig(splitsConfig));
            BuildBundleCommand.Builder command = BuildBundleCommand.builder().setBundleConfig(bundleConfig.build()).setOutputPath(bundleFile.toPath()).setModulesPaths(builder.build());
            File file2 = this.params.getMainDexList();
            if (file2 != null) {
                it = file = file2;
                command.setMainDexListFile(it.toPath());
            }
            File file3 = this.params.getObfuscationMappingFile();
            if (file3 != null) {
                it = file = file3;
                command.addMetadataFile("com.android.tools.build.obfuscation", "proguard.map", it.toPath());
            }
            command.build().execute();
            if (this.params.getSignature() != null) {
                new JarSigner().sign(bundleFile, this.params.getSignature());
            }
        }

        private final Path getBundlePath(File folder) {
            File[] children = folder.listFiles();
            Preconditions.checkNotNull((Object)children);
            Preconditions.checkState((children.length == 1 ? 1 : 0) != 0);
            Path path = children[0].toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"children[0].toPath()");
            return path;
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ2\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\n\u0010\bR\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;", "Ljava/io/Serializable;", "enableAbi", "", "enableDensity", "enableLanguage", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getEnableAbi", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getEnableDensity", "getEnableLanguage", "component1", "component2", "component3", "copy", "(Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/android/build/gradle/internal/tasks/BundleTask$BundleOptions;", "equals", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class BundleOptions
    implements Serializable {
        @Nullable
        private final Boolean enableAbi;
        @Nullable
        private final Boolean enableDensity;
        @Nullable
        private final Boolean enableLanguage;

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableAbi() {
            return this.enableAbi;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableDensity() {
            return this.enableDensity;
        }

        @Input
        @Optional
        @Nullable
        public final Boolean getEnableLanguage() {
            return this.enableLanguage;
        }

        public BundleOptions(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage) {
            this.enableAbi = enableAbi;
            this.enableDensity = enableDensity;
            this.enableLanguage = enableLanguage;
        }

        @Nullable
        public final Boolean component1() {
            return this.enableAbi;
        }

        @Nullable
        public final Boolean component2() {
            return this.enableDensity;
        }

        @Nullable
        public final Boolean component3() {
            return this.enableLanguage;
        }

        @NotNull
        public final BundleOptions copy(@Nullable Boolean enableAbi, @Nullable Boolean enableDensity, @Nullable Boolean enableLanguage) {
            return new BundleOptions(enableAbi, enableDensity, enableLanguage);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ BundleOptions copy$default(BundleOptions bundleOptions, Boolean bl, Boolean bl2, Boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bundleOptions.enableAbi;
            }
            if ((n & 2) != 0) {
                bl2 = bundleOptions.enableDensity;
            }
            if ((n & 4) != 0) {
                bl3 = bundleOptions.enableLanguage;
            }
            return bundleOptions.copy(bl, bl2, bl3);
        }

        public String toString() {
            return "BundleOptions(enableAbi=" + this.enableAbi + ", enableDensity=" + this.enableDensity + ", enableLanguage=" + this.enableLanguage + ")";
        }

        public int hashCode() {
            Boolean bl = this.enableAbi;
            Boolean bl2 = this.enableDensity;
            Boolean bl3 = this.enableLanguage;
            return ((bl != null ? ((Object)bl).hashCode() : 0) * 31 + (bl2 != null ? ((Object)bl2).hashCode() : 0)) * 31 + (bl3 != null ? ((Object)bl3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleOptions)) break block3;
                    BundleOptions bundleOptions = (BundleOptions)object;
                    if (!Intrinsics.areEqual((Object)this.enableAbi, (Object)bundleOptions.enableAbi) || !Intrinsics.areEqual((Object)this.enableDensity, (Object)bundleOptions.enableDensity) || !Intrinsics.areEqual((Object)this.enableLanguage, (Object)bundleOptions.enableLanguage)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/BundleTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<BundleTask> {
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("package", "Bundle");
        }

        @Override
        @NotNull
        public Class<BundleTask> getType() {
            return BundleTask.class;
        }

        @Override
        public void execute(@NotNull BundleTask task) {
            block7: {
                CoreSigningConfig coreSigningConfig;
                CoreSigningConfig it;
                Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
                task.setVariantName(this.scope.getFullVariantName());
                GlobalScope globalScope = this.scope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
                String apkLocationOverride = globalScope.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
                StringBuilder stringBuilder = new StringBuilder().append("");
                GlobalScope globalScope2 = this.scope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"scope.globalScope");
                String bundleName = stringBuilder.append(globalScope2.getProjectBaseName()).append(".aab").toString();
                task.bundleFile = apkLocationOverride == null ? this.scope.getArtifacts().setArtifactFile((ArtifactType)InternalArtifactType.BUNDLE, (Task)task, bundleName) : this.scope.getArtifacts().setArtifactFile((ArtifactType)InternalArtifactType.BUNDLE, (Task)task, new File(apkLocationOverride, bundleName));
                task.baseModuleZip = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MODULE_BUNDLE);
                FileCollection fileCollection = this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MODULE_BUNDLE);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"scope.getArtifactFileCol\u2026DULE_BUNDLE\n            )");
                task.featureZips = fileCollection;
                BundleTask bundleTask = task;
                GlobalScope globalScope3 = this.scope.getGlobalScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)globalScope3, (String)"scope.globalScope");
                AndroidConfig androidConfig = globalScope3.getExtension();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"scope.globalScope.extension");
                AaptOptions aaptOptions = androidConfig.getAaptOptions();
                Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"scope.globalScope.extension.aaptOptions");
                Collection collection = aaptOptions.getNoCompress();
                if (collection == null) {
                    BundleTask bundleTask2 = bundleTask;
                    List list = CollectionsKt.emptyList();
                    bundleTask = bundleTask2;
                    collection = list;
                }
                bundleTask.aaptOptionsNoCompress = collection;
                if (this.scope.getType().isHybrid()) {
                    GlobalScope globalScope4 = this.scope.getGlobalScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalScope4, (String)"scope.globalScope");
                    AndroidConfig androidConfig2 = globalScope4.getExtension();
                    if (androidConfig2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.FeatureExtension");
                    }
                    com.android.build.gradle.internal.dsl.BundleOptions bundleOptions = ((FeatureExtension)androidConfig2).getBundle();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bundleOptions, (String)"((scope.globalScope.exte\u2026FeatureExtension).bundle)");
                    task.bundleOptions = BundleTaskKt.access$convert(bundleOptions);
                } else {
                    GlobalScope globalScope5 = this.scope.getGlobalScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalScope5, (String)"scope.globalScope");
                    AndroidConfig androidConfig3 = globalScope5.getExtension();
                    if (androidConfig3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
                    }
                    task.bundleOptions = BundleTaskKt.access$convert(((BaseAppModuleExtension)androidConfig3).getBundle());
                }
                if (this.scope.getNeedsMainDexListForBundle()) {
                    task.mainDexList = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MAIN_DEX_LIST_FOR_BUNDLE);
                }
                if (this.scope.getArtifacts().hasArtifact(InternalArtifactType.APK_MAPPING)) {
                    task.obsfuscationMappingFile = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_MAPPING);
                }
                GradleVariantConfiguration gradleVariantConfiguration = this.scope.getVariantConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"scope.variantConfiguration");
                CoreSigningConfig coreSigningConfig2 = gradleVariantConfiguration.getSigningConfig();
                if (coreSigningConfig2 == null) break block7;
                CoreSigningConfig coreSigningConfig3 = it = (coreSigningConfig = coreSigningConfig2);
                Intrinsics.checkExpressionValueIsNotNull((Object)coreSigningConfig3, (String)"it");
                task.keystoreFile = coreSigningConfig3.getStoreFile();
                task.keystorePassword = it.getStorePassword();
                task.keyAlias = it.getKeyAlias();
                task.keyPassword = it.getKeyPassword();
            }
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

