/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.res.namespaced.Aapt2DaemonManagerService;
import com.android.build.gradle.internal.res.namespaced.Aapt2ServiceKey;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.build.gradle.internal.transforms.InstantRunSplitApkBuilder;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.internal.aapt.AaptOptions;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.BlockingResourceLinker;
import com.android.builder.internal.aapt.CloseableBlockingResourceLinker;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Stopwatch;
import com.google.common.base.Suppliers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002EFB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020<H\u0015J\u0010\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020<H\u0015J\b\u0010?\u001a\u00020)H\u0016J\u0010\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020B0AH\u0015J\b\u0010C\u001a\u00020DH\u0007R*\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u00138GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R&\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00138\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001c@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\"@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0010\u0010(\u001a\u00020)8\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R&\u0010+\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020*8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00101\u001a\u0002002\u0006\u0010\u0005\u001a\u000200@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00106\u001a\u0002002\u0006\u0010\u0005\u001a\u000200@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00103\"\u0004\b8\u00105R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder;", "Lcom/android/build/gradle/internal/tasks/AndroidBuilderTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "aapt2FromMaven", "getAapt2FromMaven", "()Lorg/gradle/api/file/FileCollection;", "setAapt2FromMaven", "(Lorg/gradle/api/file/FileCollection;)V", "Lcom/android/builder/internal/aapt/AaptOptions;", "aaptOptions", "getAaptOptions", "()Lcom/android/builder/internal/aapt/AaptOptions;", "setAaptOptions", "(Lcom/android/builder/internal/aapt/AaptOptions;)V", "aaptVersion", "", "aaptVersion$annotations", "()V", "getAaptVersion", "()Ljava/lang/String;", "applicationId", "getApplicationId", "setApplicationId", "(Ljava/lang/String;)V", "Lcom/android/build/gradle/internal/incremental/InstantRunBuildContext;", "buildContext", "getBuildContext", "()Lcom/android/build/gradle/internal/incremental/InstantRunBuildContext;", "setBuildContext", "(Lcom/android/build/gradle/internal/incremental/InstantRunBuildContext;)V", "Lcom/android/ide/common/build/ApkInfo;", "mainApkInfo", "getMainApkInfo", "()Lcom/android/ide/common/build/ApkInfo;", "setMainApkInfo", "(Lcom/android/ide/common/build/ApkInfo;)V", "maxSlices", "", "Ljava/io/File;", "outputDir", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "resources", "getResources", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setResources", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "resourcesWithMainManifest", "getResourcesWithMainManifest", "setResourcesWithMainManifest", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "getAaptService", "Lcom/android/build/gradle/internal/res/namespaced/Aapt2ServiceKey;", "getAaptServicePoolsSize", "aapt2ServiceKey", "getNumberOfBuckets", "getWorkerItemClass", "Ljava/lang/Class;", "Ljava/lang/Runnable;", "taskAction", "", "ConfigAction", "GenerateSplitApkResource", "gradle"})
public class InstantRunSplitApkResourcesBuilder
extends AndroidBuilderTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private InstantRunBuildContext buildContext;
    @NotNull
    private AaptOptions aaptOptions;
    @NotNull
    private ApkInfo mainApkInfo;
    @Nullable
    private FileCollection aapt2FromMaven;
    @NotNull
    private BuildableArtifact resources;
    @NotNull
    private BuildableArtifact resourcesWithMainManifest;
    @NotNull
    private String applicationId;
    private final int maxSlices = 9;
    @NotNull
    private File outputDir;

    @NotNull
    public final InstantRunBuildContext getBuildContext() {
        InstantRunBuildContext instantRunBuildContext = this.buildContext;
        if (instantRunBuildContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildContext");
        }
        return instantRunBuildContext;
    }

    private final void setBuildContext(InstantRunBuildContext instantRunBuildContext) {
        this.buildContext = instantRunBuildContext;
    }

    @NotNull
    public final AaptOptions getAaptOptions() {
        AaptOptions aaptOptions = this.aaptOptions;
        if (aaptOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptions");
        }
        return aaptOptions;
    }

    private final void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @NotNull
    public final ApkInfo getMainApkInfo() {
        ApkInfo apkInfo = this.mainApkInfo;
        if (apkInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainApkInfo");
        }
        return apkInfo;
    }

    private final void setMainApkInfo(ApkInfo apkInfo) {
        this.mainApkInfo = apkInfo;
    }

    @Input
    @Optional
    @Nullable
    public final FileCollection getAapt2FromMaven() {
        return this.aapt2FromMaven;
    }

    private final void setAapt2FromMaven(FileCollection fileCollection) {
        this.aapt2FromMaven = fileCollection;
    }

    @NotNull
    public final BuildableArtifact getResources() {
        BuildableArtifact buildableArtifact = this.resources;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        }
        return buildableArtifact;
    }

    private final void setResources(BuildableArtifact buildableArtifact) {
        this.resources = buildableArtifact;
    }

    @NotNull
    public final BuildableArtifact getResourcesWithMainManifest() {
        BuildableArtifact buildableArtifact = this.resourcesWithMainManifest;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourcesWithMainManifest");
        }
        return buildableArtifact;
    }

    private final void setResourcesWithMainManifest(BuildableArtifact buildableArtifact) {
        this.resourcesWithMainManifest = buildableArtifact;
    }

    @Input
    @NotNull
    public final String getApplicationId() {
        String string = this.applicationId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
        }
        return string;
    }

    private final void setApplicationId(String string) {
        this.applicationId = string;
    }

    public static /* synthetic */ void aaptVersion$annotations() {
    }

    @Input
    @NotNull
    public final String getAaptVersion() {
        AndroidBuilder androidBuilder = this.getBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidBuilder, (String)"builder");
        BuildToolInfo buildToolInfo = androidBuilder.getBuildToolInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildToolInfo, (String)"builder.buildToolInfo");
        String string = buildToolInfo.getRevision().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.buildToolInfo.revision.toString()");
        return string;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    private final void setOutputDir(File file) {
        this.outputDir = file;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void taskAction() throws IOException {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        FileUtils.cleanOutputDir((File)file);
        Stopwatch stopwatch = Stopwatch.createStarted();
        int suggestedNbOfProcesses = this.getNumberOfBuckets();
        Aapt2ServiceKey aapt2ServiceKey = this.getAaptService();
        int n = this.getAaptServicePoolsSize(aapt2ServiceKey);
        int nbOfProcesses = Math.max(n, suggestedNbOfProcesses);
        n = 0;
        int n2 = nbOfProcesses - 1;
        if (n <= n2) {
            while (true) {
                void bucket;
                AndroidBuilder androidBuilder = this.getBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidBuilder, (String)"builder");
                String string = androidBuilder.getTarget().getPath(1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.target.getPath(IAndroidTarget.ANDROID_JAR)");
                String string2 = this.applicationId;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
                }
                ApkInfo apkInfo = this.mainApkInfo;
                if (apkInfo == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainApkInfo");
                }
                AaptOptions aaptOptions = this.aaptOptions;
                if (aaptOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptions");
                }
                BuildableArtifact buildableArtifact = this.resources;
                if (buildableArtifact == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
                }
                Object object = buildableArtifact.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"resources.get()");
                FileTree fileTree = ((FileCollection)object).getAsFileTree();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"resources.get().asFileTree");
                Set set = fileTree.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"resources.get().asFileTree.files");
                Collection collection = set;
                File file2 = this.outputDir;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
                }
                GenerateSplitApkResource.Params params = new GenerateSplitApkResource.Params(aapt2ServiceKey, string, this.maxSlices, (int)bucket, nbOfProcesses, string2, apkInfo, aaptOptions, collection, file2);
                this.workers.submit(this.getWorkerItemClass(), (Serializable)params);
                if (bucket == n2) break;
                ++bucket;
            }
        }
        this.workers.close();
        this.getLogger().quiet("Time to process all the split resources " + "" + stopwatch.elapsed() + " with " + nbOfProcesses + " slaves");
    }

    public int getNumberOfBuckets() {
        int n;
        if (SdkConstants.currentPlatform() == 2) {
            int n2 = 1;
            int n3 = this.maxSlices / 8;
            n = Math.max(n2, n3);
        } else {
            int n4 = 1;
            int n5 = Runtime.getRuntime().availableProcessors();
            int n6 = this.maxSlices;
            n5 = Math.min(n5, n6) / 2;
            n = Math.max(n4, n5);
        }
        return n;
    }

    @NotNull
    protected Aapt2ServiceKey getAaptService() {
        AndroidBuilder androidBuilder = this.getBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidBuilder, (String)"builder");
        BuildToolInfo buildToolInfo = androidBuilder.getBuildToolInfo();
        ILogger iLogger = this.getILogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)iLogger, (String)"iLogger");
        return Aapt2DaemonManagerService.registerAaptService$default(this.aapt2FromMaven, buildToolInfo, iLogger, null, 8, null);
    }

    protected int getAaptServicePoolsSize(@NotNull Aapt2ServiceKey aapt2ServiceKey) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2ServiceKey, (String)"aapt2ServiceKey");
        return Aapt2DaemonManagerService.getAaptPoolSize$default(aapt2ServiceKey, null, 2, null);
    }

    @NotNull
    protected Class<? extends Runnable> getWorkerItemClass() {
        return GenerateSplitApkResource.class;
    }

    @Inject
    public InstantRunSplitApkResourcesBuilder(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workers = Workers.getWorker$default(Workers.INSTANCE, workerExecutor, null, 2, null);
        this.maxSlices = 9;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getResources$p(InstantRunSplitApkResourcesBuilder $this) {
        BuildableArtifact buildableArtifact = $this.resources;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getResourcesWithMainManifest$p(InstantRunSplitApkResourcesBuilder $this) {
        BuildableArtifact buildableArtifact = $this.resourcesWithMainManifest;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourcesWithMainManifest");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputDir$p(InstantRunSplitApkResourcesBuilder $this) {
        File file = $this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    @Nullable
    public static final /* synthetic */ FileCollection access$getAapt2FromMaven$p(InstantRunSplitApkResourcesBuilder $this) {
        return $this.aapt2FromMaven;
    }

    @NotNull
    public static final /* synthetic */ String access$getApplicationId$p(InstantRunSplitApkResourcesBuilder $this) {
        String string = $this.applicationId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
        }
        return string;
    }

    @NotNull
    public static final /* synthetic */ InstantRunBuildContext access$getBuildContext$p(InstantRunSplitApkResourcesBuilder $this) {
        InstantRunBuildContext instantRunBuildContext = $this.buildContext;
        if (instantRunBuildContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildContext");
        }
        return instantRunBuildContext;
    }

    @NotNull
    public static final /* synthetic */ AaptOptions access$getAaptOptions$p(InstantRunSplitApkResourcesBuilder $this) {
        AaptOptions aaptOptions = $this.aaptOptions;
        if (aaptOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aaptOptions");
        }
        return aaptOptions;
    }

    @NotNull
    public static final /* synthetic */ ApkInfo access$getMainApkInfo$p(InstantRunSplitApkResourcesBuilder $this) {
        ApkInfo apkInfo = $this.mainApkInfo;
        if (apkInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainApkInfo");
        }
        return apkInfo;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder$GenerateSplitApkResource;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder$GenerateSplitApkResource$Params;", "(Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder$GenerateSplitApkResource$Params;)V", "generateSplitApkResource", "", "linker", "Lcom/android/builder/internal/aapt/CloseableBlockingResourceLinker;", "sliceNumber", "", "requestAaptDaemon", "aapt2ServiceKey", "Lcom/android/build/gradle/internal/res/namespaced/Aapt2ServiceKey;", "run", "Companion", "Params", "gradle"})
    public static class GenerateSplitApkResource
    implements Runnable {
        private final Params params;
        @NotNull
        private static final LoggerWrapper logger;
        public static final Companion Companion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Closeable closeable = (Closeable)this.requestAaptDaemon(this.params.getAapt2ServiceKey());
            Throwable throwable = null;
            try {
                CloseableBlockingResourceLinker it = (CloseableBlockingResourceLinker)closeable;
                int n = this.params.getBucketNumber();
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(n, this.params.getMaxSlices())), (int)this.params.getStepSize());
                int n2 = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                int n5 = n2;
                int n6 = n3;
                if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void sliceNumber;
                        long processingStart = System.currentTimeMillis();
                        this.generateSplitApkResource(it, (int)sliceNumber);
                        logger.quiet("processing " + (int)sliceNumber + " in bucket " + this.params.getBucketNumber() + " took " + (System.currentTimeMillis() - processingStart), new Object[0]);
                        if (sliceNumber == n3) break;
                        sliceNumber += n4;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        protected CloseableBlockingResourceLinker requestAaptDaemon(@NotNull Aapt2ServiceKey aapt2ServiceKey) {
            Intrinsics.checkParameterIsNotNull((Object)aapt2ServiceKey, (String)"aapt2ServiceKey");
            return (CloseableBlockingResourceLinker)Aapt2DaemonManagerService.getAaptDaemon$default(this.params.getAapt2ServiceKey(), null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        protected void generateSplitApkResource(@NotNull CloseableBlockingResourceLinker linker, int sliceNumber) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)linker, (String)"linker");
            String uniqueName = DexArchiveBuilderTransform.getSliceName(sliceNumber);
            File apkSupportDir = new File(this.params.getOutputDirectory(), uniqueName);
            FileUtils.cleanOutputDir((File)apkSupportDir);
            File androidManifest = InstantRunSplitApkBuilder.generateSplitApkManifest(apkSupportDir, uniqueName, (Supplier)Suppliers.ofInstance((Object)this.params.getApplicationId()), this.params.getMainApkInfo().getVersionName(), this.params.getMainApkInfo().getVersionCode(), null);
            File resFilePackageFile = new File(apkSupportDir, "resources_ap");
            Iterable iterable = $receiver$iv = (Iterable)this.params.getResources();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                File file = (File)element$iv$iv;
                String string = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                if (!StringsKt.endsWith$default((String)string, (String)"ap_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List importedAPKs = (List)destination$iv$iv;
            AaptPackageConfig.Builder builder = new AaptPackageConfig.Builder().setAndroidJarPath(this.params.getAndroidJarPath());
            File file = androidManifest;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"androidManifest");
            AaptPackageConfig.Builder aaptConfig = builder.setManifestFile(file).setOptions(this.params.getAaptOptions()).setDebuggable(true).setVariantType((VariantType)VariantTypeImpl.BASE_APK).setImports((Collection)importedAPKs).setResourceOutputApk(resFilePackageFile);
            AndroidBuilder.processResources((BlockingResourceLinker)((BlockingResourceLinker)linker), (AaptPackageConfig)aaptConfig.build(), (ILogger)logger);
        }

        @Inject
        public GenerateSplitApkResource(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }

        static {
            Companion = new Companion(null);
            logger = new LoggerWrapper(Logging.getLogger(Companion.getClass()));
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder$GenerateSplitApkResource$Params;", "Ljava/io/Serializable;", "aapt2ServiceKey", "Lcom/android/build/gradle/internal/res/namespaced/Aapt2ServiceKey;", "androidJarPath", "", "maxSlices", "", "bucketNumber", "stepSize", "applicationId", "mainApkInfo", "Lcom/android/ide/common/build/ApkInfo;", "aaptOptions", "Lcom/android/builder/internal/aapt/AaptOptions;", "resources", "", "Ljava/io/File;", "outputDirectory", "(Lcom/android/build/gradle/internal/res/namespaced/Aapt2ServiceKey;Ljava/lang/String;IIILjava/lang/String;Lcom/android/ide/common/build/ApkInfo;Lcom/android/builder/internal/aapt/AaptOptions;Ljava/util/Collection;Ljava/io/File;)V", "getAapt2ServiceKey", "()Lcom/android/build/gradle/internal/res/namespaced/Aapt2ServiceKey;", "getAaptOptions", "()Lcom/android/builder/internal/aapt/AaptOptions;", "getAndroidJarPath", "()Ljava/lang/String;", "getApplicationId", "getBucketNumber", "()I", "getMainApkInfo", "()Lcom/android/ide/common/build/ApkInfo;", "getMaxSlices", "getOutputDirectory", "()Ljava/io/File;", "getResources", "()Ljava/util/Collection;", "getStepSize", "gradle"})
        public static final class Params
        implements Serializable {
            @NotNull
            private final Aapt2ServiceKey aapt2ServiceKey;
            @NotNull
            private final String androidJarPath;
            private final int maxSlices;
            private final int bucketNumber;
            private final int stepSize;
            @NotNull
            private final String applicationId;
            @NotNull
            private final ApkInfo mainApkInfo;
            @NotNull
            private final AaptOptions aaptOptions;
            @NotNull
            private final Collection<File> resources;
            @NotNull
            private final File outputDirectory;

            @NotNull
            public final Aapt2ServiceKey getAapt2ServiceKey() {
                return this.aapt2ServiceKey;
            }

            @NotNull
            public final String getAndroidJarPath() {
                return this.androidJarPath;
            }

            public final int getMaxSlices() {
                return this.maxSlices;
            }

            public final int getBucketNumber() {
                return this.bucketNumber;
            }

            public final int getStepSize() {
                return this.stepSize;
            }

            @NotNull
            public final String getApplicationId() {
                return this.applicationId;
            }

            @NotNull
            public final ApkInfo getMainApkInfo() {
                return this.mainApkInfo;
            }

            @NotNull
            public final AaptOptions getAaptOptions() {
                return this.aaptOptions;
            }

            @NotNull
            public final Collection<File> getResources() {
                return this.resources;
            }

            @NotNull
            public final File getOutputDirectory() {
                return this.outputDirectory;
            }

            public Params(@NotNull Aapt2ServiceKey aapt2ServiceKey, @NotNull String androidJarPath, int maxSlices, int bucketNumber, int stepSize, @NotNull String applicationId, @NotNull ApkInfo mainApkInfo, @NotNull AaptOptions aaptOptions, @NotNull Collection<? extends File> resources, @NotNull File outputDirectory) {
                Intrinsics.checkParameterIsNotNull((Object)aapt2ServiceKey, (String)"aapt2ServiceKey");
                Intrinsics.checkParameterIsNotNull((Object)androidJarPath, (String)"androidJarPath");
                Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
                Intrinsics.checkParameterIsNotNull((Object)mainApkInfo, (String)"mainApkInfo");
                Intrinsics.checkParameterIsNotNull((Object)aaptOptions, (String)"aaptOptions");
                Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
                Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
                this.aapt2ServiceKey = aapt2ServiceKey;
                this.androidJarPath = androidJarPath;
                this.maxSlices = maxSlices;
                this.bucketNumber = bucketNumber;
                this.stepSize = stepSize;
                this.applicationId = applicationId;
                this.mainApkInfo = mainApkInfo;
                this.aaptOptions = aaptOptions;
                this.resources = resources;
                this.outputDirectory = outputDirectory;
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder$GenerateSplitApkResource$Companion;", "", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "gradle"})
        public static final class Companion {
            @NotNull
            public final LoggerWrapper getLogger() {
                return logger;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/InstantRunSplitApkResourcesBuilder;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "getVariantScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle"})
    public static final class ConfigAction
    implements TaskConfigAction<InstantRunSplitApkResourcesBuilder> {
        @NotNull
        private final VariantScope variantScope;

        @Override
        @NotNull
        public String getName() {
            String string = this.variantScope.getTaskName("instantRunSplitApkResources");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026antRunSplitApkResources\")");
            return string;
        }

        @Override
        @NotNull
        public Class<InstantRunSplitApkResourcesBuilder> getType() {
            return InstantRunSplitApkResourcesBuilder.class;
        }

        @Override
        public void execute(@NotNull InstantRunSplitApkResourcesBuilder task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            BuildArtifactsHolder artifacts = this.variantScope.getArtifacts();
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            task.resources = artifacts.getFinalArtifactFiles(InternalArtifactType.PROCESSED_RES);
            InternalArtifactType resourcesWithMainManifest = this.variantScope.getInstantRunBuildContext().useSeparateApkForResources() ? InternalArtifactType.INSTANT_RUN_MAIN_APK_RESOURCES : InternalArtifactType.PROCESSED_RES;
            task.resourcesWithMainManifest = artifacts.getFinalArtifactFiles(resourcesWithMainManifest);
            task.dependsOn(new Object[]{task.getResources(), task.getResourcesWithMainManifest()});
            task.outputDir = BuildArtifactsHolder.appendArtifact$default(artifacts, InternalArtifactType.INSTANT_RUN_SPLIT_APK_RESOURCES, (Task)task, null, 4, null);
            GlobalScope globalScope2 = globalScope;
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"globalScope");
            task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(globalScope2);
            GradleVariantConfiguration gradleVariantConfiguration = this.variantScope.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            String string = gradleVariantConfiguration.getApplicationId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.variantConfiguration.applicationId");
            task.applicationId = string;
            task.setAndroidBuilder(globalScope.getAndroidBuilder());
            InstantRunBuildContext instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)instantRunBuildContext, (String)"variantScope.instantRunBuildContext");
            task.buildContext = instantRunBuildContext;
            AndroidConfig androidConfig = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidConfig, (String)"globalScope.extension");
            com.android.build.gradle.internal.dsl.AaptOptions aaptOptions = androidConfig.getAaptOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)aaptOptions, (String)"globalScope.extension.aaptOptions");
            task.aaptOptions = DslAdaptersKt.convert(aaptOptions);
            OutputScope outputScope = this.variantScope.getOutputScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)outputScope, (String)"variantScope.outputScope");
            ApkData apkData = outputScope.getMainSplit();
            Intrinsics.checkExpressionValueIsNotNull((Object)apkData, (String)"variantScope.outputScope.mainSplit");
            task.mainApkInfo = (ApkInfo)apkData;
            task.setVariantName(this.variantScope.getFullVariantName());
            task.getOutputs().upToDateWhen((Spec)new Spec<Task>(this){
                final /* synthetic */ ConfigAction this$0;

                public final boolean isSatisfiedBy(Task it) {
                    return !this.this$0.getVariantScope().getInstantRunBuildContext().hasVerifierStatusBeenSet(InstantRunVerifierStatus.MANIFEST_FILE_CHANGE);
                }
                {
                    this.this$0 = configAction;
                }
            });
        }

        @NotNull
        public final VariantScope getVariantScope() {
            return this.variantScope;
        }

        public ConfigAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            this.variantScope = variantScope;
        }
    }
}

