/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.DexerTool;
import com.android.builder.utils.FileCache;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.function.Supplier;

public class DexArchiveBuilderTransformBuilder {
    private Supplier<List<File>> androidJarClasspath;
    private DexOptions dexOptions;
    private MessageReceiver messageReceiver;
    private FileCache userLevelCache;
    private int minSdkVersion;
    private DexerTool dexer;
    private boolean useGradleWorkers;
    private Integer inBufferSize;
    private Integer outBufferSize;
    private boolean isDebuggable;
    private VariantScope.Java8LangSupport java8LangSupportType;
    private String projectVariant;
    private Integer numberOfBuckets;
    private boolean includeFeaturesInScopes;
    private boolean isInstantRun;

    public DexArchiveBuilderTransformBuilder setAndroidJarClasspath(Supplier<List<File>> androidJarClasspath) {
        this.androidJarClasspath = androidJarClasspath;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setDexOptions(DexOptions dexOptions) {
        this.dexOptions = dexOptions;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setUserLevelCache(FileCache userLevelCache) {
        this.userLevelCache = userLevelCache;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setMinSdkVersion(int minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setDexer(DexerTool dexer) {
        this.dexer = dexer;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setUseGradleWorkers(boolean useGradleWorkers) {
        this.useGradleWorkers = useGradleWorkers;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setInBufferSize(Integer inBufferSize) {
        this.inBufferSize = inBufferSize;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setOutBufferSize(Integer outBufferSize) {
        this.outBufferSize = outBufferSize;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setIsDebuggable(boolean isDebuggable) {
        this.isDebuggable = isDebuggable;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setJava8LangSupportType(VariantScope.Java8LangSupport java8LangSupportType) {
        this.java8LangSupportType = java8LangSupportType;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setProjectVariant(String projectVariant) {
        this.projectVariant = projectVariant;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setNumberOfBuckets(Integer numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setIncludeFeaturesInScope(boolean includeFeaturesInScopes) {
        this.includeFeaturesInScopes = includeFeaturesInScopes;
        return this;
    }

    public DexArchiveBuilderTransformBuilder setIsInstantRun(boolean isInstantRun) {
        this.isInstantRun = isInstantRun;
        return this;
    }

    public DexArchiveBuilderTransform createDexArchiveBuilderTransform() {
        Preconditions.checkNotNull(this.androidJarClasspath);
        Preconditions.checkNotNull((Object)this.dexOptions);
        Preconditions.checkNotNull((Object)this.messageReceiver);
        Preconditions.checkNotNull((Object)this.dexer);
        Preconditions.checkNotNull((Object)((Object)this.java8LangSupportType));
        Preconditions.checkNotNull((Object)this.projectVariant);
        return new DexArchiveBuilderTransform(this.androidJarClasspath, this.dexOptions, this.messageReceiver, this.userLevelCache, this.minSdkVersion, this.dexer, this.useGradleWorkers, this.inBufferSize, this.outBufferSize, this.isDebuggable, this.java8LangSupportType, this.projectVariant, this.numberOfBuckets, this.includeFeaturesInScopes, this.isInstantRun);
    }
}

