/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.scope.TaskContainer;
import com.android.ide.common.build.ApkData;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.model.ObjectFactory;

public class VariantOutputFactory {
    private final Class<? extends BaseVariantOutput> targetClass;
    private final ObjectFactory objectFactory;
    private final BaseVariantImpl variantPublicApi;
    private final TaskContainer taskContainer;
    private final AndroidConfig androidConfig;

    public VariantOutputFactory(Class<? extends BaseVariantOutput> targetClass, ObjectFactory objectFactory, AndroidConfig androidConfig, BaseVariantImpl variantPublicApi, TaskContainer taskContainer) {
        this.targetClass = targetClass;
        this.objectFactory = objectFactory;
        this.variantPublicApi = variantPublicApi;
        this.taskContainer = taskContainer;
        this.androidConfig = androidConfig;
    }

    public VariantOutput create(ApkData apkData) {
        BaseVariantOutput variantOutput = (BaseVariantOutput)this.objectFactory.newInstance(this.targetClass, new Object[]{apkData, this.taskContainer});
        this.androidConfig.getBuildOutputs().add(variantOutput);
        if (this.variantPublicApi != null) {
            this.variantPublicApi.addOutputs((List<BaseVariantOutput>)ImmutableList.of((Object)variantOutput));
        }
        return variantOutput;
    }
}

