/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.testing.api.TestServer;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class TestServerTask
extends AndroidVariantTask {
    private BuildableArtifact testApks;
    private BuildableArtifact testedApks;
    TestServer testServer;

    @TaskAction
    public void sendToServer() {
        ImmutableList testedApkFiles;
        Object object = testedApkFiles = this.testedApks != null ? ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, this.testedApks).stream().map(BuildOutput::getOutputFile).collect(Collectors.toList()) : ImmutableList.of();
        if (testedApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs");
        }
        File testedApkFile = testedApkFiles.isEmpty() ? null : (File)testedApkFiles.get(0);
        List testApkFiles = ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, this.testApks).stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
        if (testApkFiles.size() > 1) {
            throw new RuntimeException("Cannot handle split APKs in test APKs");
        }
        this.testServer.uploadApks(this.getVariantName(), (File)testApkFiles.get(0), testedApkFile);
    }

    @InputFiles
    public BuildableArtifact getTestApks() {
        return this.testApks;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getTestedApks() {
        return this.testedApks;
    }

    @Override
    @Input
    public String getVariantName() {
        return (String)Preconditions.checkNotNull((Object)super.getVariantName(), (Object)"Test server task must have a variant name.");
    }

    public TestServer getTestServer() {
        return this.testServer;
    }

    public void setTestServer(TestServer testServer) {
        this.testServer = testServer;
    }

    public void setTestApks(BuildableArtifact testApks) {
        this.testApks = testApks;
    }

    public void setTestedApks(BuildableArtifact testedApks) {
        this.testedApks = testedApks;
    }

    public static class TestServerTaskConfigAction
    extends TaskConfigAction<TestServerTask> {
        private final VariantScope scope;
        private final TestServer testServer;

        public TestServerTaskConfigAction(VariantScope scope, TestServer testServer) {
            this.scope = scope;
            this.testServer = testServer;
        }

        @Override
        public String getName() {
            return this.scope.getVariantConfiguration().hasFlavors() ? this.scope.getTaskName(this.testServer.getName() + "Upload") : this.testServer.getName() + "Upload";
        }

        @Override
        public Class<TestServerTask> getType() {
            return TestServerTask.class;
        }

        @Override
        public void execute(TestServerTask serverTask) {
            BaseVariantData testedVariantData = this.scope.getTestedVariantData();
            String variantName = this.scope.getVariantConfiguration().getFullName();
            serverTask.setDescription("Uploads APKs for Build '" + variantName + "' to Test Server '" + StringHelper.capitalize((String)this.testServer.getName()) + "'.");
            serverTask.setGroup("verification");
            serverTask.setVariantName(variantName);
            serverTask.setTestServer(this.testServer);
            if (testedVariantData != null && testedVariantData.getScope().getArtifacts().hasArtifact(InternalArtifactType.APK)) {
                serverTask.setTestedApks(testedVariantData.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK));
            }
            serverTask.setTestApks(this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK));
            if (!this.testServer.isConfigured()) {
                serverTask.setEnabled(false);
            }
        }
    }
}

