/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.options.BooleanOption;
import com.google.common.base.Throwables;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildAdapter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/EarlyDependencyResolutionListener;", "Lorg/gradle/api/artifacts/DependencyResolutionListener;", "Lorg/gradle/BuildAdapter;", "project", "Lorg/gradle/api/Project;", "warn", "", "fail", "(Lorg/gradle/api/Project;ZZ)V", "getFail", "()Z", "getProject", "()Lorg/gradle/api/Project;", "getWarn", "afterResolve", "", "p0", "Lorg/gradle/api/artifacts/ResolvableDependencies;", "beforeResolve", "configuration", "errorMessage", "", "configurationName", "projectsEvaluated", "gradle", "Lorg/gradle/api/invocation/Gradle;"})
final class EarlyDependencyResolutionListener
extends BuildAdapter
implements DependencyResolutionListener {
    @NotNull
    private final Project project;
    private final boolean warn;
    private final boolean fail;

    public void beforeResolve(@NotNull ResolvableDependencies configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        if (Intrinsics.areEqual((Object)configuration.getName(), (Object)"classpath")) {
            return;
        }
        Object object = this.project.findProperty(BooleanOption.IDE_BUILD_MODEL_ONLY.getPropertyName());
        if (object != null) {
            Object object2;
            Object it;
            Object object3 = it = (object2 = object);
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
            if (BooleanOption.IDE_BUILD_MODEL_ONLY.parse(object3).booleanValue()) {
                return;
            }
        }
        String string = configuration.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
        String errorMessage = this.errorMessage(string);
        if (this.fail) {
            throw (Throwable)new RuntimeException(errorMessage);
        }
        if (this.warn) {
            this.project.getLogger().warn("" + errorMessage + "\nRun with --info for a stacktrace.");
        }
        if (this.project.getLogger().isEnabled(LogLevel.INFO)) {
            this.project.getLogger().info(Throwables.getStackTraceAsString((Throwable)new RuntimeException(errorMessage)));
        }
    }

    public void afterResolve(@NotNull ResolvableDependencies p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
    }

    public void projectsEvaluated(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        gradle.removeListener((Object)this);
    }

    private final String errorMessage(String configurationName) {
        return "Configuration '" + configurationName + "' was resolved during configuration time.\nThis is a build performance and scalability issue.\nSee https://github.com/gradle/gradle/issues/2298";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getWarn() {
        return this.warn;
    }

    public final boolean getFail() {
        return this.fail;
    }

    public EarlyDependencyResolutionListener(@NotNull Project project, boolean warn, boolean fail) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.warn = warn;
        this.fail = fail;
    }
}

