/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.ArtifactConfigurationException;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.OutputFileProvider;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002J)\u0010\r\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0018\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/api/artifact/OutputFileProviderImpl;", "Lcom/android/build/api/artifact/OutputFileProvider;", "artifactsHolder", "Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;", "replacedArtifacts", "", "Lcom/android/build/api/artifact/ArtifactType;", "appendedArtifacts", "task", "Lorg/gradle/api/Task;", "(Lcom/android/build/gradle/internal/scope/BuildArtifactsHolder;Ljava/util/Collection;Ljava/util/Collection;Lorg/gradle/api/Task;)V", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "filesMap", "Lcom/google/common/collect/Multimap;", "commit", "", "getArtifactTypesForFile", "artifactTypes", "", "filename", "", "", "(Ljava/lang/String;[Lcom/android/build/api/artifact/ArtifactType;)Ljava/io/File;", "gradle"})
public final class OutputFileProviderImpl
implements OutputFileProvider {
    private final Multimap<ArtifactType, File> filesMap;
    private final BuildArtifactsHolder artifactsHolder;
    private final Collection<ArtifactType> replacedArtifacts;
    private final Collection<ArtifactType> appendedArtifacts;
    private final Task task;

    @NotNull
    public File getFile(@NotNull String filename, ArtifactType ... artifactTypes) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)artifactTypes, (String)"artifactTypes");
        Collection<ArtifactType> artifactsTypesForFile = this.getArtifactTypesForFile(ArraysKt.asList((Object[])artifactTypes));
        Iterable $receiver$iv = artifactsTypesForFile;
        for (Object element$iv : $receiver$iv) {
            ArtifactType it = (ArtifactType)element$iv;
            if (this.replacedArtifacts.contains(it) || this.appendedArtifacts.contains(it)) continue;
            throw (Throwable)new ArtifactConfigurationException("" + it + " is not configured to be appended or " + "replaced by this task, declare intent with append() or replace() APIs");
        }
        if (artifactsTypesForFile.size() == 1) {
            Object object = Iterables.getOnlyElement((Iterable)artifactsTypesForFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Iterables.getOnlyElement(artifactsTypesForFile)");
            file = this.artifactsHolder.createFile$gradle(this.task, (ArtifactType)object, filename);
        } else {
            file = this.artifactsHolder.createFile$gradle(this.task, filename);
        }
        File newFile = file;
        Iterable $receiver$iv2 = artifactsTypesForFile;
        for (Object element$iv : $receiver$iv2) {
            ArtifactType it = (ArtifactType)element$iv;
            this.filesMap.put((Object)it, (Object)newFile);
        }
        File file2 = newFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"newFile");
        return file2;
    }

    @NotNull
    public File getFile() {
        OutputFileProviderImpl outputFileProviderImpl = this;
        List list = CollectionsKt.emptyList();
        Collection<ArtifactType> artifactTypes = outputFileProviderImpl.getArtifactTypesForFile(list);
        if (artifactTypes.size() != 1) {
            throw (Throwable)new ArtifactConfigurationException("file() API cannot be used when task is configured to replace or append more than one type.\\n\n                       This task is configured to output : " + Joiner.on((String)",").join((Iterable)artifactTypes));
        }
        return this.getFile(this.artifactsHolder.getArtifactFilename$gradle((ArtifactType)CollectionsKt.elementAt((Iterable)artifactTypes, (int)0)), new ArtifactType[0]);
    }

    public final void commit() {
        ArtifactType artifactType;
        Iterable $receiver$iv = this.replacedArtifacts;
        for (Object element$iv : $receiver$iv) {
            artifactType = (ArtifactType)element$iv;
            Collection collection = this.filesMap.get((Object)artifactType);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesMap.get(artifactType)");
            this.artifactsHolder.replaceArtifact(artifactType, collection, this.task);
        }
        $receiver$iv = this.appendedArtifacts;
        for (Object element$iv : $receiver$iv) {
            artifactType = (ArtifactType)element$iv;
            Collection collection = this.filesMap.get((Object)artifactType);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesMap.get(artifactType)");
            this.artifactsHolder.appendArtifact(artifactType, collection, this.task);
        }
    }

    private final Collection<ArtifactType> getArtifactTypesForFile(List<? extends ArtifactType> artifactTypes) {
        Collection calculatedArtifactTypes;
        Collection collection = calculatedArtifactTypes = artifactTypes.isEmpty() ? (Collection)CollectionsKt.union((Iterable)this.replacedArtifacts, (Iterable)this.appendedArtifacts) : (Collection)artifactTypes;
        if (calculatedArtifactTypes.isEmpty()) {
            throw (Throwable)new ArtifactConfigurationException(StringsKt.trimMargin$default((String)"Task cannot be configured to output nothing,\n                |please use append() or replace() to declare output", null, (int)1, null));
        }
        return calculatedArtifactTypes;
    }

    public OutputFileProviderImpl(@NotNull BuildArtifactsHolder artifactsHolder, @NotNull Collection<? extends ArtifactType> replacedArtifacts, @NotNull Collection<? extends ArtifactType> appendedArtifacts, @NotNull Task task) {
        Intrinsics.checkParameterIsNotNull((Object)artifactsHolder, (String)"artifactsHolder");
        Intrinsics.checkParameterIsNotNull(replacedArtifacts, (String)"replacedArtifacts");
        Intrinsics.checkParameterIsNotNull(appendedArtifacts, (String)"appendedArtifacts");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.artifactsHolder = artifactsHolder;
        this.replacedArtifacts = replacedArtifacts;
        this.appendedArtifacts = appendedArtifacts;
        this.task = task;
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMultimap, (String)"HashMultimap.create()");
        this.filesMap = (Multimap)hashMultimap;
    }
}

