/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.build.gradle.internal.cxx.process.ChunkBytesToLineOutputStream;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutput;
import com.android.build.gradle.internal.cxx.process.MultiplexingOutputStream;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0018H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/cxx/process/DefaultProcessOutputHandler;", "Lcom/android/ide/common/process/ProcessOutputHandler;", "stderrFile", "Ljava/io/File;", "stdoutFile", "print", "Lkotlin/Function1;", "", "", "logPrefix", "logErrorToInfo", "", "logOutputToInfo", "(Ljava/io/File;Ljava/io/File;Lkotlin/jvm/functions/Function1;Ljava/lang/String;ZZ)V", "stderr", "Ljava/io/FileOutputStream;", "getStderr", "()Ljava/io/FileOutputStream;", "setStderr", "(Ljava/io/FileOutputStream;)V", "stdout", "getStdout", "setStdout", "createOutput", "Lcom/android/ide/common/process/ProcessOutput;", "handleOutput", "processOutput", "gradle"})
public final class DefaultProcessOutputHandler
implements ProcessOutputHandler {
    @Nullable
    private FileOutputStream stderr;
    @Nullable
    private FileOutputStream stdout;
    private final File stderrFile;
    private final File stdoutFile;
    private final Function1<String, Unit> print;
    private final String logPrefix;
    private final boolean logErrorToInfo;
    private final boolean logOutputToInfo;

    @Nullable
    public final FileOutputStream getStderr() {
        return this.stderr;
    }

    public final void setStderr(@Nullable FileOutputStream fileOutputStream) {
        this.stderr = fileOutputStream;
    }

    @Nullable
    public final FileOutputStream getStdout() {
        return this.stdout;
    }

    public final void setStdout(@Nullable FileOutputStream fileOutputStream) {
        this.stdout = fileOutputStream;
    }

    @NotNull
    public ProcessOutput createOutput() {
        FileOutputStream singleStderr = new FileOutputStream(this.stderrFile, true);
        FileOutputStream singleStdout = new FileOutputStream(this.stdoutFile, true);
        List stderrReceivers = CollectionsKt.mutableListOf((Object[])new OutputStream[]{singleStderr});
        List stdoutReceivers = CollectionsKt.mutableListOf((Object[])new OutputStream[]{singleStdout});
        if (this.logErrorToInfo) {
            stderrReceivers.add(new ChunkBytesToLineOutputStream(this.print, this.logPrefix, 0, 4, null));
        }
        if (this.logOutputToInfo) {
            stdoutReceivers.add(new ChunkBytesToLineOutputStream(this.print, this.logPrefix, 0, 4, null));
        }
        return new DefaultProcessOutput(singleStderr, singleStdout, new MultiplexingOutputStream(stdoutReceivers), new MultiplexingOutputStream(stderrReceivers));
    }

    public void handleOutput(@NotNull ProcessOutput processOutput) {
        Intrinsics.checkParameterIsNotNull((Object)processOutput, (String)"processOutput");
        if (this.stdout != null) {
            throw (Throwable)new RuntimeException("Multiple calls");
        }
        DefaultProcessOutput output2 = (DefaultProcessOutput)processOutput;
        this.stderr = output2.getStderr();
        this.stdout = output2.getStdout();
    }

    public DefaultProcessOutputHandler(@NotNull File stderrFile, @NotNull File stdoutFile, @NotNull Function1<? super String, Unit> print, @NotNull String logPrefix, boolean logErrorToInfo, boolean logOutputToInfo) {
        Intrinsics.checkParameterIsNotNull((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkParameterIsNotNull((Object)stdoutFile, (String)"stdoutFile");
        Intrinsics.checkParameterIsNotNull(print, (String)"print");
        Intrinsics.checkParameterIsNotNull((Object)logPrefix, (String)"logPrefix");
        this.stderrFile = stderrFile;
        this.stdoutFile = stdoutFile;
        this.print = print;
        this.logPrefix = logPrefix;
        this.logErrorToInfo = logErrorToInfo;
        this.logOutputToInfo = logOutputToInfo;
    }
}

