/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.errors.SyncIssueHandler;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public class MergeConsumerProguardFilesConfigAction
extends TaskConfigAction<MergeFileTask> {
    private final VariantScope variantScope;

    public MergeConsumerProguardFilesConfigAction(VariantScope variantScope) {
        this.variantScope = variantScope;
    }

    @Override
    public String getName() {
        return this.variantScope.getTaskName("merge", "ConsumerProguardFiles");
    }

    @Override
    public Class<MergeFileTask> getType() {
        return MergeFileTask.class;
    }

    @Override
    public void execute(MergeFileTask mergeProguardFiles) {
        Project project = this.variantScope.getGlobalScope().getProject();
        mergeProguardFiles.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
        mergeProguardFiles.setOutputFile(this.variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.CONSUMER_PROGUARD_FILE, (Task)mergeProguardFiles, "proguard.txt"));
        boolean hasFeaturePlugin = project.getPlugins().hasPlugin(FeaturePlugin.class);
        boolean includeProguardFiles = hasFeaturePlugin || this.variantScope.getType().isDynamicFeature();
        boolean isBaseFeature = hasFeaturePlugin && this.variantScope.getGlobalScope().getExtension().getBaseFeature() != false;
        List<File> consumerProguardFiles = this.variantScope.getConsumerProguardFiles();
        if (includeProguardFiles) {
            consumerProguardFiles.addAll(this.variantScope.getExplicitProguardFiles());
        }
        if (!isBaseFeature) {
            this.checkForDefaultFiles(consumerProguardFiles);
        }
        ConfigurableFileCollection inputFiles = project.files(new Object[]{consumerProguardFiles});
        if (this.variantScope.getType().isFeatureSplit()) {
            inputFiles.from(new Object[]{this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES)});
        }
        mergeProguardFiles.setInputFiles((FileCollection)inputFiles);
    }

    private void checkForDefaultFiles(Collection<File> consumerProguardFiles) {
        HashMap<File, String> defaultFiles = new HashMap<File, String>();
        for (String knownFileName : ProguardFiles.KNOWN_FILE_NAMES) {
            defaultFiles.put(ProguardFiles.getDefaultProguardFile(knownFileName, this.variantScope.getGlobalScope().getProject()), knownFileName);
        }
        SyncIssueHandler issueReporter = this.variantScope.getGlobalScope().getErrorHandler();
        for (File consumerProguardFile : consumerProguardFiles) {
            if (!defaultFiles.containsKey(consumerProguardFile)) continue;
            String errorMessage = this.variantScope.getType().isDynamicFeature() || this.variantScope.getGlobalScope().getProject().getPlugins().hasPlugin(FeaturePlugin.class) ? "Default file " + (String)defaultFiles.get(consumerProguardFile) + " should not be specified in this module. It can be specified in the base module instead." : "Default file " + (String)defaultFiles.get(consumerProguardFile) + " should not be used as a consumer configuration file.";
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(errorMessage));
        }
    }
}

