/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import java.io.IOException;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;

public class SourceSetsTask
extends AbstractReportTask {
    private final TextReportRenderer mRenderer = new TextReportRenderer();
    private AndroidConfig config;

    protected ReportRenderer getRenderer() {
        return this.mRenderer;
    }

    public AndroidConfig getConfig() {
        return this.config;
    }

    public void setConfig(AndroidConfig config2) {
        this.config = config2;
    }

    protected void generate(Project project) throws IOException {
        if (this.config != null) {
            for (AndroidSourceSet sourceSet : this.config.getSourceSets()) {
                this.mRenderer.getBuilder().subheading(sourceSet.getName());
                this.renderKeyValue("Compile configuration: ", sourceSet.getCompileConfigurationName());
                this.renderKeyValue("build.gradle name: ", "android.sourceSets." + sourceSet.getName());
                this.renderDirectorySet("Java sources", sourceSet.getJava(), project);
                if (!sourceSet.getName().startsWith("test")) {
                    this.renderKeyValue("Manifest file: ", project.getRootProject().relativePath((Object)sourceSet.getManifest().getSrcFile()));
                    this.renderDirectorySet("Android resources", sourceSet.getRes(), project);
                    this.renderDirectorySet("Assets", sourceSet.getAssets(), project);
                    this.renderDirectorySet("AIDL sources", sourceSet.getAidl(), project);
                    this.renderDirectorySet("RenderScript sources", sourceSet.getRenderscript(), project);
                    this.renderDirectorySet("JNI sources", sourceSet.getJni(), project);
                    this.renderDirectorySet("JNI libraries", sourceSet.getJniLibs(), project);
                }
                this.renderDirectorySet("Java-style resources", sourceSet.getResources(), project);
                this.mRenderer.getTextOutput().println();
            }
        }
        this.mRenderer.complete();
    }

    private void renderDirectorySet(String name, AndroidSourceDirectorySet java, Project project) {
        String relativePaths = java.getSrcDirs().stream().map(file -> project.getRootProject().relativePath(file)).collect(Collectors.joining(", "));
        this.renderKeyValue(name + ": ", String.format("[%s]", relativePaths));
    }

    private void renderKeyValue(String o, String o1) {
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text((Object)o);
        this.mRenderer.getTextOutput().withStyle(StyledTextOutput.Style.Info).text((Object)o1);
        this.mRenderer.getTextOutput().println();
    }

    public static class ConfigAction
    extends TaskConfigAction<SourceSetsTask> {
        private final AndroidConfig extension;

        public ConfigAction(AndroidConfig extension) {
            this.extension = extension;
        }

        @Override
        public String getName() {
            return "sourceSets";
        }

        @Override
        public Class<SourceSetsTask> getType() {
            return SourceSetsTask.class;
        }

        @Override
        public void execute(SourceSetsTask sourceSetsTask) {
            sourceSetsTask.setConfig(this.extension);
            sourceSetsTask.setDescription("Prints out all the source sets defined in this project.");
            sourceSetsTask.setGroup("Android");
        }
    }
}

