/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.ide.NativeLibraryImpl;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.NdkLease;
import com.android.builder.model.NativeLibrary;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class NativeLibraryFactoryImpl
implements NativeLibraryFactory {
    final NdkHandler ndkHandler;

    public NativeLibraryFactoryImpl(NdkHandler ndkHandler) {
        this.ndkHandler = ndkHandler;
    }

    @Override
    public Optional<NativeLibrary> create(VariantScope scope, String toolchainName, Abi abi) {
        BaseVariantData variantData = scope.getVariantData();
        if (NdkLease.isDeprecatedNdkCompileLeaseExpired(scope.getGlobalScope().getProjectOptions())) {
            return Optional.empty();
        }
        CoreNdkOptions ndkConfig = variantData.getVariantConfiguration().getNdkConfig();
        String sysrootFlag = "--sysroot=" + this.ndkHandler.getCompilerSysroot(abi, null);
        ImmutableList cFlags = ndkConfig.getcFlags() == null ? ImmutableList.of((Object)sysrootFlag) : ImmutableList.of((Object)sysrootFlag, (Object)ndkConfig.getcFlags());
        return Optional.of(new NativeLibraryImpl(ndkConfig.getModuleName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.ndkHandler.getStlNativeToolSpecification(Stl.getById(ndkConfig.getStl()), null, abi).getIncludes(), Collections.emptyList(), Collections.emptyList(), (List<String>)cFlags, (List<String>)cFlags, (List<File>)ImmutableList.of((Object)scope.getNdkDebuggableLibraryFolders(abi))));
    }
}

