/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.api.SourceKind;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.api.ImmutableFlavorList;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MutableTaskContainer;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantImpl
implements BaseVariant {
    private final ObjectFactory objectFactory;
    protected final AndroidBuilder androidBuilder;
    protected final ReadOnlyObjectProvider readOnlyObjectProvider;
    protected final NamedDomainObjectContainer<BaseVariantOutput> outputs;

    BaseVariantImpl(ObjectFactory objectFactory, AndroidBuilder androidBuilder, ReadOnlyObjectProvider readOnlyObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        this.objectFactory = objectFactory;
        this.androidBuilder = androidBuilder;
        this.readOnlyObjectProvider = readOnlyObjectProvider;
        this.outputs = outputs;
    }

    protected abstract BaseVariantData getVariantData();

    public void addOutputs(List<BaseVariantOutput> outputs) {
        this.outputs.addAll(outputs);
    }

    @Override
    public String getName() {
        return this.getVariantData().getVariantConfiguration().getFullName();
    }

    @Override
    public String getDescription() {
        return this.getVariantData().getDescription();
    }

    @Override
    public String getDirName() {
        return this.getVariantData().getVariantConfiguration().getDirName();
    }

    @Override
    public String getBaseName() {
        return this.getVariantData().getVariantConfiguration().getBaseName();
    }

    @Override
    public String getFlavorName() {
        return this.getVariantData().getVariantConfiguration().getFlavorName();
    }

    @Override
    public DomainObjectCollection<BaseVariantOutput> getOutputs() {
        return this.outputs;
    }

    @Override
    public BuildType getBuildType() {
        return this.readOnlyObjectProvider.getBuildType((BuildType)this.getVariantData().getVariantConfiguration().getBuildType());
    }

    @Override
    public List<ProductFlavor> getProductFlavors() {
        return new ImmutableFlavorList(this.getVariantData().getVariantConfiguration().getProductFlavors(), this.readOnlyObjectProvider);
    }

    @Override
    public ProductFlavor getMergedFlavor() {
        return this.getVariantData().getVariantConfiguration().getMergedFlavor();
    }

    @Override
    public JavaCompileOptions getJavaCompileOptions() {
        return this.getVariantData().getVariantConfiguration().getJavaCompileOptions();
    }

    @Override
    public List<SourceProvider> getSourceSets() {
        return this.getVariantData().getVariantConfiguration().getSortedSourceProviders();
    }

    @Override
    public List<ConfigurableFileTree> getSourceFolders(SourceKind folderType) {
        switch (folderType) {
            case JAVA: {
                return this.getVariantData().getJavaSources();
            }
        }
        this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Unknown SourceKind value: " + (Object)((Object)folderType)));
        return ImmutableList.of();
    }

    @Override
    public Configuration getCompileConfiguration() {
        return this.getVariantData().getVariantDependency().getCompileClasspath();
    }

    @Override
    public Configuration getRuntimeConfiguration() {
        return this.getVariantData().getVariantDependency().getRuntimeClasspath();
    }

    @Override
    public Configuration getAnnotationProcessorConfiguration() {
        return this.getVariantData().getVariantDependency().getAnnotationProcessorConfiguration();
    }

    @Override
    public String getApplicationId() {
        return this.getVariantData().getApplicationId();
    }

    @Override
    public TextResource getApplicationIdTextResource() {
        return this.getVariantData().applicationIdTextResource;
    }

    @Override
    public Task getPreBuild() {
        return this.getVariantData().getTaskContainer().getPreBuildTask();
    }

    @Override
    public Task getCheckManifest() {
        return this.getVariantData().getTaskContainer().getCheckManifestTask();
    }

    @Override
    public AidlCompile getAidlCompile() {
        return this.getVariantData().getTaskContainer().getAidlCompileTask();
    }

    @Override
    public RenderscriptCompile getRenderscriptCompile() {
        return this.getVariantData().getTaskContainer().getRenderscriptCompileTask();
    }

    @Override
    public MergeResources getMergeResources() {
        return this.getVariantData().getTaskContainer().getMergeResourcesTask();
    }

    @Override
    public MergeSourceSetFolders getMergeAssets() {
        return this.getVariantData().getTaskContainer().getMergeAssetsTask();
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfig() {
        return this.getVariantData().getTaskContainer().getGenerateBuildConfigTask();
    }

    @Override
    public JavaCompile getJavaCompile() {
        return this.getVariantData().getTaskContainer().getJavacTask();
    }

    @Override
    public Task getJavaCompiler() {
        return this.getVariantData().getTaskContainer().getJavacTask();
    }

    @Override
    public NdkCompile getNdkCompile() {
        return this.getVariantData().getTaskContainer().getNdkCompileTask();
    }

    @Override
    public Collection<ExternalNativeBuildTask> getExternalNativeBuildTasks() {
        return this.getVariantData().getTaskContainer().getExternalNativeBuildTasks();
    }

    @Override
    public Task getObfuscation() {
        return this.getVariantData().getTaskContainer().getObfuscationTask();
    }

    @Override
    public File getMappingFile() {
        BuildArtifactsHolder artifacts = this.getVariantData().getScope().getArtifacts();
        if (artifacts.hasArtifact(InternalArtifactType.APK_MAPPING)) {
            return (File)Iterables.getOnlyElement((Iterable)((Iterable)artifacts.getFinalArtifactFiles(InternalArtifactType.APK_MAPPING).get()));
        }
        return null;
    }

    public Sync getProcessJavaResources() {
        return this.getVariantData().getTaskContainer().getProcessJavaResourcesTask();
    }

    @Override
    public Task getAssemble() {
        return this.getVariantData().getTaskContainer().getAssembleTask();
    }

    @Override
    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        this.getVariantData().addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, File ... sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerJavaGeneratingTask(Task task, Collection<File> sourceFolders) {
        this.getVariantData().registerJavaGeneratingTask(task, sourceFolders);
    }

    @Override
    public void registerExternalAptJavaOutput(ConfigurableFileTree folder) {
        this.getVariantData().registerExternalAptJavaOutput(folder);
    }

    @Override
    public void registerGeneratedResFolders(FileCollection folders) {
        this.getVariantData().registerGeneratedResFolders(folders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    @Deprecated
    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        this.getVariantData().registerResGeneratingTask(task, generatedResFolders);
    }

    @Override
    public Object registerPreJavacGeneratedBytecode(FileCollection fileCollection) {
        return this.getVariantData().registerPreJavacGeneratedBytecode(fileCollection);
    }

    @Override
    @Deprecated
    public Object registerGeneratedBytecode(FileCollection fileCollection) {
        return this.registerPreJavacGeneratedBytecode(fileCollection);
    }

    @Override
    public void registerPostJavacGeneratedBytecode(FileCollection fileCollection) {
        this.getVariantData().registerPostJavacGeneratedBytecode(fileCollection);
    }

    @Override
    public FileCollection getCompileClasspath(Object generatorKey) {
        return this.getVariantData().getScope().getJavaClasspath(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, generatorKey);
    }

    @Override
    public ArtifactCollection getCompileClasspathArtifacts(Object generatorKey) {
        return this.getVariantData().getScope().getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactType.CLASSES, generatorKey);
    }

    @Override
    public void buildConfigField(String type, String name, String value) {
        this.getVariantData().getVariantConfiguration().addBuildConfigField(type, name, value);
    }

    @Override
    public void resValue(String type, String name, String value) {
        this.getVariantData().getVariantConfiguration().addResValue(type, name, value);
    }

    @Override
    public void missingDimensionStrategy(String dimension, String requestedValue) {
        this._missingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.of((Object)requestedValue));
    }

    @Override
    public void missingDimensionStrategy(String dimension, String ... requestedValues) {
        this._missingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.copyOf((Object[])requestedValues));
    }

    @Override
    public void missingDimensionStrategy(String dimension, List<String> requestedValues) {
        this._missingDimensionStrategy(dimension, (ImmutableList<String>)ImmutableList.copyOf(requestedValues));
    }

    private void _missingDimensionStrategy(String dimension, ImmutableList<String> alternatedValues) {
        VariantScope variantScope = this.getVariantData().getScope();
        String requestedValue = VariantManager.getModifiedName(this.getName());
        Attribute attributeKey = Attribute.of((String)dimension, ProductFlavorAttr.class);
        ProductFlavorAttr attributeValue = (ProductFlavorAttr)this.objectFactory.named(ProductFlavorAttr.class, requestedValue);
        VariantDependencies dependencies = variantScope.getVariantDependencies();
        dependencies.getCompileClasspath().getAttributes().attribute(attributeKey, (Object)attributeValue);
        dependencies.getRuntimeClasspath().getAttributes().attribute(attributeKey, (Object)attributeValue);
        dependencies.getAnnotationProcessorConfiguration().getAttributes().attribute(attributeKey, (Object)attributeValue);
        AttributesSchema schema = variantScope.getGlobalScope().getProject().getDependencies().getAttributesSchema();
        VariantManager.addFlavorStrategy(schema, dimension, (Map<String, List<String>>)ImmutableMap.of((Object)requestedValue, alternatedValues));
    }

    @Override
    public void setOutputsAreSigned(boolean isSigned) {
        this.getVariantData().outputsAreSigned = isSigned;
    }

    @Override
    public boolean getOutputsAreSigned() {
        return this.getVariantData().outputsAreSigned;
    }

    @Override
    public FileCollection getAllRawAndroidResources() {
        return this.getVariantData().getAllRawAndroidResources();
    }

    @Override
    public void register(Task task) {
        Zip bundleTaskLibrary;
        MutableTaskContainer taskContainer = this.getVariantData().getScope().getTaskContainer();
        taskContainer.getAssembleTask().dependsOn(new Object[]{task});
        Task bundleTask = taskContainer.getBundleTask();
        if (bundleTask != null) {
            bundleTask.dependsOn(new Object[]{task});
        }
        if ((bundleTaskLibrary = taskContainer.getBundleLibraryTask()) != null) {
            bundleTaskLibrary.dependsOn(new Object[]{task});
        }
    }
}

