/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.structureplugin;

import com.android.build.gradle.internal.tasks.structureplugin.DataCollector;
import com.android.build.gradle.internal.tasks.structureplugin.DependencyType;
import com.android.build.gradle.internal.tasks.structureplugin.GatherModuleInfoTask;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleInfo;
import com.android.build.gradle.internal.tasks.structureplugin.PoetDependenciesInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014*\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/structureplugin/DependencyCollector;", "Lcom/android/build/gradle/internal/tasks/structureplugin/DataCollector;", "()V", "relevantConfigurations", "", "", "getRelevantConfigurations", "()Ljava/util/Set;", "collectInto", "", "dataHolder", "Lcom/android/build/gradle/internal/tasks/structureplugin/ModuleInfo;", "task", "Lcom/android/build/gradle/internal/tasks/structureplugin/GatherModuleInfoTask;", "gatherDependencies", "", "Lcom/android/build/gradle/internal/tasks/structureplugin/PoetDependenciesInfo;", "config", "Lorg/gradle/api/artifacts/Configuration;", "cleanDependencies", "", "project", "Lorg/gradle/api/Project;", "gradle"})
final class DependencyCollector
implements DataCollector {
    @NotNull
    private final Set<String> relevantConfigurations = SetsKt.setOf((Object[])new String[]{"api", "implementation", "classpath", "compile", "compileOnly", "runtime", "runtimeOnly", "testImplementation", "testCompile", "androidTestImplementation", "androidTestCompile", "annotationProcessor", "kapt", "package", "provided", "wearApp"});

    @NotNull
    public final Set<String> getRelevantConfigurations() {
        return this.relevantConfigurations;
    }

    @Override
    public void collectInto(@NotNull ModuleInfo dataHolder, @NotNull GatherModuleInfoTask task) {
        Configuration it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)dataHolder, (String)"dataHolder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Project project = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"task.project.configurations");
        Iterable iterable2 = (Iterable)configurationContainer;
        DependencyCollector dependencyCollector = this;
        iterable2 = iterable = iterable2;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Configuration configuration = it = (Configuration)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"it");
            if (!this.relevantConfigurations.contains(configuration.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv$iv = $receiver$iv = (iterable = (List)destination$iv$iv);
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Configuration configuration = it = (Configuration)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"it");
            Iterable list$iv$iv = this.gatherDependencies(configuration);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        iterable = iterable2 = (iterable = (List)destination$iv$iv);
        Project project2 = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"task.project");
        Iterable<PoetDependenciesInfo> projectDependencies = dependencyCollector.cleanDependencies(iterable, project2);
        CollectionsKt.addAll((Collection)dataHolder.getDependencies(), projectDependencies);
    }

    private final List<PoetDependenciesInfo> gatherDependencies(Configuration config2) {
        List deps = new ArrayList();
        for (Dependency dependency : config2.getAllDependencies()) {
            PoetDependenciesInfo poetDependenciesInfo;
            Object object = dependency;
            if (object instanceof ProjectDependency) {
                String string = config2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.name");
                Project project = ((ProjectDependency)dependency).getDependencyProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"dependency.dependencyProject");
                String string2 = project.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dependency.dependencyProject.path");
                poetDependenciesInfo = new PoetDependenciesInfo(DependencyType.MODULE, string, StringsKt.replace$default((String)StringsKt.drop((String)string2, (int)1), (char)':', (char)'_', (boolean)false, (int)4, null));
            } else if (object instanceof ModuleDependency) {
                String string = config2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"config.name");
                poetDependenciesInfo = new PoetDependenciesInfo(DependencyType.EXTERNAL_LIBRARY, string, "" + ((ModuleDependency)dependency).getGroup() + ':' + ((ModuleDependency)dependency).getName() + ':' + ((ModuleDependency)dependency).getVersion());
            } else {
                poetDependenciesInfo = null;
            }
            if (poetDependenciesInfo == null) continue;
            Object it = object = poetDependenciesInfo;
            deps.add(it);
        }
        return deps;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<PoetDependenciesInfo> cleanDependencies(@NotNull Iterable<PoetDependenciesInfo> $receiver, Project project) {
        Iterable filteredDependencies = $receiver;
        if (project.getPlugins().hasPlugin("java-library") && project.getPlugins().hasPlugin("kotlin")) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = filteredDependencies;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                PoetDependenciesInfo it = (PoetDependenciesInfo)element$iv$iv;
                if (!(!StringsKt.startsWith$default((String)it.getDependency(), (String)"org.jetbrains.kotlin:kotlin-stdlib-jdk", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)it.getScope(), (Object)"compile"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            filteredDependencies = (List)destination$iv$iv;
        }
        return filteredDependencies;
    }
}

