/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.ide.common.repository.GradleVersion;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"CRASHLYTICS_PLUGIN_DEPENDENCY_GROUP_AND_NAME", "", "CRASHLYTICS_PLUGIN_MINIMUM_VERSION", "CRASHLYTICS_PLUGIN_NAME", "INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS", "KOTLIN_PLUGIN_DEPENDENCY_GROUP_AND_NAME", "KOTLIN_PLUGIN_MINIMUM_VERSION", "KOTLIN_PLUGIN_NAME", "PROTOBUF_PLUGIN_DEPENDENCY_GROUP_AND_NAME", "PROTOBUF_PLUGIN_MINIMUM_VERSION", "PROTOBUF_PLUGIN_NAME", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "pluginName", "dependencyGroupAndName", "minimumVersion", "enforceMinimumVersionsOfPlugins", "gradle"})
@JvmName(name="GradlePluginUtils")
public final class GradlePluginUtils {
    private static final String INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS = "INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS";
    private static final String CRASHLYTICS_PLUGIN_NAME = "Crashlytics";
    private static final String CRASHLYTICS_PLUGIN_DEPENDENCY_GROUP_AND_NAME = "io.fabric.tools:gradle";
    private static final String CRASHLYTICS_PLUGIN_MINIMUM_VERSION = "1.25.4";
    private static final String PROTOBUF_PLUGIN_NAME = "Protobuf";
    private static final String PROTOBUF_PLUGIN_DEPENDENCY_GROUP_AND_NAME = "com.google.protobuf:protobuf-gradle-plugin";
    private static final String PROTOBUF_PLUGIN_MINIMUM_VERSION = "0.8.6";
    private static final String KOTLIN_PLUGIN_NAME = "Kotlin";
    private static final String KOTLIN_PLUGIN_DEPENDENCY_GROUP_AND_NAME = "org.jetbrains.kotlin:kotlin-gradle-plugin";
    private static final String KOTLIN_PLUGIN_MINIMUM_VERSION = "1.2.50";

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project, @NotNull EvalIssueReporter issueReporter) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.rootProject.extensions");
        boolean alreadyChecked = extensionContainer.getExtraProperties().has(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS);
        if (alreadyChecked) {
            return;
        }
        Project project3 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project.rootProject");
        ExtensionContainer extensionContainer2 = project3.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer2, (String)"project.rootProject.extensions");
        extensionContainer2.getExtraProperties().set(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS, (Object)true);
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(issueReporter){
            final /* synthetic */ EvalIssueReporter $issueReporter;

            public final void execute(Gradle gradle) {
                gradle.allprojects((Action)new Action<Project>(this){
                    final /* synthetic */ enforceMinimumVersionsOfPlugins.1 this$0;

                    public final void execute(Project it) {
                        Project project = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                        GradlePluginUtils.access$enforceMinimumVersionOfPlugin(project, this.this$0.$issueReporter, "Crashlytics", "io.fabric.tools:gradle", "1.25.4");
                        GradlePluginUtils.access$enforceMinimumVersionOfPlugin(it, this.this$0.$issueReporter, "Protobuf", "com.google.protobuf:protobuf-gradle-plugin", "0.8.6");
                        GradlePluginUtils.access$enforceMinimumVersionOfPlugin(it, this.this$0.$issueReporter, "Kotlin", "org.jetbrains.kotlin:kotlin-gradle-plugin", "1.2.50");
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$issueReporter = evalIssueReporter;
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project, EvalIssueReporter issueReporter, String pluginName, String dependencyGroupAndName, String minimumVersion) {
        ScriptHandler scriptHandler = project.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
        Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026(CLASSPATH_CONFIGURATION)");
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"project.buildscript.conf\u2026   .resolvedConfiguration");
        Iterator iterator = resolvedConfiguration.getResolvedArtifacts().iterator();
        while (iterator.hasNext()) {
            GradleVersion currentVersion;
            ResolvedArtifact artifact;
            ResolvedArtifact resolvedArtifact = artifact = (ResolvedArtifact)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"artifact");
            ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedModuleVersion, (String)"artifact.moduleVersion");
            ModuleVersionIdentifier artifactId = resolvedModuleVersion.getId();
            StringBuilder stringBuilder = new StringBuilder().append("");
            ModuleVersionIdentifier moduleVersionIdentifier = artifactId;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionIdentifier, (String)"artifactId");
            if (Intrinsics.areEqual((Object)stringBuilder.append(moduleVersionIdentifier.getGroup()).append(':').append(artifactId.getName()).toString(), (Object)dependencyGroupAndName) ^ true) continue;
            if (GradleVersion.tryParse((String)artifactId.getVersion()) == null) {
                continue;
            }
            if (currentVersion.compareTo(minimumVersion) >= 0) continue;
            String string = "The Android Gradle plugin supports only " + pluginName + " Gradle plugin" + " version " + minimumVersion + " and higher." + " Project '" + project.getName() + "' is using version " + currentVersion + '.';
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
            issueReporter.reportError(EvalIssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, new EvalIssueException(string, file.getPath(), null));
        }
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(@NotNull Project project, @NotNull EvalIssueReporter issueReporter, @NotNull String pluginName, @NotNull String dependencyGroupAndName, @NotNull String minimumVersion) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project, issueReporter, pluginName, dependencyGroupAndName, minimumVersion);
    }
}

