/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.ir;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.utils.XmlUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GenerateInstantRunAppInfoTask
extends AndroidBuilderTask {
    private static final String SERVER_PACKAGE = "com/android/tools/ir/server";
    private File outputFile;
    private BuildableArtifact mergedManifests;
    private InstantRunBuildContext buildContext;

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @InputFiles
    public BuildableArtifact getMergedManifests() {
        return this.mergedManifests;
    }

    void setMergedManifests(BuildableArtifact mergedManifests) {
        this.mergedManifests = mergedManifests;
    }

    void setBuildContext(InstantRunBuildContext buildContext) {
        this.buildContext = buildContext;
    }

    @Input
    public long getSecretToken() {
        return this.buildContext.getSecretToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public void generateInfoTask() throws IOException {
        BuildElements buildElements = ExistingBuildElements.from((ArtifactType)InternalArtifactType.INSTANT_RUN_MERGED_MANIFESTS, this.getMergedManifests());
        if (buildElements.isEmpty()) {
            throw new RuntimeException("Cannot find the package-id from the merged manifest, please file a bug, a clean build should fix the issue.");
        }
        BuildOutput buildOutput = buildElements.iterator().next();
        File manifestFile = buildOutput.getOutputFile();
        if (!manifestFile.exists()) throw new FileNotFoundException("Cannot find " + manifestFile.getAbsolutePath());
        try {
            String applicationId;
            Document document = XmlUtils.parseUtfXmlFile((File)manifestFile, (boolean)true);
            Element root = document.getDocumentElement();
            if (root == null || (applicationId = root.getAttribute("package")).isEmpty()) return;
            this.writeAppInfoClass(applicationId, this.getSecretToken());
            return;
        }
        catch (IOException | SAXException e) {
            throw new BuildException("Failed to inject bootstrapping application", (Throwable)e);
        }
    }

    void writeAppInfoClass(String applicationId, long token) throws IOException {
        ClassWriter cw = new ClassWriter(0);
        String appInfoOwner = "com/android/tools/ir/server/AppInfo";
        cw.visit(50, 33, appInfoOwner, null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(9, "applicationId", "Ljava/lang/String;", null, null);
        fv.visitEnd();
        fv = cw.visitField(9, "token", "J", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + appInfoOwner + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)applicationId);
        mv.visitFieldInsn(179, appInfoOwner, "applicationId", "Ljava/lang/String;");
        if (token != 0L) {
            mv.visitLdcInsn((Object)token);
        } else {
            mv.visitInsn(9);
        }
        mv.visitFieldInsn(179, appInfoOwner, "token", "J");
        mv.visitInsn(177);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        try (JarOutputStream outputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutputFile())));){
            outputStream.putNextEntry(new ZipEntry("com/android/tools/ir/server/AppInfo.class"));
            outputStream.write(bytes);
            outputStream.closeEntry();
        }
    }

    public static class ConfigAction
    extends TaskConfigAction<GenerateInstantRunAppInfoTask> {
        private final VariantScope variantScope;
        private final TransformVariantScope transformVariantScope;
        private final BuildableArtifact manifests;

        public ConfigAction(TransformVariantScope transformVariantScope, VariantScope variantScope, BuildableArtifact manifests) {
            this.transformVariantScope = transformVariantScope;
            this.variantScope = variantScope;
            this.manifests = manifests;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName("generate", "InstantRunAppInfo");
        }

        @Override
        public Class<GenerateInstantRunAppInfoTask> getType() {
            return GenerateInstantRunAppInfoTask.class;
        }

        @Override
        public void execute(GenerateInstantRunAppInfoTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.buildContext = this.variantScope.getInstantRunBuildContext();
            task.outputFile = this.variantScope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.INSTANT_RUN_APP_INFO_OUTPUT_FILE, (Task)task, "instant-run-bootstrap.jar");
            task.mergedManifests = this.manifests;
        }
    }
}

