/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.transforms.TransformInputUtil;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProGuardRulesExtractor {
    private static Predicate<ZipEntry> isRule = e -> {
        String name = e.getName().toLowerCase();
        return !e.isDirectory() && (name.startsWith("meta-inf/proguard/") || name.startsWith("/meta-inf/proguard/"));
    };

    public static ImmutableMap<String, ImmutableMap<String, String>> extractRulesTexts(Collection<TransformInput> inputs) {
        return (ImmutableMap)TransformInputUtil.getAllFiles(inputs, false, true).stream().distinct().collect(ImmutableMap.toImmutableMap(File::getPath, f -> ProGuardRulesExtractor.extractRulesTexts(f)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static ImmutableMap<String, String> extractRulesTexts(File file) {
        try (ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);){
            ImmutableMap immutableMap = (ImmutableMap)zipFile.stream().filter(isRule).collect(ImmutableMap.toImmutableMap(ZipEntry::getName, e -> ProGuardRulesExtractor.extractRuleFileText(zipFile, e)));
            return immutableMap;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Error while reading '" + file.getName() + "'", ioe);
        }
    }

    private static String extractRuleFileText(ZipFile zipFile, ZipEntry entry) {
        try {
            return CharStreams.toString((Readable)new InputStreamReader(zipFile.getInputStream(entry), Charsets.UTF_8));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

