/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ClasspathComparisionTask;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.ide.common.repository.GradleVersion;
import com.android.utils.FileUtils;
import java.io.File;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class AppClasspathCheckTask
extends ClasspathComparisionTask {
    private EvalIssueReporter reporter;

    @Override
    void onDifferentVersionsFound(String group, String module, String runtimeVersion, String compileVersion) {
        String suggestedVersion;
        try {
            GradleVersion runtime = GradleVersion.parse((String)runtimeVersion);
            GradleVersion compile2 = GradleVersion.parse((String)compileVersion);
            suggestedVersion = runtime.compareTo(compile2) > 0 ? runtimeVersion : compileVersion;
        }
        catch (Throwable e) {
            suggestedVersion = runtimeVersion;
        }
        String message = String.format("Conflict with dependency '%1$s:%2$s' in project '%3$s'. Resolved versions for runtime classpath (%4$s) and compile classpath (%5$s) differ. This can lead to runtime crashes. To resolve this issue follow advice at https://developer.android.com/studio/build/gradle-tips#configure-project-wide-properties. Alternatively, you can try to fix the problem by adding this snippet to %6$s:\ndependencies {\n    implementation(\"%1$s:%2$s:%7$s\")\n}\n", group, module, this.getProject().getPath(), runtimeVersion, compileVersion, this.getProject().getBuildFile(), suggestedVersion);
        this.reporter.reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(message));
    }

    @TaskAction
    void run() {
        this.compareClasspaths();
    }

    public static class CreationAction
    extends LazyTaskCreationAction<AppClasspathCheckTask> {
        private final VariantScope variantScope;

        public CreationAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("check", "Classpath");
        }

        @Override
        public Class<AppClasspathCheckTask> getType() {
            return AppClasspathCheckTask.class;
        }

        @Override
        public void configure(AppClasspathCheckTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.runtimeClasspath = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.compileClasspath = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.CLASSES);
            task.fakeOutputDirectory = FileUtils.join((File)this.variantScope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{this.getName(), this.variantScope.getVariantConfiguration().getDirName()});
            task.reporter = this.variantScope.getGlobalScope().getErrorHandler();
        }
    }
}

