/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InstantAppOutputScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.testing.ConnectedDevice;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.IDevice;
import com.android.instantapp.run.InstantAppRunException;
import com.android.instantapp.run.InstantAppSideLoader;
import com.android.instantapp.run.RunListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class InstantAppSideLoadTask
extends AndroidBuilderTask {
    private Supplier<File> adbExe;
    private BuildableArtifact bundleDir;

    public InstantAppSideLoadTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Side load task is always run.");
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void sideLoad() throws DeviceException, InstantAppRunException, IOException {
        if (this.adbExe.get() == null) {
            throw new GradleException("No adb file found.");
        }
        InstantAppOutputScope outputScope = InstantAppOutputScope.load(BuildableArtifactUtil.singleFile(this.bundleDir));
        if (outputScope == null) {
            throw new GradleException("Instant app outputs not found in " + BuildableArtifactUtil.singleFile(this.bundleDir).getAbsolutePath() + ".");
        }
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider(this.adbExe.get(), 0, this.getILogger());
        RunListener runListener = new RunListener(){

            public void printMessage(String message) {
                InstantAppSideLoadTask.this.getLogger().info(message);
            }

            public void logMessage(String message, InstantAppRunException e) {
                if (e == null) {
                    InstantAppSideLoadTask.this.getLogger().debug(message);
                } else {
                    InstantAppSideLoadTask.this.getLogger().debug(message, (Throwable)e);
                    InstantAppSideLoadTask.this.getLogger().error(message, (Throwable)e);
                }
            }

            public void setProgress(double fraction) {
            }

            public boolean isCancelled() {
                return false;
            }
        };
        String appId = outputScope.getApplicationId();
        File bundleFile = outputScope.getInstantAppBundle();
        deviceProvider.init();
        try {
            List devices = deviceProvider.getDevices();
            for (DeviceConnector device : devices) {
                InstantAppSideLoader sideLoader;
                if (!(device instanceof ConnectedDevice)) continue;
                IDevice iDevice = ((ConnectedDevice)device).getIDevice();
                if (iDevice.getVersion().isGreaterOrEqualThan(26)) {
                    ArrayList<File> apks = new ArrayList<File>();
                    for (File apkDirectory : outputScope.getApkDirectories()) {
                        for (BuildOutput buildOutput : ExistingBuildElements.from((ArtifactType)InternalArtifactType.APK, apkDirectory)) {
                            apks.add(buildOutput.getOutputFile());
                        }
                    }
                    sideLoader = new InstantAppSideLoader(appId, apks, runListener);
                } else {
                    sideLoader = new InstantAppSideLoader(appId, bundleFile, runListener);
                }
                sideLoader.install(iDevice);
            }
        }
        finally {
            deviceProvider.terminate();
        }
    }

    @InputFile
    public File getAdbExe() {
        return this.adbExe.get();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public BuildableArtifact getBundleDir() {
        return this.bundleDir;
    }

    public static class CreationAction
    extends LazyTaskCreationAction<InstantAppSideLoadTask> {
        private final VariantScope scope;

        public CreationAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("sideLoad", "InstantApp");
        }

        @Override
        public Class<InstantAppSideLoadTask> getType() {
            return InstantAppSideLoadTask.class;
        }

        @Override
        public void configure(InstantAppSideLoadTask task) {
            task.setDescription("Side loads the " + this.scope.getVariantData().getDescription() + ".");
            task.setVariantName(this.scope.getFullVariantName());
            task.setGroup("Install");
            task.adbExe = TaskInputHelper.memoize(() -> {
                SdkInfo info = this.scope.getGlobalScope().getSdkHandler().getSdkInfo();
                return info == null ? null : info.getAdb();
            });
            task.bundleDir = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.INSTANTAPP_BUNDLE);
        }
    }
}

