/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.structureplugin;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.tasks.structureplugin.DataCollector;
import com.android.build.gradle.internal.tasks.structureplugin.GatherModuleInfoTask;
import com.android.build.gradle.internal.tasks.structureplugin.GatherModuleInfoTaskKt;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginCollection;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\fH\u0002J \u0010\r\u001a\u00020\u0004*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/structureplugin/SourceFilesCollector;", "Lcom/android/build/gradle/internal/tasks/structureplugin/DataCollector;", "()V", "collectInto", "", "dataHolder", "Lcom/android/build/gradle/internal/tasks/structureplugin/ModuleInfo;", "task", "Lcom/android/build/gradle/internal/tasks/structureplugin/GatherModuleInfoTask;", "findMainSourceSet", "", "Ljava/io/File;", "Lorg/gradle/api/Project;", "increment", "", "", "", "key", "gradle"})
final class SourceFilesCollector
implements DataCollector {
    /*
     * WARNING - void declaration
     */
    @Override
    public void collectInto(@NotNull ModuleInfo dataHolder, @NotNull GatherModuleInfoTask task) {
        Intrinsics.checkParameterIsNotNull((Object)dataHolder, (String)"dataHolder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Map javaPackageMap = new LinkedHashMap();
        Map kotlinPackageMap = new LinkedHashMap();
        Project project = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
        Iterable $receiver$iv = this.findMainSourceSet(project);
        for (Object element$iv : $receiver$iv) {
            void $receiver$iv$iv;
            File it = (File)element$iv;
            Iterable $receiver$iv2 = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkBottomUp((File)it)));
            Iterable iterable = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                File it2 = (File)element$iv$iv;
                if (!(!it2.isDirectory())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv;
            for (Object element$iv2 : $receiver$iv2) {
                File it3 = (File)element$iv2;
                String dirPackage = it3.getParent();
                switch (FilesKt.getExtension((File)it3)) {
                    case "java": {
                        String string = dirPackage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dirPackage");
                        this.increment(javaPackageMap, string);
                        break;
                    }
                    case "kt": {
                        String string = dirPackage;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dirPackage");
                        this.increment(kotlinPackageMap, string);
                    }
                }
            }
        }
        dataHolder.getJavaSourceInfo().setPackages(javaPackageMap.size());
        Map map = javaPackageMap;
        if (!map.isEmpty()) {
            Integer n = (Integer)CollectionsKt.max((Iterable)javaPackageMap.values());
            dataHolder.getJavaSourceInfo().setClassesPerPackage(n != null ? n : 0);
            dataHolder.getJavaSourceInfo().setMethodsPerClass(10);
            dataHolder.getJavaSourceInfo().setFieldsPerClass(10);
        }
        dataHolder.getKotlinSourceInfo().setPackages(kotlinPackageMap.size());
        map = kotlinPackageMap;
        if (!map.isEmpty()) {
            Integer n = (Integer)CollectionsKt.max((Iterable)kotlinPackageMap.values());
            dataHolder.getKotlinSourceInfo().setClassesPerPackage(n != null ? n : 0);
            dataHolder.getKotlinSourceInfo().setMethodsPerClass(10);
            dataHolder.getKotlinSourceInfo().setFieldsPerClass(10);
        }
    }

    private final Set<File> findMainSourceSet(@NotNull Project $receiver) {
        JavaPluginConvention javaPlugin;
        if (GatherModuleInfoTaskKt.access$isAndroidProject($receiver)) {
            BasePlugin androidPlugin;
            PluginCollection pluginCollection = $receiver.getPlugins().withType(BasePlugin.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)pluginCollection, (String)"plugins.withType(BasePlugin::class.java)");
            BasePlugin basePlugin = androidPlugin = (BasePlugin)CollectionsKt.first((Iterable)((Iterable)pluginCollection));
            Intrinsics.checkExpressionValueIsNotNull((Object)basePlugin, (String)"androidPlugin");
            BaseExtension baseExtension = basePlugin.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension, (String)"androidPlugin.extension");
            Object object = (AndroidSourceSet)baseExtension.getSourceSets().findByName("main");
            if (object == null || (object = object.getJava()) == null || (object = object.getSrcDirs()) == null) {
                object = SetsKt.emptySet();
            }
            return object;
        }
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)$receiver.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention == null) {
            return SetsKt.emptySet();
        }
        JavaPluginConvention javaPluginConvention2 = javaPlugin = javaPluginConvention;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention2, (String)"javaPlugin");
        Object object = (SourceSet)javaPluginConvention2.getSourceSets().findByName("main");
        if (object == null || (object = object.getAllSource()) == null || (object = object.getSrcDirs()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final void increment(@NotNull Map<String, Integer> $receiver, String key) {
        Map<String, Integer> map = $receiver;
        Integer n = $receiver.get(key);
        Integer n2 = (n != null ? n : 0) + 1;
        map.put(key, n2);
    }
}

