/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import java.io.File;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public class CheckManifest
extends AndroidVariantTask {
    private File manifest;
    private Boolean isOptional;
    private File fakeOutputDir;

    @Optional
    @Input
    public File getManifest() {
        return this.manifest;
    }

    @Input
    public boolean getManifestPresence() {
        return this.manifest != null && this.manifest.isFile();
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    @Input
    public Boolean getOptional() {
        return this.isOptional;
    }

    public void setOptional(Boolean optional) {
        this.isOptional = optional;
    }

    @OutputDirectory
    public File getFakeOutputDir() {
        return this.fakeOutputDir;
    }

    @TaskAction
    void check() {
        if (!this.isOptional.booleanValue() && this.manifest != null && !this.manifest.isFile()) {
            throw new IllegalArgumentException(String.format("Main Manifest missing for variant %1$s. Expected path: %2$s", this.getVariantName(), this.getManifest().getAbsolutePath()));
        }
    }

    public static class CreationAction
    extends LazyTaskCreationAction<CheckManifest> {
        private final VariantScope scope;
        private final boolean isManifestOptional;
        private File output;

        public CreationAction(VariantScope scope, boolean isManifestOptional) {
            this.scope = scope;
            this.isManifestOptional = isManifestOptional;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("check", "Manifest");
        }

        @Override
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends CheckManifest> taskProvider) {
            super.handleProvider(taskProvider);
            this.scope.getTaskContainer().setCheckManifestTask(taskProvider);
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.output = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.CHECK_MANIFEST_RESULT, taskName, "out");
        }

        @Override
        public void configure(CheckManifest task) {
            task.setVariantName(this.scope.getVariantData().getVariantConfiguration().getFullName());
            task.setOptional(this.isManifestOptional);
            task.manifest = this.scope.getVariantData().getVariantConfiguration().getMainManifest();
            task.fakeOutputDir = this.output;
            task.dependsOn(new Object[]{this.scope.getTaskContainer().getPreBuildTask()});
        }
    }
}

