/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.JacocoTaskDelegate;
import com.android.build.gradle.internal.tasks.factory.EagerTaskCreationAction;
import com.android.builder.dexing.DexerTool;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class JacocoTask
extends AndroidVariantTask {
    private final WorkerExecutor executor;
    private FileCollection jacocoAntTaskConfiguration;
    private BuildableArtifact inputClasses;
    private File output;
    private JacocoTaskDelegate delegate;

    @Inject
    public JacocoTask(WorkerExecutor executor) {
        this.executor = executor;
    }

    @InputFiles
    public FileCollection getJacocoAntTaskConfiguration() {
        return this.jacocoAntTaskConfiguration;
    }

    @InputFiles
    public BuildableArtifact getInputClasses() {
        return this.inputClasses;
    }

    @OutputDirectory
    public File getOutput() {
        return this.output;
    }

    public static String getJacocoVersion(VariantScope scope) {
        if (scope.getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return scope.getGlobalScope().getExtension().getJacoco().getVersion();
    }

    @TaskAction
    public void run(IncrementalTaskInputs inputs) throws IOException {
        this.delegate.run(this.executor, inputs);
    }

    public static class CreationAction
    extends EagerTaskCreationAction<JacocoTask> {
        private final VariantScope scope;

        public CreationAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("jacoco");
        }

        @Override
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void execute(JacocoTask task) {
            task.inputClasses = this.scope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES);
            task.jacocoAntTaskConfiguration = (FileCollection)JacocoConfigurations.getJacocoAntTaskConfiguration(this.scope.getGlobalScope().getProject(), JacocoTask.getJacocoVersion(this.scope));
            task.output = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES, (Task)task, "out");
            task.delegate = new JacocoTaskDelegate(task.jacocoAntTaskConfiguration, task.output, task.inputClasses);
            task.setVariantName(this.scope.getFullVariantName());
        }
    }
}

