/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.factory.LazyTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

public class DataBindingExportBuildInfoTask
extends DefaultTask {
    @Internal
    private Supplier<LayoutXmlProcessor> xmlProcessor;
    private boolean useAndroidX;
    private File emptyClassOutDir;

    @Input
    public boolean isUseAndroidX() {
        return this.useAndroidX;
    }

    @OutputDirectory
    public File getEmptyClassOutDir() {
        return this.emptyClassOutDir;
    }

    @TaskAction
    public void run() {
        this.xmlProcessor.get().writeEmptyInfoClass(this.useAndroidX);
        Scope.assertNoError();
    }

    public static class CreationAction
    extends LazyTaskCreationAction<DataBindingExportBuildInfoTask> {
        private final VariantScope variantScope;

        public CreationAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends DataBindingExportBuildInfoTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.variantScope.getTaskContainer().setDataBindingExportBuildInfoTask(taskProvider);
        }

        @Override
        public void configure(DataBindingExportBuildInfoTask task) {
            task.xmlProcessor = this.variantScope.getVariantData()::getLayoutXmlProcessor;
            task.useAndroidX = this.variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X);
            task.emptyClassOutDir = this.variantScope.getClassOutputForDataBinding();
        }
    }
}

