/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.GradlePluginUtils;
import com.android.build.gradle.internal.utils.PluginVersionInfo;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.ide.common.repository.GradleVersion;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS", "", "pluginList", "", "Lcom/android/build/gradle/internal/utils/PluginVersionInfo;", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "pluginVersionInfo", "enforceMinimumVersionsOfPlugins", "gradle"})
@JvmName(name="GradlePluginUtils")
public final class GradlePluginUtils {
    private static final String INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS = "INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS";
    private static final List<PluginVersionInfo> pluginList = CollectionsKt.listOf((Object[])new PluginVersionInfo[]{new PluginVersionInfo("Crashlytics", "io.fabric.tools:gradle", "1.25.4"), new PluginVersionInfo("Protobuf", "com.google.protobuf:protobuf-gradle-plugin", "0.8.6"), new PluginVersionInfo("Kotlin", "org.jetbrains.kotlin:kotlin-gradle-plugin", "1.2.51")});

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project, @NotNull EvalIssueReporter issueReporter) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ExtensionContainer extensionContainer = project2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"project.rootProject.extensions");
        boolean alreadyChecked = extensionContainer.getExtraProperties().has(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS);
        if (alreadyChecked) {
            return;
        }
        Project project3 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project.rootProject");
        ExtensionContainer extensionContainer2 = project3.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer2, (String)"project.rootProject.extensions");
        extensionContainer2.getExtraProperties().set(INTERNAL__CHECKED_MINIMUM_PLUGIN_VERSIONS, (Object)true);
        project.getGradle().projectsEvaluated((Action)new Action<Gradle>(issueReporter){
            final /* synthetic */ EvalIssueReporter $issueReporter;

            public final void execute(Gradle gradle) {
                gradle.allprojects((Action)new Action<Project>(this){
                    final /* synthetic */ enforceMinimumVersionsOfPlugins.1 this$0;

                    public final void execute(Project it) {
                        for (PluginVersionInfo plugin : GradlePluginUtils.access$getPluginList$p()) {
                            Project project = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                            GradlePluginUtils.access$enforceMinimumVersionOfPlugin(project, this.this$0.$issueReporter, plugin);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$issueReporter = evalIssueReporter;
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project, EvalIssueReporter issueReporter, PluginVersionInfo pluginVersionInfo) {
        ScriptHandler scriptHandler = project.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
        Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026(CLASSPATH_CONFIGURATION)");
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"project.buildscript.conf\u2026   .resolvedConfiguration");
        Iterator iterator = resolvedConfiguration.getResolvedArtifacts().iterator();
        while (iterator.hasNext()) {
            GradleVersion currentVersion;
            ResolvedArtifact artifact;
            ResolvedArtifact resolvedArtifact = artifact = (ResolvedArtifact)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"artifact");
            ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedModuleVersion, (String)"artifact.moduleVersion");
            ModuleVersionIdentifier artifactId = resolvedModuleVersion.getId();
            StringBuilder stringBuilder = new StringBuilder().append("");
            ModuleVersionIdentifier moduleVersionIdentifier = artifactId;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionIdentifier, (String)"artifactId");
            if (Intrinsics.areEqual((Object)stringBuilder.append(moduleVersionIdentifier.getGroup()).append(':').append(artifactId.getName()).toString(), (Object)pluginVersionInfo.getDependencyGroupAndName()) ^ true) continue;
            if (GradleVersion.tryParse((String)artifactId.getVersion()) == null) {
                continue;
            }
            if (currentVersion.compareTo(pluginVersionInfo.getMinimumVersion()) >= 0) continue;
            String string = "The Android Gradle plugin supports only " + pluginVersionInfo.getPluginName() + " Gradle plugin version " + pluginVersionInfo.getMinimumVersion() + " and higher." + " Project '" + project.getName() + "' is using version " + currentVersion + '.';
            File file = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
            issueReporter.reportError(EvalIssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, new EvalIssueException(string, file.getPath(), null));
        }
    }

    @NotNull
    public static final /* synthetic */ List access$getPluginList$p() {
        return pluginList;
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(@NotNull Project project, @NotNull EvalIssueReporter issueReporter, @NotNull PluginVersionInfo pluginVersionInfo) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project, issueReporter, pluginVersionInfo);
    }
}

