/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.api.attributes.VariantAttr;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.ConfigurationDependencyGraphs;
import com.android.build.gradle.internal.ide.DependenciesImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.DependencyFailureHandlerKt;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.SyncIssueImpl;
import com.android.build.gradle.internal.ide.level2.AndroidLibraryImpl;
import com.android.build.gradle.internal.ide.level2.FullDependencyGraphsImpl;
import com.android.build.gradle.internal.ide.level2.GraphItemImpl;
import com.android.build.gradle.internal.ide.level2.JavaLibraryImpl;
import com.android.build.gradle.internal.ide.level2.ModuleLibraryImpl;
import com.android.build.gradle.internal.ide.level2.SimpleDependencyGraphsImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.namespaced.AutoNamespaceLocation;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.caching.CreatingCache;
import com.android.utils.FileUtils;
import com.android.utils.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.component.Artifact;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;

public class ArtifactDependencyGraph {
    private static final String LOCAL_AAR_GROUPID = "__local_aars__";
    private static final CreatingCache<HashableResolvedArtifactResult, MavenCoordinates> sMavenCoordinatesCache = new CreatingCache(ArtifactDependencyGraph::computeMavenCoordinates);
    private static final CreatingCache<HashableResolvedArtifactResult, Library> sLibraryCache = new CreatingCache(ArtifactDependencyGraph::instantiateLibrary);
    private static final Map<String, Library> sGlobalLibrary = Maps.newHashMap();
    private DependencyFailureHandler dependencyFailureHandler = new DependencyFailureHandler();

    public static void clearCaches() {
        sMavenCoordinatesCache.clear();
        sLibraryCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Library instantiateLibrary(HashableResolvedArtifactResult artifact) {
        Library library;
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        String address = ArtifactDependencyGraph.computeAddress(artifact);
        if (!(id instanceof ProjectComponentIdentifier) || artifact.isWrappedModule()) {
            if (artifact.getDependencyType() == DependencyType.ANDROID) {
                File explodedFolder = artifact.getFile();
                library = new AndroidLibraryImpl(address, artifact.bundleResult != null ? artifact.bundleResult.getFile() : explodedFolder, explodedFolder, ArtifactDependencyGraph.findResStaticLibrary(explodedFolder), ArtifactDependencyGraph.findLocalJarsAsStrings(explodedFolder));
            } else {
                library = new JavaLibraryImpl(address, artifact.getFile());
            }
        } else {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)id;
            String buildId = ArtifactDependencyGraph.getBuildId(projectId, artifact.getBuildMapping());
            library = new ModuleLibraryImpl(address, buildId, projectId.getProjectPath(), ArtifactDependencyGraph.getVariant(artifact));
        }
        Map<String, Library> map = sGlobalLibrary;
        synchronized (map) {
            sGlobalLibrary.put(library.getArtifactAddress(), library);
        }
        return library;
    }

    public static Map<String, Library> getGlobalLibMap() {
        return ImmutableMap.copyOf(sGlobalLibrary);
    }

    public static String getVariant(ResolvedArtifactResult artifact) {
        VariantAttr variantAttr = (VariantAttr)artifact.getVariant().getAttributes().getAttribute(VariantAttr.ATTRIBUTE);
        return variantAttr == null ? null : variantAttr.getName();
    }

    public static String computeAddress(HashableResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)id;
            String buildId = ArtifactDependencyGraph.getBuildId(projectId, artifact.getBuildMapping());
            String variant = ArtifactDependencyGraph.getVariant(artifact);
            StringBuilder sb = new StringBuilder(100);
            sb.append(buildId).append("@@");
            sb.append(projectId.getProjectPath());
            if (variant != null) {
                sb.append("::").append(variant);
            }
            return sb.toString().intern();
        }
        if (id instanceof ModuleComponentIdentifier || id instanceof OpaqueComponentArtifactIdentifier) {
            MavenCoordinates coordinates = (MavenCoordinates)sMavenCoordinatesCache.get((Object)artifact);
            Preconditions.checkNotNull((Object)coordinates);
            return coordinates.toString().intern();
        }
        throw new RuntimeException("Don't know how to handle ComponentIdentifier '" + id.getDisplayName() + "'of type " + id.getClass());
    }

    private static MavenCoordinates computeMavenCoordinates(ResolvedArtifactResult artifact) {
        HashableResolvedArtifactResult hashableResult = (HashableResolvedArtifactResult)artifact;
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        File artifactFile = artifact.getFile();
        String fileName = artifactFile.getName();
        String extension = hashableResult.getDependencyType().getExtension();
        if (id instanceof ModuleComponentIdentifier) {
            String pattern;
            Pattern p;
            Matcher m;
            ModuleComponentIdentifier moduleComponentId = (ModuleComponentIdentifier)id;
            String module = moduleComponentId.getModule();
            String version = moduleComponentId.getVersion();
            String classifier = null;
            if (!artifact.getFile().isDirectory() && (m = (p = Pattern.compile(pattern = "^" + module + "-" + version + "-(.+)\\." + extension + "$")).matcher(fileName)).matches()) {
                classifier = m.group(1);
            }
            return new MavenCoordinatesImpl(moduleComponentId.getGroup(), module, version, extension, classifier);
        }
        if (id instanceof ProjectComponentIdentifier) {
            return new MavenCoordinatesImpl("artifacts", ((ProjectComponentIdentifier)id).getProjectPath(), "unspecified");
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            if (hashableResult.getDependencyType() == DependencyType.JAVA) {
                return ArtifactDependencyGraph.getMavenCoordForLocalFile(artifactFile);
            }
            assert (artifactFile.isDirectory());
            return ArtifactDependencyGraph.getMavenCoordForLocalFile(artifactFile);
        }
        throw new RuntimeException("Don't know how to compute maven coordinate for artifact '" + artifact.getId().getDisplayName() + "' with component identifier of type '" + id.getClass() + "'.");
    }

    public static MavenCoordinatesImpl getMavenCoordForLocalFile(File artifactFile) {
        return new MavenCoordinatesImpl(LOCAL_AAR_GROUPID, artifactFile.getPath(), "unspecified");
    }

    public static Set<HashableResolvedArtifactResult> getAllArtifacts(VariantScope variantScope, AndroidArtifacts.ConsumedConfigType consumedConfigType, DependencyFailureHandler dependencyFailureHandler, ImmutableMap<String, String> buildMapping) {
        ArtifactCollection allArtifactList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
        ArtifactCollection manifestList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
        ArtifactCollection nonNamespacedManifestList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.NON_NAMESPACED_MANIFEST);
        ArtifactCollection explodedAarList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.EXPLODED_AAR);
        ArtifactCollection aarList = ArtifactDependencyGraph.computeArtifactList(variantScope, consumedConfigType, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.AAR);
        if (dependencyFailureHandler != null) {
            dependencyFailureHandler.addErrors(variantScope.getGlobalScope().getProject().getPath() + "@" + variantScope.getFullVariantName() + "/" + consumedConfigType.getName(), allArtifactList.getFailures());
        }
        HashSet<Object> wrapperModules = new HashSet<Object>();
        Set explodedAarArtifacts = explodedAarList.getArtifacts();
        HashMap explodedAarResults = Maps.newHashMapWithExpectedSize((int)explodedAarArtifacts.size());
        for (ResolvedArtifactResult result : explodedAarArtifacts) {
            ComponentIdentifier componentIdentifier = result.getId().getComponentIdentifier();
            if (componentIdentifier instanceof ProjectComponentIdentifier) {
                wrapperModules.add(componentIdentifier);
            }
            explodedAarResults.put(componentIdentifier, result);
        }
        Set aarArtifacts = aarList.getArtifacts();
        HashMap aarResults = Maps.newHashMapWithExpectedSize((int)aarArtifacts.size());
        for (ResolvedArtifactResult result : aarArtifacts) {
            aarResults.put(result.getId().getComponentIdentifier(), result);
        }
        HashSet manifestArtifacts = new HashSet();
        manifestArtifacts.addAll(manifestList.getArtifacts());
        manifestArtifacts.addAll(nonNamespacedManifestList.getArtifacts());
        HashSet manifestIds = Sets.newHashSetWithExpectedSize((int)manifestArtifacts.size());
        for (ResolvedArtifactResult result : manifestArtifacts) {
            manifestIds.add(result.getId().getComponentIdentifier());
        }
        Set allArtifacts = allArtifactList.getArtifacts();
        LinkedHashSet artifacts = Sets.newLinkedHashSetWithExpectedSize((int)allArtifacts.size());
        for (ResolvedArtifactResult artifact : allArtifacts) {
            ComponentIdentifier componentIdentifier = artifact.getId().getComponentIdentifier();
            boolean isWrappedModule = wrapperModules.contains(componentIdentifier);
            DependencyType dependencyType = DependencyType.JAVA;
            ResolvedArtifactResult aarResult = null;
            if (manifestIds.contains(componentIdentifier)) {
                dependencyType = DependencyType.ANDROID;
                ResolvedArtifactResult explodedAar = (ResolvedArtifactResult)explodedAarResults.get(componentIdentifier);
                if (explodedAar != null) {
                    artifact = explodedAar;
                }
                aarResult = (ResolvedArtifactResult)aarResults.get(componentIdentifier);
            }
            artifacts.add(new HashableResolvedArtifactResult(artifact, dependencyType, isWrappedModule, aarResult, buildMapping));
        }
        return artifacts;
    }

    private static ArtifactCollection computeArtifactList(VariantScope variantScope, AndroidArtifacts.ConsumedConfigType consumedConfigType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType type) {
        ArtifactCollection artifacts = variantScope.getArtifactCollection(consumedConfigType, scope, type);
        if (artifacts instanceof ArtifactCollectionWithExtraArtifact) {
            return ((ArtifactCollectionWithExtraArtifact)artifacts).getParentArtifacts();
        }
        return artifacts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyGraphs createLevel4DependencyGraph(VariantScope variantScope, boolean withFullDependency, boolean downloadSources, ImmutableMap<String, String> buildMapping, Consumer<SyncIssue> failureConsumer) {
        try {
            Set<HashableResolvedArtifactResult> runtimeArtifacts;
            Set<HashableResolvedArtifactResult> compileArtifacts = ArtifactDependencyGraph.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            if (downloadSources) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)compileArtifacts.size());
                for (HashableResolvedArtifactResult artifact : compileArtifacts) {
                    ids.add(artifact.getId().getComponentIdentifier());
                }
                ArtifactDependencyGraph.handleSources(variantScope.getGlobalScope().getProject(), ids, failureConsumer);
            }
            if (!withFullDependency) {
                ArtifactCollection runtimeArtifactCollection = ArtifactDependencyGraph.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
                runtimeArtifacts = runtimeArtifactCollection.getArtifacts();
                HashSet runtimeIdentifiers = Sets.newHashSetWithExpectedSize((int)runtimeArtifacts.size());
                for (ResolvedArtifactResult resolvedArtifactResult : runtimeArtifacts) {
                    runtimeIdentifiers.add(resolvedArtifactResult.getId().getComponentIdentifier());
                }
                ArrayList providedAddresses = Lists.newArrayList();
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)compileArtifacts.size());
                for (HashableResolvedArtifactResult artifact : compileArtifacts) {
                    GraphItemImpl graphItem = new GraphItemImpl(ArtifactDependencyGraph.computeAddress(artifact), (List<GraphItem>)ImmutableList.of());
                    arrayList.add(graphItem);
                    sLibraryCache.get((Object)artifact);
                    if (runtimeIdentifiers.contains(artifact.getId().getComponentIdentifier())) continue;
                    providedAddresses.add(graphItem.getArtifactAddress());
                }
                SimpleDependencyGraphsImpl simpleDependencyGraphsImpl = new SimpleDependencyGraphsImpl(arrayList, providedAddresses);
                return simpleDependencyGraphsImpl;
            }
            ArrayList compileItems = Lists.newArrayListWithCapacity((int)compileArtifacts.size());
            for (HashableResolvedArtifactResult artifact : compileArtifacts) {
                compileItems.add(new GraphItemImpl(ArtifactDependencyGraph.computeAddress(artifact), (List<GraphItem>)ImmutableList.of()));
                sLibraryCache.get((Object)artifact);
            }
            runtimeArtifacts = ArtifactDependencyGraph.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            ArrayList runtimeItems = Lists.newArrayListWithCapacity((int)runtimeArtifacts.size());
            for (HashableResolvedArtifactResult hashableResolvedArtifactResult : runtimeArtifacts) {
                runtimeItems.add(new GraphItemImpl(ArtifactDependencyGraph.computeAddress(hashableResolvedArtifactResult), (List<GraphItem>)ImmutableList.of()));
                sLibraryCache.get((Object)hashableResolvedArtifactResult);
            }
            ArrayList providedItems = Lists.newArrayList((Iterable)compileItems);
            providedItems.removeAll(runtimeItems);
            ImmutableList immutableList = (ImmutableList)providedItems.stream().map(GraphItem::getArtifactAddress).collect(ImmutableCollectors.toImmutableList());
            FullDependencyGraphsImpl fullDependencyGraphsImpl = new FullDependencyGraphsImpl(compileItems, runtimeItems, (List<String>)immutableList, (List<String>)ImmutableList.of());
            return fullDependencyGraphsImpl;
        }
        finally {
            this.dependencyFailureHandler.collectIssues().forEach(failureConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependenciesImpl createDependencies(VariantScope variantScope, boolean downloadSources, ImmutableMap<String, String> buildMapping, Consumer<SyncIssue> failureConsumer) {
        try {
            ImmutableList.Builder projects = ImmutableList.builder();
            ImmutableList.Builder androidLibraries = ImmutableList.builder();
            ImmutableList.Builder javaLibrary = ImmutableList.builder();
            ArtifactCollection runtimeArtifactCollection = ArtifactDependencyGraph.computeArtifactList(variantScope, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAR);
            HashSet<ComponentIdentifier> runtimeIdentifiers = new HashSet<ComponentIdentifier>(runtimeArtifactCollection.getArtifacts().size());
            for (Object result : runtimeArtifactCollection.getArtifacts()) {
                runtimeIdentifiers.add(result.getId().getComponentIdentifier());
            }
            Set<HashableResolvedArtifactResult> artifacts = ArtifactDependencyGraph.getAllArtifacts(variantScope, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler, buildMapping);
            for (HashableResolvedArtifactResult artifact : artifacts) {
                ComponentIdentifier id = artifact.getId().getComponentIdentifier();
                boolean isProvided = !runtimeIdentifiers.contains(id);
                boolean isSubproject = id instanceof ProjectComponentIdentifier;
                String projectPath = null;
                String buildId = null;
                if (isSubproject) {
                    ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)id;
                    projectPath = projectId.getProjectPath();
                    buildId = ArtifactDependencyGraph.getBuildId(projectId, buildMapping);
                }
                if (artifact.getDependencyType() == DependencyType.JAVA) {
                    if (projectPath != null) {
                        projects.add((Object)new DependenciesImpl.ProjectIdentifierImpl(buildId, projectPath));
                        continue;
                    }
                    javaLibrary.add((Object)new com.android.build.gradle.internal.ide.JavaLibraryImpl(artifact.getFile(), null, null, (List<JavaLibrary>)ImmutableList.of(), null, (MavenCoordinates)Preconditions.checkNotNull((Object)sMavenCoordinatesCache.get((Object)artifact)), false, isProvided));
                    continue;
                }
                if (artifact.isWrappedModule()) {
                    buildId = null;
                    projectPath = null;
                }
                File explodedFolder = artifact.getFile();
                androidLibraries.add((Object)new com.android.build.gradle.internal.ide.AndroidLibraryImpl((MavenCoordinates)Preconditions.checkNotNull((Object)sMavenCoordinatesCache.get((Object)artifact)), buildId, projectPath, artifact.bundleResult != null ? artifact.bundleResult.getFile() : explodedFolder, explodedFolder, ArtifactDependencyGraph.findResStaticLibrary(variantScope, artifact), ArtifactDependencyGraph.getVariant(artifact), isProvided, false, (List<AndroidLibrary>)ImmutableList.of(), (Collection<JavaLibrary>)ImmutableList.of(), ArtifactDependencyGraph.findLocalJarsAsFiles(explodedFolder)));
            }
            if (downloadSources) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)artifacts.size());
                for (HashableResolvedArtifactResult artifact : artifacts) {
                    ids.add(artifact.getId().getComponentIdentifier());
                }
                ArtifactDependencyGraph.handleSources(variantScope.getGlobalScope().getProject(), ids, failureConsumer);
            }
            DependenciesImpl dependenciesImpl = new DependenciesImpl((List<AndroidLibrary>)androidLibraries.build(), (List<JavaLibrary>)javaLibrary.build(), (List<Dependencies.ProjectIdentifier>)projects.build());
            return dependenciesImpl;
        }
        finally {
            this.dependencyFailureHandler.collectIssues().forEach(failureConsumer);
        }
    }

    private static String getBuildId(ProjectComponentIdentifier projectId, ImmutableMap<String, String> buildMapping) {
        return (String)buildMapping.get((Object)(projectId.getBuild().isCurrentBuild() ? "__current_build__" : projectId.getBuild().getName()));
    }

    public static Dependencies clone(Dependencies dependencies, int modelLevel) {
        if (modelLevel >= 4) {
            return ModelBuilder.EMPTY_DEPENDENCIES_IMPL;
        }
        List<AndroidLibrary> libraries = Collections.emptyList();
        ArrayList javaLibraries = Lists.newArrayList((Iterable)dependencies.getJavaLibraries());
        List<Dependencies.ProjectIdentifier> projects = Collections.emptyList();
        return new DependenciesImpl(libraries, javaLibraries, projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyGraphs clone(DependencyGraphs dependencyGraphs, int modelLevel, boolean modelWithFullDependency) {
        if (modelLevel < 4) {
            return ModelBuilder.EMPTY_DEPENDENCY_GRAPH;
        }
        Preconditions.checkState((boolean)(dependencyGraphs instanceof ConfigurationDependencyGraphs));
        ConfigurationDependencyGraphs cdg = (ConfigurationDependencyGraphs)dependencyGraphs;
        List<Library> libs = cdg.getLibraries();
        Map<String, Library> map = sGlobalLibrary;
        synchronized (map) {
            for (Library library : libs) {
                sGlobalLibrary.put(library.getArtifactAddress(), library);
            }
        }
        List<GraphItem> nodes = cdg.getCompileDependencies();
        if (modelWithFullDependency) {
            return new FullDependencyGraphsImpl(nodes, nodes, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
        }
        return new SimpleDependencyGraphsImpl(nodes, cdg.getProvidedLibraries());
    }

    private static void handleSources(Project project, Set<ComponentIdentifier> artifacts, Consumer<SyncIssue> failureConsumer) {
        DependencyHandler dependencies = project.getDependencies();
        try {
            ArtifactResolutionQuery query = dependencies.createArtifactResolutionQuery();
            query.forComponents(artifacts);
            Class[] artifactTypesArray = new Class[]{SourcesArtifact.class};
            query.withArtifacts(JvmLibrary.class, artifactTypesArray);
            ArtifactResolutionResult queryResult = query.execute();
            Set resolvedComponents = queryResult.getResolvedComponents();
            HashSet remainingToResolve = Sets.newHashSet();
            for (ComponentArtifactsResult componentResult : resolvedComponents) {
                Set sourcesArtifacts = componentResult.getArtifacts(SourcesArtifact.class);
                if (!sourcesArtifacts.isEmpty()) continue;
                remainingToResolve.add(componentResult.getId());
            }
            if (!remainingToResolve.isEmpty()) {
                artifactTypesArray[0] = JavadocArtifact.class;
                query = dependencies.createArtifactResolutionQuery();
                query.forComponents((Iterable)remainingToResolve);
                query.withArtifacts(JvmLibrary.class, artifactTypesArray);
                query.execute().getResolvedComponents();
            }
        }
        catch (Throwable t) {
            DependencyFailureHandlerKt.processDependencyThrowable(t, (Function1<? super String, String>)((Function1)s -> null), (data, messages) -> failureConsumer.accept(new SyncIssueImpl(EvalIssueReporter.Type.GENERIC, EvalIssueReporter.Severity.WARNING, null, String.format("Unable to download sources/javadoc: %s", messages.get(0)), (List<String>)messages)));
        }
    }

    private static List<String> findLocalJarsAsStrings(File folder) {
        File localJarRoot = FileUtils.join((File)folder, (String[])new String[]{"jars", "libs"});
        if (!localJarRoot.isDirectory()) {
            return ImmutableList.of();
        }
        String[] jarFiles = localJarRoot.list((dir, name) -> name.endsWith(".jar"));
        if (jarFiles != null && jarFiles.length > 0) {
            ArrayList list = Lists.newArrayListWithCapacity((int)jarFiles.length);
            for (String jarFile : jarFiles) {
                list.add("jars" + File.separatorChar + "libs" + File.separatorChar + jarFile);
            }
            return list;
        }
        return ImmutableList.of();
    }

    private static List<File> findLocalJarsAsFiles(File folder) {
        File localJarRoot = FileUtils.join((File)folder, (String[])new String[]{"jars", "libs"});
        if (!localJarRoot.isDirectory()) {
            return ImmutableList.of();
        }
        Object[] jarFiles = localJarRoot.listFiles((dir, name) -> name.endsWith(".jar"));
        if (jarFiles != null && jarFiles.length > 0) {
            return ImmutableList.copyOf((Object[])jarFiles);
        }
        return ImmutableList.of();
    }

    private static File findResStaticLibrary(VariantScope variantScope, HashableResolvedArtifactResult explodedAar) {
        BuildArtifactsHolder artifacts;
        File file = ArtifactDependencyGraph.findResStaticLibrary(explodedAar.getFile());
        if (file != null) {
            return file;
        }
        if (variantScope.getGlobalScope().getExtension().getAaptOptions().getNamespaced() && variantScope.getGlobalScope().getProjectOptions().get(BooleanOption.CONVERT_NON_NAMESPACED_DEPENDENCIES) && (artifacts = variantScope.getArtifacts()).hasArtifact(InternalArtifactType.RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES)) {
            File convertedDirectory = (File)Iterables.get((Iterable)artifacts.getFinalArtifactFiles(InternalArtifactType.RES_CONVERTED_NON_NAMESPACED_REMOTE_DEPENDENCIES), (int)0);
            return new File(convertedDirectory, AutoNamespaceLocation.getAutoNamespacedLibraryFileName(explodedAar.getId().getComponentIdentifier()));
        }
        return null;
    }

    private static File findResStaticLibrary(File explodedAar) {
        File file = new File(explodedAar, "res.apk");
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static class HashableResolvedArtifactResult
    implements ResolvedArtifactResult {
        private final ResolvedArtifactResult delegate;
        private final DependencyType dependencyType;
        private final boolean wrappedModule;
        private final ResolvedArtifactResult bundleResult;
        private final ImmutableMap<String, String> buildMapping;

        public HashableResolvedArtifactResult(ResolvedArtifactResult delegate, DependencyType dependencyType, boolean wrappedModule, ResolvedArtifactResult bundleResult, ImmutableMap<String, String> buildMapping) {
            this.delegate = delegate;
            this.dependencyType = dependencyType;
            this.wrappedModule = wrappedModule;
            this.bundleResult = bundleResult;
            this.buildMapping = buildMapping;
        }

        public File getFile() {
            return this.delegate.getFile();
        }

        public ResolvedVariantResult getVariant() {
            return this.delegate.getVariant();
        }

        public ComponentArtifactIdentifier getId() {
            return this.delegate.getId();
        }

        public Class<? extends Artifact> getType() {
            return this.delegate.getType();
        }

        public DependencyType getDependencyType() {
            return this.dependencyType;
        }

        public boolean isWrappedModule() {
            return this.wrappedModule;
        }

        public ImmutableMap<String, String> getBuildMapping() {
            return this.buildMapping;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashableResolvedArtifactResult that = (HashableResolvedArtifactResult)o;
            return this.wrappedModule == that.wrappedModule && this.dependencyType == that.dependencyType && com.google.common.base.Objects.equal((Object)this.getFile(), (Object)that.getFile()) && com.google.common.base.Objects.equal((Object)this.getId(), (Object)that.getId()) && com.google.common.base.Objects.equal(this.getType(), that.getType()) && com.google.common.base.Objects.equal(this.getBuildMapping(), that.getBuildMapping());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.delegate, this.dependencyType, this.wrappedModule, this.buildMapping});
        }

        public String toString() {
            return this.getId().toString();
        }
    }

    public static enum DependencyType {
        JAVA("jar"),
        ANDROID("aar");

        private final String extension;

        private DependencyType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

