/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.CapturingChangesApkCreator;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0002\n\u000bB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/incremental/ApkChangeList;", "", "changes", "", "Lcom/android/build/gradle/internal/incremental/ApkChangeList$ChangedItem;", "deletions", "(Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "getChanges", "()Ljava/lang/Iterable;", "getDeletions", "ChangedItem", "Companion", "gradle"})
public final class ApkChangeList {
    @NotNull
    private final Iterable<ChangedItem> changes;
    @NotNull
    private final Iterable<ChangedItem> deletions;
    @NotNull
    public static final String CHANGE_LIST_FN = "__adt_change_list__.json";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Iterable<ChangedItem> getChanges() {
        return this.changes;
    }

    @NotNull
    public final Iterable<ChangedItem> getDeletions() {
        return this.deletions;
    }

    public ApkChangeList(@NotNull Iterable<ChangedItem> changes, @NotNull Iterable<ChangedItem> deletions) {
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull(deletions, (String)"deletions");
        this.changes = changes;
        this.deletions = deletions;
    }

    @JvmStatic
    @NotNull
    public static final String changeListFileName(@NotNull File apkFile) {
        return Companion.changeListFileName(apkFile);
    }

    @JvmStatic
    public static final void write(@NotNull CapturingChangesApkCreator source, @NotNull Writer writer) {
        Companion.write(source, writer);
    }

    @JvmStatic
    @NotNull
    public static final ApkChangeList read(@NotNull Reader reader) {
        return Companion.read(reader);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/incremental/ApkChangeList$ChangedItem;", "", "path", "", "lastModified", "", "(Ljava/lang/String;J)V", "getLastModified", "()J", "getPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle"})
    public static final class ChangedItem {
        @NotNull
        private final String path;
        private final long lastModified;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public ChangedItem(@NotNull String path, long lastModified) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.path = path;
            this.lastModified = lastModified;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        public final long component2() {
            return this.lastModified;
        }

        @NotNull
        public final ChangedItem copy(@NotNull String path, long lastModified) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return new ChangedItem(path, lastModified);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ChangedItem copy$default(ChangedItem changedItem, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = changedItem.path;
            }
            if ((n & 2) != 0) {
                l = changedItem.lastModified;
            }
            return changedItem.copy(string, l);
        }

        public String toString() {
            return "ChangedItem(path=" + this.path + ", lastModified=" + this.lastModified + ")";
        }

        public int hashCode() {
            String string = this.path;
            return (string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.lastModified);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ChangedItem)) break block3;
                    ChangedItem changedItem = (ChangedItem)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)changedItem.path) || !(this.lastModified == changedItem.lastModified)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/incremental/ApkChangeList$Companion;", "", "()V", "CHANGE_LIST_FN", "", "changeListFileName", "apkFile", "Ljava/io/File;", "read", "Lcom/android/build/gradle/internal/incremental/ApkChangeList;", "reader", "Ljava/io/Reader;", "write", "", "source", "Lcom/android/build/gradle/internal/incremental/CapturingChangesApkCreator;", "writer", "Ljava/io/Writer;", "gradle"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String changeListFileName(@NotNull File apkFile) {
            Intrinsics.checkParameterIsNotNull((Object)apkFile, (String)"apkFile");
            return FilesKt.getNameWithoutExtension((File)apkFile) + ApkChangeList.CHANGE_LIST_FN;
        }

        @JvmStatic
        public final void write(@NotNull CapturingChangesApkCreator source, @NotNull Writer writer) {
            ChangedItem it;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            JsonWriter jsonWriter = new JsonWriter(writer);
            jsonWriter.beginObject();
            if (source.getChangedItems().size() > 0) {
                jsonWriter.name("changed");
                jsonWriter.beginArray();
                $receiver$iv = source.getChangedItems();
                for (Object element$iv : $receiver$iv) {
                    it = (ChangedItem)element$iv;
                    jsonWriter.beginObject();
                    jsonWriter.name(it.getPath()).value(it.getLastModified());
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (source.getDeletedItems().size() > 0) {
                jsonWriter.name("deleted");
                jsonWriter.beginArray();
                $receiver$iv = source.getDeletedItems();
                for (Object element$iv : $receiver$iv) {
                    it = (ChangedItem)element$iv;
                    jsonWriter.beginObject();
                    jsonWriter.name(it.getPath()).value(0L);
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }

        @JvmStatic
        @NotNull
        public final ApkChangeList read(@NotNull Reader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.beginObject();
            List changedItems = new ArrayList();
            List deletedItems = new ArrayList();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (Intrinsics.areEqual((Object)name, (Object)"changed")) {
                    jsonReader.beginArray();
                    while (jsonReader.hasNext()) {
                        jsonReader.beginObject();
                        String string = jsonReader.nextName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonReader.nextName()");
                        changedItems.add(new ChangedItem(string, jsonReader.nextLong()));
                        jsonReader.endObject();
                    }
                    jsonReader.endArray();
                }
                if (!Intrinsics.areEqual((Object)name, (Object)"deleted")) continue;
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    jsonReader.beginObject();
                    String string = jsonReader.nextName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonReader.nextName()");
                    deletedItems.add(new ChangedItem(string, jsonReader.nextLong()));
                    jsonReader.endObject();
                }
                jsonReader.endArray();
            }
            return new ApkChangeList(CollectionsKt.toList((Iterable)changedItems), CollectionsKt.toList((Iterable)deletedItems));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

