/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.packaging.IncrementalPackagerBuilder;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.KnownFilesSaveData;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.utils.FileCache;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.resources.FileStatus;
import com.android.sdklib.AndroidVersion;
import com.android.tools.build.apkzlib.utils.IOExceptionWrapper;
import com.android.tools.build.apkzlib.zip.compress.Zip64NotSupportedException;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.jvm.functions.Function2;
import org.gradle.api.Project;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.tooling.BuildException;

public abstract class PackageAndroidArtifact
extends IncrementalTask {
    public static final String INSTANT_RUN_PACKAGES_PREFIX = "instant-run";
    protected InternalArtifactType manifestType;
    protected BuildableArtifact resourceFiles;
    protected FileCollection dexFolders;
    protected FileCollection featureDexFolder;
    protected BuildableArtifact assets;
    protected FileCollection javaResourceFiles;
    protected FileCollection jniFolders;
    private Set<String> abiFilters;
    private boolean debugBuild;
    private boolean jniDebugBuild;
    private CoreSigningConfig signingConfig;
    protected Supplier<AndroidVersion> minSdkVersion;
    protected Supplier<InstantRunBuildContext> instantRunContext;
    protected BuildableArtifact manifests;
    protected Collection<String> aaptOptionsNoCompress;
    protected FileType instantRunFileType;
    protected OutputScope outputScope;
    protected String projectBaseName;
    protected String buildTargetAbi;
    protected String buildTargetDensity;
    protected File outputDirectory;
    protected OutputFileProvider outputFileProvider;
    protected FileCache fileCache;
    protected BuildableArtifact apkList;
    protected IncrementalPackagerBuilder.ApkFormat apkFormat;
    private static final String ZIP_DIFF_CACHE_DIR = "zip-cache";
    private static final String ZIP_64_COPY_DIR = "zip64-copy";
    InternalArtifactType taskInputType;

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public BuildableArtifact getManifests() {
        return this.manifests;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public BuildableArtifact getResourceFiles() {
        return this.resourceFiles;
    }

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters != null ? abiFilters : ImmutableSet.of();
    }

    @Input
    public InternalArtifactType getManifestType() {
        return this.manifestType;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getJavaResourceFiles() {
        return this.javaResourceFiles;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getJniFolders() {
        return this.jniFolders;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getDexFolders() {
        return this.dexFolders;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getFeatureDexFolder() {
        return this.featureDexFolder;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public BuildableArtifact getAssets() {
        return this.assets;
    }

    @Input
    public String getProjectBaseName() {
        return this.projectBaseName;
    }

    @Input
    public String getApkFormat() {
        return this.apkFormat.name();
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Input
    public boolean getDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @Nested
    @Optional
    public CoreSigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(CoreSigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.get().getApiLevel();
    }

    @Input
    public Boolean isInInstantRunMode() {
        return this.instantRunContext.get().isInInstantRunMode();
    }

    @Input
    public List<String> getNativeLibrariesPackagingModeName() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        this.manifests.getFiles().forEach(manifest -> {
            if (manifest.isFile() && manifest.getName().equals("AndroidManifest.xml")) {
                listBuilder.add((Object)PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)manifest, () -> true, (EvalIssueReporter)this.getBuilder().getIssueReporter()).toString());
            }
        });
        return listBuilder.build();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return this.aaptOptionsNoCompress != null ? this.aaptOptionsNoCompress : Collections.emptyList();
    }

    @Input
    public InternalArtifactType getTaskInputType() {
        return this.taskInputType;
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    public String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public Collection<String> getApkNames() {
        return this.outputScope.getApkDatas().stream().filter(apkData -> apkData.getType() != VariantOutput.OutputType.SPLIT).map(ApkInfo::getOutputFileName).collect(Collectors.toList());
    }

    @InputFiles
    public BuildableArtifact getApkList() {
        return this.apkList;
    }

    private BuildOutput computeBuildOutputFile(ApkInfo apkInfo) {
        File outputFile = this.outputFileProvider != null ? this.outputFileProvider.getOutputFile(apkInfo) : new File(this.outputDirectory, apkInfo.getOutputFileName());
        return new BuildOutput(this.getInternalArtifactType(), apkInfo, outputFile);
    }

    protected abstract InternalArtifactType getInternalArtifactType();

    static Set<File> getAndroidResources(File processedResources) {
        return processedResources != null ? ImmutableSet.of((Object)processedResources) : ImmutableSet.of();
    }

    @Override
    protected void doFullTaskAction() {
        this.checkFileNameUniqueness();
        ExistingBuildElements.from((ArtifactType)this.getTaskInputType(), this.resourceFiles).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(apkInfo, inputFile) -> {
            try {
                return this.splitFullAction((ApkInfo)apkInfo, (File)inputFile);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        })).into(this.getInternalArtifactType(), this.outputDirectory);
    }

    private void checkFileNameUniqueness() {
        PackageAndroidArtifact.checkFileNameUniqueness(new BuildElements(this.outputScope.getApkDatas().stream().map(this::computeBuildOutputFile).collect(Collectors.toList())));
    }

    @VisibleForTesting
    static void checkFileNameUniqueness(BuildElements buildElements) {
        Collection fileOutputs = buildElements.stream().map(BuildOutput::getOutputFile).collect(Collectors.toList());
        java.util.Optional<String> repeatingFileNameOptional = fileOutputs.stream().filter(fileOutput -> Collections.frequency(fileOutputs, fileOutput) > 1).map(File::getName).findFirst();
        if (repeatingFileNameOptional.isPresent()) {
            String repeatingFileName = repeatingFileNameOptional.get();
            List conflictingApks = buildElements.stream().filter(buildOutput -> buildOutput.getOutputFile().getName().equals(repeatingFileName)).map(buildOutput -> {
                ApkInfo apkInfo = buildOutput.getApkInfo();
                if (apkInfo.getFilters().isEmpty()) {
                    return apkInfo.getType().toString();
                }
                return Joiner.on((String)"-").join((Iterable)apkInfo.getFilters());
            }).collect(Collectors.toList());
            throw new RuntimeException(String.format("Several variant outputs are configured to use the same file name \"%1$s\", filters : %2$s", repeatingFileName, Joiner.on((String)":").join(conflictingApks)));
        }
    }

    public File splitFullAction(ApkInfo apkData, File processedResources) throws IOException {
        ImmutableMap updatedJavaResources;
        ImmutableMap updatedDex;
        File incrementalDirForSplit = new File(this.getIncrementalFolder(), apkData.getFullName());
        if (incrementalDirForSplit.exists()) {
            FileUtils.deleteDirectoryContents((File)incrementalDirForSplit);
        } else {
            FileUtils.mkdirs((File)incrementalDirForSplit);
        }
        File cacheByPathDir = new File(incrementalDirForSplit, ZIP_DIFF_CACHE_DIR);
        FileUtils.mkdirs((File)cacheByPathDir);
        FileCacheByPath cacheByPath = new FileCacheByPath(cacheByPathDir);
        cacheByPath.clear();
        Set<File> androidResources = PackageAndroidArtifact.getAndroidResources(processedResources);
        FileUtils.mkdirs((File)this.outputDirectory);
        BuildOutput buildOutput = this.computeBuildOutputFile(apkData);
        File outputFile = buildOutput.getOutputFile();
        FileUtils.deleteRecursivelyIfExists((File)outputFile);
        if (!this.hasFeatureDexFiles()) {
            updatedDex = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getDexFolders());
            updatedJavaResources = this.getJavaResourcesChanges();
        } else {
            Preconditions.checkNotNull((Object)this.getFeatureDexFolder());
            updatedDex = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getFeatureDexFolder());
            updatedJavaResources = ImmutableMap.of();
        }
        ImmutableMap updatedAssets = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.assets.getFiles());
        ImmutableMap updatedAndroidResources = IncrementalRelativeFileSets.fromZipsAndDirectories(androidResources);
        ImmutableMap updatedJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJniFolders());
        BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType)this.manifestType, this.manifests);
        this.doTask(apkData, incrementalDirForSplit, outputFile, cacheByPath, manifestOutputs, (ImmutableMap<RelativeFile, FileStatus>)updatedDex, (ImmutableMap<RelativeFile, FileStatus>)updatedJavaResources, (ImmutableMap<RelativeFile, FileStatus>)updatedAssets, (ImmutableMap<RelativeFile, FileStatus>)updatedAndroidResources, (ImmutableMap<RelativeFile, FileStatus>)updatedJniResources);
        KnownFilesSaveData saveData = KnownFilesSaveData.make(incrementalDirForSplit);
        saveData.setInputSet((Collection<RelativeFile>)updatedDex.keySet(), KnownFilesSaveData.InputSet.DEX);
        saveData.setInputSet((Collection<RelativeFile>)updatedJavaResources.keySet(), KnownFilesSaveData.InputSet.JAVA_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)updatedAssets.keySet(), KnownFilesSaveData.InputSet.ASSET);
        saveData.setInputSet((Collection<RelativeFile>)updatedAndroidResources.keySet(), KnownFilesSaveData.InputSet.ANDROID_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)updatedJniResources.keySet(), KnownFilesSaveData.InputSet.NATIVE_RESOURCE);
        saveData.saveCurrentData();
        this.recordMetrics(outputFile, processedResources);
        return outputFile;
    }

    abstract void recordMetrics(File var1, File var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File copyJavaResourcesOnly(File destinationFolder, File zip64File) throws IOException {
        File cacheDir = new File(destinationFolder, ZIP_64_COPY_DIR);
        File copiedZip = new File(cacheDir, zip64File.getName());
        FileUtils.mkdirs((File)copiedZip.getParentFile());
        try (ZipFile inFile = new ZipFile(zip64File);
             ZipOutputStream outFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(copiedZip)));){
            Enumeration<? extends ZipEntry> entries = inFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().endsWith(".class")) continue;
                outFile.putNextEntry(new ZipEntry(zipEntry.getName()));
                try {
                    ByteStreams.copy((InputStream)new BufferedInputStream(inFile.getInputStream(zipEntry)), (OutputStream)outFile);
                }
                finally {
                    outFile.closeEntry();
                }
            }
        }
        return copiedZip;
    }

    ImmutableMap<RelativeFile, FileStatus> getJavaResourcesChanges() throws IOException {
        ImmutableMap.Builder updatedJavaResourcesBuilder = ImmutableMap.builder();
        for (File javaResourceFile : this.getJavaResourceFiles()) {
            try {
                updatedJavaResourcesBuilder.putAll((Map)(javaResourceFile.isFile() ? IncrementalRelativeFileSets.fromZip((File)javaResourceFile) : IncrementalRelativeFileSets.fromDirectory((File)javaResourceFile)));
            }
            catch (Zip64NotSupportedException e) {
                updatedJavaResourcesBuilder.putAll((Map)IncrementalRelativeFileSets.fromZip((File)PackageAndroidArtifact.copyJavaResourcesOnly(this.getIncrementalFolder(), javaResourceFile)));
            }
        }
        return updatedJavaResourcesBuilder.build();
    }

    private void doTask(ApkInfo apkData, File incrementalDirForSplit, File outputFile, FileCacheByPath cacheByPath, BuildElements manifestOutputs, ImmutableMap<RelativeFile, FileStatus> changedDex, ImmutableMap<RelativeFile, FileStatus> changedJavaResources, ImmutableMap<RelativeFile, FileStatus> changedAssets, ImmutableMap<RelativeFile, FileStatus> changedAndroidResources, ImmutableMap<RelativeFile, FileStatus> changedNLibs) throws IOException {
        BuildOutput manifestForSplit;
        ImmutableMap.Builder javaResourcesForApk = ImmutableMap.builder();
        javaResourcesForApk.putAll(changedJavaResources);
        if (this.isInInstantRunMode().booleanValue()) {
            changedDex = ImmutableMap.copyOf((Map)Maps.filterKeys(changedDex, (Predicate)Predicates.compose((Predicate)Predicates.in((Collection)this.getDexFolders().getFiles()), RelativeFile::getBase)));
        }
        ImmutableMap dexFilesToPackage = changedDex;
        String filter = null;
        FilterData abiFilter = apkData.getFilter(VariantOutput.FilterType.ABI);
        if (abiFilter != null) {
            filter = abiFilter.getIdentifier();
        }
        if ((manifestForSplit = manifestOutputs.element(apkData)) == null) {
            throw new RuntimeException("Found a .ap_ for split " + apkData + " but no " + (Object)((Object)this.manifestType) + " associated manifest file");
        }
        FileUtils.mkdirs((File)outputFile.getParentFile());
        EvalIssueReporter issueReporter = this.getBuilder().getIssueReporter();
        BooleanSupplier isInExecutionPhase = () -> true;
        try (IncrementalPackager packager = new IncrementalPackagerBuilder(this.apkFormat).withOutputFile(outputFile).withSigning(this.signingConfig).withCreatedBy(this.getBuilder().getCreatedBy()).withMinSdk(this.getMinSdkVersion()).withNativeLibraryPackagingMode(PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)manifestForSplit.getOutputFile(), (BooleanSupplier)isInExecutionPhase, (EvalIssueReporter)issueReporter)).withNoCompressPredicate(PackagingUtils.getNoCompressPredicate(this.aaptOptionsNoCompress, (File)manifestForSplit.getOutputFile(), (BooleanSupplier)isInExecutionPhase, (EvalIssueReporter)issueReporter)).withIntermediateDir(incrementalDirForSplit).withProject(this.getProject()).withDebuggableBuild(this.getDebugBuild()).withAcceptedAbis((Set<String>)(filter == null ? this.abiFilters : ImmutableSet.of((Object)filter))).withJniDebuggableBuild(this.getJniDebugBuild()).withIssueReporter(issueReporter).build();){
            packager.updateDex(dexFilesToPackage);
            packager.updateJavaResources(changedJavaResources);
            packager.updateAssets(changedAssets);
            packager.updateAndroidResources(changedAndroidResources);
            packager.updateNativeLibraries(changedNLibs);
            if (packager.hasPendingChangesWithWait()) {
                this.instantRunContext.get().addChangedFile(this.instantRunFileType, outputFile);
            }
        }
        Stream.concat(dexFilesToPackage.keySet().stream(), Stream.concat(changedJavaResources.keySet().stream(), Stream.concat(changedAndroidResources.keySet().stream(), changedNLibs.keySet().stream()))).map(RelativeFile::getBase).filter(File::isFile).distinct().forEach(f -> {
            try {
                cacheByPath.add(f);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        });
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) {
        Preconditions.checkNotNull(changedInputs, (Object)"changedInputs == null");
        ExistingBuildElements.from((ArtifactType)this.getTaskInputType(), this.resourceFiles).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(apkInfo, inputFile) -> {
            try {
                return this.splitIncrementalAction((ApkInfo)apkInfo, (File)inputFile, changedInputs);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        })).into(this.getInternalArtifactType(), this.outputDirectory);
    }

    private File splitIncrementalAction(ApkInfo apkData, File processedResources, Map<File, FileStatus> changedInputs) throws IOException {
        ImmutableMap<RelativeFile, FileStatus> changedJavaResources;
        Set javaResourceFiles;
        Set dexFiles;
        Set<File> androidResources = PackageAndroidArtifact.getAndroidResources(processedResources);
        File incrementalDirForSplit = new File(this.getIncrementalFolder(), apkData.getFullName());
        File cacheByPathDir = new File(incrementalDirForSplit, ZIP_DIFF_CACHE_DIR);
        if (!cacheByPathDir.exists()) {
            FileUtils.mkdirs((File)cacheByPathDir);
        }
        FileCacheByPath cacheByPath = new FileCacheByPath(cacheByPathDir);
        KnownFilesSaveData saveData = KnownFilesSaveData.make(incrementalDirForSplit);
        Set assetsFiles = this.assets.getFiles();
        HashSet<Runnable> cacheUpdates = new HashSet<Runnable>();
        if (!this.hasFeatureDexFiles()) {
            dexFiles = this.getDexFolders().getFiles();
            javaResourceFiles = this.getJavaResourceFiles().getFiles();
        } else {
            Preconditions.checkNotNull((Object)this.getFeatureDexFolder());
            dexFiles = this.getFeatureDexFolder().getFiles();
            javaResourceFiles = ImmutableSet.of();
        }
        ImmutableMap<RelativeFile, FileStatus> changedDexFiles = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.DEX, dexFiles, cacheByPath, cacheUpdates);
        try {
            changedJavaResources = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.JAVA_RESOURCE, javaResourceFiles, cacheByPath, cacheUpdates);
        }
        catch (Zip64NotSupportedException e) {
            ImmutableMap.Builder copiedInputs = ImmutableMap.builder();
            for (Map.Entry<File, FileStatus> fileFileStatusEntry : changedInputs.entrySet()) {
                copiedInputs.put((Object)PackageAndroidArtifact.copyJavaResourcesOnly(this.getIncrementalFolder(), fileFileStatusEntry.getKey()), (Object)fileFileStatusEntry.getValue());
            }
            changedJavaResources = KnownFilesSaveData.getChangedInputs((Map<File, FileStatus>)copiedInputs.build(), saveData, KnownFilesSaveData.InputSet.JAVA_RESOURCE, this.getJavaResourceFiles().getFiles(), cacheByPath, cacheUpdates);
        }
        ImmutableMap<RelativeFile, FileStatus> changedAssets = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.ASSET, assetsFiles, cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedAndroidResources = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.ANDROID_RESOURCE, androidResources, cacheByPath, cacheUpdates);
        ImmutableMap<RelativeFile, FileStatus> changedNLibs = KnownFilesSaveData.getChangedInputs(changedInputs, saveData, KnownFilesSaveData.InputSet.NATIVE_RESOURCE, this.getJniFolders().getFiles(), cacheByPath, cacheUpdates);
        BuildOutput buildOutput = this.computeBuildOutputFile(apkData);
        File outputFile = buildOutput.getOutputFile();
        BuildElements manifestOutputs = ExistingBuildElements.from((ArtifactType)this.manifestType, this.manifests);
        this.doTask(apkData, incrementalDirForSplit, outputFile, cacheByPath, manifestOutputs, changedDexFiles, changedJavaResources, changedAssets, changedAndroidResources, changedNLibs);
        cacheUpdates.forEach(Runnable::run);
        ImmutableMap allDex = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getDexFolders());
        ImmutableMap allJavaResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJavaResourceFiles());
        ImmutableMap allAssets = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)assetsFiles);
        ImmutableMap allAndroidResources = IncrementalRelativeFileSets.fromZipsAndDirectories(androidResources);
        ImmutableMap allJniResources = IncrementalRelativeFileSets.fromZipsAndDirectories((Iterable)this.getJniFolders());
        saveData.setInputSet((Collection<RelativeFile>)allDex.keySet(), KnownFilesSaveData.InputSet.DEX);
        saveData.setInputSet((Collection<RelativeFile>)allJavaResources.keySet(), KnownFilesSaveData.InputSet.JAVA_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)allAssets.keySet(), KnownFilesSaveData.InputSet.ASSET);
        saveData.setInputSet((Collection<RelativeFile>)allAndroidResources.keySet(), KnownFilesSaveData.InputSet.ANDROID_RESOURCE);
        saveData.setInputSet((Collection<RelativeFile>)allJniResources.keySet(), KnownFilesSaveData.InputSet.NATIVE_RESOURCE);
        saveData.saveCurrentData();
        return outputFile;
    }

    private boolean hasFeatureDexFiles() {
        return this.getFeatureDexFolder() != null && !this.getFeatureDexFolder().getFiles().isEmpty();
    }

    public static abstract class CreationAction<T extends PackageAndroidArtifact>
    extends VariantTaskCreationAction<T> {
        protected final Project project;
        protected final BuildableArtifact manifests;
        protected final InternalArtifactType inputResourceFilesType;
        protected final File outputDirectory;
        protected final OutputScope outputScope;
        private final FileCache fileCache;
        private final InternalArtifactType manifestType;

        public CreationAction(VariantScope variantScope, File outputDirectory, InternalArtifactType inputResourceFilesType, BuildableArtifact manifests, InternalArtifactType manifestType, FileCache fileCache, OutputScope outputScope) {
            super(variantScope);
            this.project = variantScope.getGlobalScope().getProject();
            this.inputResourceFilesType = inputResourceFilesType;
            this.manifests = manifests;
            this.outputDirectory = outputDirectory;
            this.outputScope = outputScope;
            this.manifestType = manifestType;
            this.fileCache = fileCache;
        }

        @Override
        public void configure(T packageAndroidArtifact) {
            super.configure(packageAndroidArtifact);
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
            ((PackageAndroidArtifact)packageAndroidArtifact).instantRunFileType = FileType.MAIN;
            ((PackageAndroidArtifact)packageAndroidArtifact).taskInputType = this.inputResourceFilesType;
            ((PackageAndroidArtifact)packageAndroidArtifact).minSdkVersion = TaskInputHelper.memoize(variantScope::getMinSdkVersion);
            ((PackageAndroidArtifact)packageAndroidArtifact).instantRunContext = TaskInputHelper.memoize(variantScope::getInstantRunBuildContext);
            ((PackageAndroidArtifact)packageAndroidArtifact).resourceFiles = variantScope.getArtifacts().getFinalArtifactFiles(this.inputResourceFilesType);
            ((PackageAndroidArtifact)packageAndroidArtifact).outputDirectory = this.outputDirectory;
            ((IncrementalTask)packageAndroidArtifact).setIncrementalFolder(new File(variantScope.getIncrementalDir(packageAndroidArtifact.getName()), "tmp"));
            ((PackageAndroidArtifact)packageAndroidArtifact).outputScope = this.outputScope;
            ((PackageAndroidArtifact)packageAndroidArtifact).fileCache = this.fileCache;
            ((PackageAndroidArtifact)packageAndroidArtifact).aaptOptionsNoCompress = DslAdaptersKt.convert(globalScope.getExtension().getAaptOptions()).getNoCompress();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifests = this.manifests;
            ((PackageAndroidArtifact)packageAndroidArtifact).dexFolders = this.getDexFolders();
            ((PackageAndroidArtifact)packageAndroidArtifact).featureDexFolder = this.getFeatureDexFolder();
            ((PackageAndroidArtifact)packageAndroidArtifact).javaResourceFiles = this.getJavaResources();
            ((PackageAndroidArtifact)packageAndroidArtifact).assets = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
            ((PackageAndroidArtifact)packageAndroidArtifact).setAbiFilters(variantConfiguration.getSupportedAbis());
            ((PackageAndroidArtifact)packageAndroidArtifact).setJniDebugBuild(((CoreBuildType)variantConfiguration.getBuildType()).isJniDebuggable());
            ((PackageAndroidArtifact)packageAndroidArtifact).setDebugBuild(((CoreBuildType)variantConfiguration.getBuildType()).isDebuggable());
            ProjectOptions projectOptions = variantScope.getGlobalScope().getProjectOptions();
            ((PackageAndroidArtifact)packageAndroidArtifact).projectBaseName = globalScope.getProjectBaseName();
            ((PackageAndroidArtifact)packageAndroidArtifact).manifestType = this.manifestType;
            ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetAbi = globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            String string = ((PackageAndroidArtifact)packageAndroidArtifact).buildTargetDensity = globalScope.getExtension().getSplits().getDensity().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY) : null;
            ((PackageAndroidArtifact)packageAndroidArtifact).apkFormat = projectOptions.get(BooleanOption.DEPLOYMENT_USES_DIRECTORY) ? IncrementalPackagerBuilder.ApkFormat.DIRECTORY : (projectOptions.get(BooleanOption.DEPLOYMENT_PROVIDES_LIST_OF_CHANGES) ? IncrementalPackagerBuilder.ApkFormat.FILE_WITH_LIST_OF_CHANGES : IncrementalPackagerBuilder.ApkFormat.FILE);
            this.finalConfigure(packageAndroidArtifact);
        }

        protected void finalConfigure(T task) {
            ImmutableSet<String> filters;
            VariantScope variantScope = this.getVariantScope();
            GlobalScope globalScope = variantScope.getGlobalScope();
            GradleVariantConfiguration variantConfiguration = variantScope.getVariantConfiguration();
            ((PackageAndroidArtifact)task).instantRunFileType = FileType.MAIN;
            ((PackageAndroidArtifact)task).dexFolders = this.getDexFolders();
            ((PackageAndroidArtifact)task).featureDexFolder = this.getFeatureDexFolder();
            ((PackageAndroidArtifact)task).javaResourceFiles = this.getJavaResources();
            ((PackageAndroidArtifact)task).jniFolders = variantScope.getVariantData().getMultiOutputPolicy() == MultiOutputPolicy.MULTI_APK ? this.getJniFolders() : ((filters = AbiSplitOptions.getAbiFilters(globalScope.getExtension().getSplits().getAbiFilters())).isEmpty() ? this.getJniFolders() : this.project.files(new Object[0]));
            ((PackageAndroidArtifact)task).apkList = variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK_LIST);
            ((PackageAndroidArtifact)task).setSigningConfig(variantConfiguration.getSigningConfig());
        }

        public FileCollection getDexFolders() {
            return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.DEX);
        }

        public FileCollection getJavaResources() {
            return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
        }

        public FileCollection getJniFolders() {
            return this.getVariantScope().getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS);
        }

        public FileCollection getFeatureDexFolder() {
            if (!this.getVariantScope().getType().isFeatureSplit()) {
                return null;
            }
            return this.getVariantScope().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_DEX, (Map<Attribute<String>, String>)ImmutableMap.of(AndroidArtifacts.MODULE_PATH, (Object)this.project.getPath()));
        }
    }

    static interface OutputFileProvider {
        public File getOutputFile(ApkInfo var1);
    }
}

