/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.model.TestOptions;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.OnDeviceOrchestratorTestRunner;
import com.android.builder.testing.ShardedTestRunner;
import com.android.builder.testing.SimpleTestRunner;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.logging.ConsoleRenderer;
import org.xml.sax.SAXException;

public class DeviceProviderInstrumentTestTask
extends AndroidBuilderTask
implements AndroidTestTask {
    private static final Predicate<File> IS_APK = file -> "apk".equals(Files.getFileExtension((String)file.getName()));
    private DeviceProvider deviceProvider;
    private File coverageDir;
    private File reportsDir;
    private File resultsDir;
    private FileCollection buddyApks;
    private FileCollection testTargetManifests;
    private ProcessExecutor processExecutor;
    private String flavorName;
    private Supplier<File> splitSelectExec;
    private AbstractTestDataImpl testData;
    private TestRunnerFactory testRunnerFactory;
    private boolean ignoreFailures;
    private boolean testFailed;
    private Collection<String> installOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void runTests() throws DeviceException, IOException, InterruptedException, TestRunner.NoAuthorizedDeviceFoundException, TestException, ParserConfigurationException, SAXException {
        boolean success;
        DeviceProviderInstrumentTestTask.checkForNonApks(this.buddyApks.getFiles(), message -> {
            throw new InvalidUserDataException(message);
        });
        File resultsOutDir = this.getResultsDir();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        File coverageOutDir = this.getCoverageDir();
        FileUtils.cleanOutputDir((File)coverageOutDir);
        if (!this.testTargetManifests.isEmpty()) {
            this.testData.loadFromMetadataFile(ExistingBuildElements.getMetadataFile(this.testTargetManifests.getSingleFile()));
        }
        if (!this.testsFound()) {
            this.getLogger().info("No tests found, nothing to do.");
            File emptyCoverageFile = new File(coverageOutDir, "coverage.ec");
            emptyCoverageFile.createNewFile();
            success = true;
        } else {
            this.deviceProvider.init();
            TestRunner testRunner = this.testRunnerFactory.build(this.splitSelectExec.get(), this.getProcessExecutor());
            ImmutableList extraArgs = this.installOptions == null || this.installOptions.isEmpty() ? ImmutableList.of() : this.installOptions;
            try {
                success = testRunner.runTests(this.getProject().getName(), this.getFlavorName(), (TestData)this.testData, this.buddyApks.getFiles(), this.deviceProvider.getDevices(), this.deviceProvider.getTimeoutInMs(), (Collection)extraArgs, resultsOutDir, coverageOutDir, this.getILogger());
            }
            finally {
                this.deviceProvider.terminate();
            }
        }
        File reportOutDir = this.getReportsDir();
        FileUtils.cleanOutputDir((File)reportOutDir);
        TestReport report2 = new TestReport(ReportType.SINGLE_FLAVOR, resultsOutDir, reportOutDir);
        report2.generateReport();
        if (!success) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message2 = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message2);
                return;
            }
            throw new GradleException(message2);
        }
        this.testFailed = false;
    }

    public static void checkForNonApks(Collection<File> buddyApksFiles, Consumer<String> errorHandler) {
        List nonApks = buddyApksFiles.stream().filter(IS_APK.negate()).collect(Collectors.toList());
        if (!nonApks.isEmpty()) {
            Collections.sort(nonApks);
            String message = String.format("Not all files in %s configuration are APKs: %s", "androidTestUtil", Joiner.on((char)' ').join(nonApks));
            errorHandler.accept(message);
        }
    }

    private boolean testsFound() {
        return !this.getProject().files(new Object[]{this.testData.getTestDirectories()}).getAsFileTree().isEmpty();
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    @Override
    public File getResultsDir() {
        return this.resultsDir;
    }

    public void setResultsDir(File resultsDir) {
        this.resultsDir = resultsDir;
    }

    @OutputDirectory
    public File getCoverageDir() {
        return this.coverageDir;
    }

    @Deprecated
    public void setCoverageDir(File coverageDir) {
        this.getLogger().info("DeviceProviderInstrumentTestTask.setCoverageDir is deprecated and has no effect.");
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public void setFlavorName(String flavorName) {
        this.flavorName = flavorName;
    }

    public Collection<String> getInstallOptions() {
        return this.installOptions;
    }

    public void setInstallOptions(Collection<String> installOptions) {
        this.installOptions = installOptions;
    }

    public DeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    public AbstractTestDataImpl getTestData() {
        return this.testData;
    }

    public void setTestData(AbstractTestDataImpl testData) {
        this.testData = testData;
    }

    @InputFile
    public File getSplitSelectExec() {
        return this.splitSelectExec.get();
    }

    public ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    public boolean getTestFailed() {
        return this.testFailed;
    }

    @InputFiles
    public FileCollection getTestTargetManifests() {
        return this.testTargetManifests;
    }

    @InputFiles
    public FileCollection getBuddyApks() {
        return this.buddyApks;
    }

    @InputFiles
    public BuildableArtifact getTestApkDir() {
        return this.testData.getTestApkDir();
    }

    @InputFiles
    @Optional
    public BuildableArtifact getTestedApksDir() {
        return this.testData.getTestedApksDir();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<DeviceProviderInstrumentTestTask> {
        private final DeviceProvider deviceProvider;
        private final AbstractTestDataImpl testData;
        private final FileCollection testTargetManifests;
        private File coverageDir;

        public CreationAction(VariantScope scope, DeviceProvider deviceProvider, AbstractTestDataImpl testData, FileCollection testTargetManifests) {
            super(scope);
            this.deviceProvider = deviceProvider;
            this.testData = testData;
            this.testTargetManifests = testTargetManifests;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName(this.deviceProvider.getName());
        }

        @Override
        public Class<DeviceProviderInstrumentTestTask> getType() {
            return DeviceProviderInstrumentTestTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.coverageDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.JACOCO_COVERAGE_DIR, taskName, "code-coverage");
        }

        @Override
        public void handleProvider(TaskProvider<? extends DeviceProviderInstrumentTestTask> taskProvider) {
            super.handleProvider(taskProvider);
            VariantScope scope = this.getVariantScope();
            if (scope.getVariantData() instanceof TestVariantData) {
                if (this.deviceProvider instanceof ConnectedDeviceProvider) {
                    scope.getTaskContainer().setConnectedTestTask(taskProvider);
                    scope.getTaskContainer().setConnectedTask(taskProvider);
                } else {
                    scope.getTaskContainer().getProviderTestTaskList().add(taskProvider);
                }
            }
        }

        @Override
        public void configure(DeviceProviderInstrumentTestTask task) {
            String variantName;
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            Project project = scope.getGlobalScope().getProject();
            ProjectOptions projectOptions = scope.getGlobalScope().getProjectOptions();
            boolean connected = this.deviceProvider instanceof ConnectedDeviceProvider;
            BaseVariantData testedVariantData = scope.getTestedVariantData();
            String string = variantName = testedVariantData != null ? testedVariantData.getName() : scope.getVariantData().getName();
            if (connected) {
                task.setDescription("Installs and runs the tests for " + variantName + " on connected devices.");
            } else {
                task.setDescription(StringHelper.appendCapitalized((String)("Installs and runs the tests for " + variantName + " using provider: "), (String)this.deviceProvider.getName()));
            }
            task.setGroup("verification");
            task.setTestData(this.testData);
            task.setFlavorName(this.testData.getFlavorName());
            task.setDeviceProvider(this.deviceProvider);
            task.testTargetManifests = this.testTargetManifests;
            task.setInstallOptions(scope.getGlobalScope().getExtension().getAdbOptions().getInstallOptions());
            task.setProcessExecutor(scope.getGlobalScope().getAndroidBuilder().getProcessExecutor());
            boolean shardBetweenDevices = projectOptions.get(BooleanOption.ENABLE_TEST_SHARDING);
            TestOptions.Execution executionEnum = scope.getGlobalScope().getExtension().getTestOptions().getExecutionEnum();
            switch (executionEnum) {
                case ANDROID_TEST_ORCHESTRATOR: 
                case ANDROIDX_TEST_ORCHESTRATOR: {
                    Preconditions.checkArgument((!shardBetweenDevices ? 1 : 0) != 0, (Object)"Sharding is not supported with Android Test Orchestrator.");
                    task.testRunnerFactory = (splitSelect, processExecutor) -> new OnDeviceOrchestratorTestRunner(splitSelect, processExecutor, executionEnum);
                    break;
                }
                case HOST: {
                    if (shardBetweenDevices) {
                        Integer numShards = projectOptions.get(IntegerOption.ANDROID_TEST_SHARD_COUNT);
                        task.testRunnerFactory = (splitSelect, processExecutor) -> new ShardedTestRunner(splitSelect, processExecutor, numShards);
                        break;
                    }
                    task.testRunnerFactory = SimpleTestRunner::new;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown value " + executionEnum));
                }
            }
            String flavorFolder = this.testData.getFlavorName();
            if (!flavorFolder.isEmpty()) {
                flavorFolder = "flavors/" + flavorFolder;
            }
            String providerFolder = connected ? "connected" : "device/" + this.deviceProvider.getName();
            String subFolder = "/" + providerFolder + "/" + flavorFolder;
            task.splitSelectExec = TaskInputHelper.memoize(() -> {
                String path;
                TargetInfo info = scope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                String string = path = info == null ? null : info.getBuildTools().getPath(BuildToolInfo.PathId.SPLIT_SELECT);
                if (path != null) {
                    File splitSelectExe = new File(path);
                    return splitSelectExe.exists() ? splitSelectExe : null;
                }
                return null;
            });
            String rootLocation = scope.getGlobalScope().getExtension().getTestOptions().getResultsDir();
            if (rootLocation == null) {
                rootLocation = scope.getGlobalScope().getBuildDir() + "/" + "outputs" + "/" + "androidTest-results";
            }
            task.resultsDir = project.file((Object)(rootLocation + subFolder));
            rootLocation = scope.getGlobalScope().getExtension().getTestOptions().getReportDir();
            if (rootLocation == null) {
                rootLocation = scope.getGlobalScope().getBuildDir() + "/" + "reports" + "/" + "androidTests";
            }
            task.reportsDir = project.file((Object)(rootLocation + subFolder));
            task.coverageDir = this.coverageDir;
            task.buddyApks = (FileCollection)MoreObjects.firstNonNull((Object)project.getConfigurations().findByName("androidTestUtil"), (Object)project.files(new Object[0]));
            task.setEnabled(this.deviceProvider.isConfigured());
            task.getOutputs().upToDateWhen(t -> false);
            task.dependsOn(new Object[]{scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK)});
            if (testedVariantData != null) {
                task.dependsOn(new Object[]{testedVariantData.getScope().getArtifacts().getFinalArtifactFiles(InternalArtifactType.APK)});
            }
        }
    }

    private static interface TestRunnerFactory {
        public TestRunner build(File var1, ProcessExecutor var2);
    }
}

