/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.ArtifactTransform;

public class ExtractAarTransform
extends ArtifactTransform {
    private static final String LIBS_PREFIX = "libs/";
    private static final int LIBS_PREFIX_LENGTH = "libs/".length();
    private static final int JARS_PREFIX_LENGTH = "jars".length() + 1;

    @Inject
    public ExtractAarTransform() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<File> transform(File input) {
        File outputDir = this.getOutputDirectory();
        FileUtils.mkdirs((File)outputDir);
        StringBuilder sb = new StringBuilder(20);
        sb.append("jars").append(File.separatorChar);
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(input));
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    String path = name;
                    if (path.equals("classes.jar") || path.equals("lint.jar")) {
                        sb.setLength(JARS_PREFIX_LENGTH);
                        sb.append(path);
                        path = sb.toString();
                    } else if (path.startsWith(LIBS_PREFIX)) {
                        sb.setLength(JARS_PREFIX_LENGTH);
                        String path2 = path.substring(LIBS_PREFIX_LENGTH);
                        if ("classes.jar".equals(path2)) {
                            sb.append(LIBS_PREFIX).append("classes-2.jar");
                        } else if ("lint.jar".equals(path2)) {
                            sb.append(LIBS_PREFIX).append("lint-2.jar");
                        } else {
                            sb.append(LIBS_PREFIX).append(path2);
                        }
                        path = sb.toString();
                    }
                    File outputFile = new File(outputDir, path.replace('/', File.separatorChar));
                    if (!ZipEntryUtils.isValidZipEntryPath((File)outputFile, (File)outputDir)) continue;
                    FileUtils.mkdirs((File)outputFile.getParentFile());
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                    Throwable throwable = null;
                    try {
                        ByteStreams.copy((InputStream)zis, (OutputStream)outputStream);
                        ((OutputStream)outputStream).flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)outputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)outputStream).close();
                    }
                }
                finally {
                    zis.closeEntry();
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        File classesJar = new File(new File(outputDir, "jars"), "classes.jar");
        if (classesJar.exists()) return ImmutableList.of((Object)outputDir);
        try {
            Files.createParentDirs((File)classesJar);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(classesJar)), new Manifest());
            jarOutputStream.close();
            return ImmutableList.of((Object)outputDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create missing classes.jar", e);
        }
    }
}

