/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.transforms.DexArchiveBuilderTransform;
import com.android.builder.core.DexOptions;
import com.android.builder.dexing.DexerTool;
import com.android.builder.utils.FileCache;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

class DexArchiveBuilderCacheHandler {
    private static final LoggerWrapper logger = LoggerWrapper.getLogger(DexArchiveBuilderTransform.class);
    private static final int CACHE_KEY_VERSION = 4;
    private final FileCache userLevelCache;
    private final DexOptions dexOptions;
    private final int minSdkVersion;
    private final boolean isDebuggable;
    private final DexerTool dexer;
    private final FileCache.CacheSession cacheSession = FileCache.newSession();

    DexArchiveBuilderCacheHandler(FileCache userLevelCache, DexOptions dexOptions, int minSdkVersion, boolean isDebuggable, DexerTool dexer) {
        this.userLevelCache = userLevelCache;
        this.dexOptions = dexOptions;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable;
        this.dexer = dexer;
    }

    File getCachedVersionIfPresent(JarInput input, List<Path> dependencies) throws IOException {
        FileCache cache = DexArchiveBuilderCacheHandler.getBuildCache(input.getFile(), DexArchiveBuilderCacheHandler.isExternalLib((QualifiedContent)input), this.userLevelCache);
        if (cache == null) {
            return null;
        }
        FileCache.Inputs buildCacheInputs = DexArchiveBuilderCacheHandler.getBuildCacheInputs(input.getFile(), this.dexOptions, this.dexer, this.minSdkVersion, this.isDebuggable, dependencies, this.cacheSession);
        return cache.cacheEntryExists(buildCacheInputs) ? cache.getFileInCache(buildCacheInputs) : null;
    }

    void populateCache(Collection<CacheableItem> cacheableItems) throws IOException, ExecutionException {
        for (CacheableItem cacheableItem : cacheableItems) {
            FileCache.Inputs buildCacheInputs;
            FileCache.QueryResult result;
            FileCache cache = DexArchiveBuilderCacheHandler.getBuildCache(cacheableItem.input.getFile(), DexArchiveBuilderCacheHandler.isExternalLib(cacheableItem.input), this.userLevelCache);
            if (cache == null || !(result = cache.createFileInCacheIfAbsent(buildCacheInputs = DexArchiveBuilderCacheHandler.getBuildCacheInputs(cacheableItem.input.getFile(), this.dexOptions, this.dexer, this.minSdkVersion, this.isDebuggable, cacheableItem.dependencies, this.cacheSession), in -> {
                Collection<File> dexArchives = cacheableItem.cachable;
                logger.verbose("Merging %1$s into %2$s", Joiner.on((char)',').join(dexArchives), in.getAbsolutePath());
                DexArchiveBuilderCacheHandler.mergeJars(in, cacheableItem.cachable);
            })).getQueryEvent().equals((Object)FileCache.QueryEvent.CORRUPTED)) continue;
            Verify.verifyNotNull((Object)result.getCauseOfCorruption());
            logger.lifecycle("The build cache at '%1$s' contained an invalid cache entry.\nCause: %2$s\nWe have recreated the cache entry.\n%3$s", cache.getCacheDirectory().getAbsolutePath(), Throwables.getStackTraceAsString((Throwable)result.getCauseOfCorruption()), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html.");
        }
    }

    private static void mergeJars(File out, Iterable<File> dexArchives) throws IOException {
        try (JarOutputStream jarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(out)));){
            HashSet<String> usedNames = new HashSet<String>();
            for (File dexArchive : dexArchives) {
                if (!dexArchive.exists()) continue;
                JarFile jarFile = new JarFile(dexArchive);
                Throwable throwable = null;
                try {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String entryName = jarEntry.getName();
                        while (!usedNames.add(entryName)) {
                            entryName = "_" + entryName;
                        }
                        jarOutputStream.putNextEntry(new JarEntry(entryName));
                        try (BufferedInputStream inputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));){
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
                        }
                        jarOutputStream.closeEntry();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
        }
    }

    private static boolean isExternalLib(QualifiedContent content2) {
        return content2.getFile().isFile() && content2.getScopes().equals(Collections.singleton(QualifiedContent.Scope.EXTERNAL_LIBRARIES)) && content2.getContentTypes().equals(Collections.singleton(QualifiedContent.DefaultContentType.CLASSES)) && !content2.getName().startsWith("android.local.jars:");
    }

    public static FileCache.Inputs getBuildCacheInputs(File inputFile, DexOptions dexOptions, DexerTool dexerTool, int minSdkVersion, boolean isDebuggable, List<Path> extraDependencies, FileCache.CacheSession cacheSession) throws IOException {
        FileCache.Inputs.Builder buildCacheInputs = new FileCache.Inputs.Builder(FileCache.Command.PREDEX_LIBRARY_TO_DEX_ARCHIVE, cacheSession);
        buildCacheInputs.putFile(FileCacheInputParams.FILE.name(), inputFile, FileCache.FileProperties.PATH_HASH).putString(FileCacheInputParams.DX_VERSION.name(), "1.16").putBoolean(FileCacheInputParams.JUMBO_MODE.name(), DexArchiveBuilderCacheHandler.isJumboModeEnabledForDx()).putBoolean(FileCacheInputParams.OPTIMIZE.name(), !dexOptions.getAdditionalParameters().contains("--no-optimize")).putString(FileCacheInputParams.DEXER_TOOL.name(), dexerTool.name()).putLong(FileCacheInputParams.CACHE_KEY_VERSION.name(), 4L).putLong(FileCacheInputParams.MIN_SDK_VERSION.name(), (long)minSdkVersion).putBoolean(FileCacheInputParams.IS_DEBUGGABLE.name(), isDebuggable);
        for (int i = 0; i < extraDependencies.size(); ++i) {
            Path path = extraDependencies.get(i);
            if (Files.isDirectory(path, new LinkOption[0])) {
                buildCacheInputs.putDirectory(FileCacheInputParams.EXTRA_DEPENDENCIES.name() + "[" + i + "]", path.toFile(), FileCache.DirectoryProperties.PATH_HASH);
                continue;
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                buildCacheInputs.putFile(FileCacheInputParams.EXTRA_DEPENDENCIES.name() + "[" + i + "]", path.toFile(), FileCache.FileProperties.PATH_HASH);
                continue;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                throw new NoSuchFileException(path.toString());
            }
            throw new IOException("Unsupported file '" + path.toString() + "'");
        }
        return buildCacheInputs.build();
    }

    static boolean isJumboModeEnabledForDx() {
        return true;
    }

    static FileCache getBuildCache(File inputFile, boolean isExternalLib, FileCache buildCache) {
        if (buildCache == null || !isExternalLib) {
            return null;
        }
        if (inputFile.getPath().contains("-SNAPSHOT")) {
            return null;
        }
        return buildCache;
    }

    private static enum FileCacheInputParams {
        FILE,
        DX_VERSION,
        JUMBO_MODE,
        OPTIMIZE,
        DEXER_TOOL,
        CACHE_KEY_VERSION,
        MIN_SDK_VERSION,
        IS_DEBUGGABLE,
        EXTRA_DEPENDENCIES;

    }

    static final class CacheableItem {
        final QualifiedContent input;
        final Collection<File> cachable;
        final List<Path> dependencies;

        CacheableItem(QualifiedContent input, Collection<File> cachable, List<Path> dependencies) {
            this.input = input;
            this.cachable = cachable;
            this.dependencies = dependencies;
        }
    }
}

