/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.utils.StringHelper;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class LintPerVariantTask
extends LintBaseTask
implements VariantAwareTask {
    private LintBaseTask.VariantInputs variantInputs;
    private boolean fatalOnly;
    private String variantName;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    @InputFiles
    @Optional
    public FileCollection getVariantInputs() {
        return this.variantInputs.getAllInputs();
    }

    @TaskAction
    public void lint() {
        this.runLint(new LintPerVariantTaskDescriptor());
    }

    public static class VitalCreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final VariantScope scope;

        public VitalCreationAction(VariantScope scope) {
            super(scope.getGlobalScope());
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lintVital");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask task) {
            super.configure(task);
            task.setVariantName(this.scope.getFullVariantName());
            task.variantInputs = new LintBaseTask.VariantInputs(this.scope);
            task.fatalOnly = true;
            task.setDescription("Runs lint on just the fatal issues in the " + task.getVariantName() + " build.");
        }
    }

    public static class CreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final VariantScope scope;

        public CreationAction(VariantScope scope) {
            super(scope.getGlobalScope());
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("lint");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask lint) {
            super.configure(lint);
            lint.setVariantName(this.scope.getFullVariantName());
            lint.variantInputs = new LintBaseTask.VariantInputs(this.scope);
            lint.setDescription(StringHelper.appendCapitalized((String)"Runs lint on the ", (String)lint.getVariantName(), (String)" build."));
        }
    }

    private class LintPerVariantTaskDescriptor
    extends LintBaseTask.LintBaseTaskDescriptor {
        private LintPerVariantTaskDescriptor() {
        }

        public String getVariantName() {
            return LintPerVariantTask.this.getVariantName();
        }

        public LintBaseTask.VariantInputs getVariantInputs(String variantName) {
            assert (variantName.equals(this.getVariantName()));
            return LintPerVariantTask.this.variantInputs;
        }

        public boolean isFatalOnly() {
            return LintPerVariantTask.this.fatalOnly;
        }
    }
}

