/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.AsmAbstractNode;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;

class AsmInterfaceNode
extends AsmAbstractNode {
    private final ImmutableList<AsmInterfaceNode> superInterfaces;

    AsmInterfaceNode(ClassNode classNode, ImmutableList<AsmInterfaceNode> superInterfaces) {
        super(classNode);
        this.superInterfaces = superInterfaces;
    }

    <T> T onAll(Function<ClassNode, T> function) {
        ClassNode value = function.apply(this.getClassNode());
        if (value != null) {
            return (T)value;
        }
        for (AsmInterfaceNode extendedInterface : this.superInterfaces) {
            value = extendedInterface.onAll(function);
            if (value == null) continue;
            return (T)value;
        }
        return null;
    }

    Iterable<AsmInterfaceNode> getSuperInterfaces() {
        return this.superInterfaces;
    }
}

