/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.BuildElements;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.jvm.functions.Function2;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

public class CopyOutputs
extends AndroidVariantTask {
    BuildableArtifact fullApks;
    BuildableArtifact abiSplits;
    BuildableArtifact resourcesSplits;
    File destinationDir;

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @InputFiles
    public BuildableArtifact getFullApks() {
        return this.fullApks;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getAbiSplits() {
        return this.abiSplits;
    }

    @InputFiles
    @Optional
    public BuildableArtifact getResourcesSplits() {
        return this.resourcesSplits;
    }

    @TaskAction
    protected void copy() throws IOException {
        FileUtils.cleanOutputDir((File)this.getDestinationDir());
        ImmutableList.Builder allCopiedFiles = ImmutableList.builder();
        allCopiedFiles.addAll((Iterable)this.parallelCopy(InternalArtifactType.FULL_APK, (FileCollection)this.fullApks.get()));
        allCopiedFiles.addAll((Iterable)this.parallelCopy(InternalArtifactType.ABI_PACKAGED_SPLIT, (FileCollection)this.abiSplits.get()));
        allCopiedFiles.addAll((Iterable)this.parallelCopy(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT, (FileCollection)this.resourcesSplits.get()));
        new BuildElements((Collection<BuildOutput>)allCopiedFiles.build()).save(this.getDestinationDir());
    }

    private BuildElements parallelCopy(InternalArtifactType inputType, FileCollection inputs) throws IOException {
        return ExistingBuildElements.from((ArtifactType)inputType, inputs).transform((Function2<? super ApkInfo, ? super File, ? extends File>)((Function2)(apkInfo, inputFile) -> {
            File destination = new File(this.getDestinationDir(), inputFile.getName());
            try {
                FileUtils.copyFile((File)inputFile, (File)destination);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            return destination;
        })).into(InternalArtifactType.APK);
    }

    public static class CreationAction
    extends VariantTaskCreationAction<CopyOutputs> {
        private final File destinationDir;

        public CreationAction(VariantScope variantScope, File destinationDir) {
            super(variantScope);
            this.destinationDir = destinationDir;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("copyOutputs");
        }

        @Override
        public Class<CopyOutputs> getType() {
            return CopyOutputs.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APK, (Collection<? extends Object>)ImmutableList.of((Object)this.destinationDir), taskName);
        }

        @Override
        public void configure(CopyOutputs task) {
            super.configure(task);
            BuildArtifactsHolder artifacts = this.getVariantScope().getArtifacts();
            task.fullApks = artifacts.getFinalArtifactFiles(InternalArtifactType.FULL_APK);
            task.abiSplits = artifacts.getFinalArtifactFiles(InternalArtifactType.ABI_PACKAGED_SPLIT);
            task.resourcesSplits = artifacts.getFinalArtifactFiles(InternalArtifactType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT);
            task.destinationDir = this.destinationDir;
        }
    }
}

