/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NdkTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public class RenderscriptCompile
extends NdkTask {
    private File sourceOutputDir;
    private File resOutputDir;
    private File objOutputDir;
    private File libOutputDir;
    private FileCollection sourceDirs;
    private FileCollection importDirs;
    private Supplier<Integer> targetApi;
    private boolean supportMode;
    private boolean useAndroidX;
    private int optimLevel;
    private boolean debugBuild;
    private boolean ndkMode;

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @OutputDirectory
    public File getObjOutputDir() {
        return this.objOutputDir;
    }

    public void setObjOutputDir(File objOutputDir) {
        this.objOutputDir = objOutputDir;
    }

    @OutputDirectory
    public File getLibOutputDir() {
        return this.libOutputDir;
    }

    public void setLibOutputDir(File libOutputDir) {
        this.libOutputDir = libOutputDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSourceDirs() {
        return this.sourceDirs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getImportDirs() {
        return this.importDirs;
    }

    public void setImportDirs(FileCollection importDirs) {
        this.importDirs = importDirs;
    }

    @Input
    public Integer getTargetApi() {
        return this.targetApi.get();
    }

    @Input
    public boolean isSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
    }

    @Input
    public boolean useAndroidX() {
        return this.useAndroidX;
    }

    @Input
    public int getOptimLevel() {
        return this.optimLevel;
    }

    public void setOptimLevel(int optimLevel) {
        this.optimLevel = optimLevel;
    }

    @Input
    public boolean isDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @Input
    public boolean isNdkMode() {
        return this.ndkMode;
    }

    public void setNdkMode(boolean ndkMode) {
        this.ndkMode = ndkMode;
    }

    @TaskAction
    void taskAction() throws IOException, InterruptedException, ProcessException {
        File sourceDestDir = this.getSourceOutputDir();
        FileUtils.cleanOutputDir((File)sourceDestDir);
        File resDestDir = this.getResOutputDir();
        FileUtils.cleanOutputDir((File)resDestDir);
        File objDestDir = this.getObjOutputDir();
        FileUtils.cleanOutputDir((File)objDestDir);
        File libDestDir = this.getLibOutputDir();
        FileUtils.cleanOutputDir((File)libDestDir);
        Set sourceDirectories = this.sourceDirs.getFiles();
        this.getBuilder().compileAllRenderscriptFiles((Collection)sourceDirectories, this.getImportFolders(), sourceDestDir, resDestDir, objDestDir, libDestDir, this.getTargetApi().intValue(), this.isDebugBuild(), this.getOptimLevel(), this.isNdkMode(), this.isSupportMode(), this.useAndroidX(), this.getNdkConfig() == null ? null : this.getNdkConfig().getAbiFilters(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
    }

    private Collection<File> getImportFolders() throws IOException {
        HashSet results = Sets.newHashSet();
        ArrayList dirs = Lists.newArrayList();
        dirs.addAll(this.getImportDirs().getFiles());
        dirs.addAll(this.sourceDirs.getFiles());
        for (File dir : dirs) {
            DirectoryWalker.builder().root(dir.toPath()).extensions(new String[]{"rsh"}).action((start, path) -> results.add(path.getParent().toFile())).build().walk();
        }
        return results;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<RenderscriptCompile> {
        private File sourceOutputDir;

        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("compile", "Renderscript");
        }

        @Override
        public Class<RenderscriptCompile> getType() {
            return RenderscriptCompile.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.sourceOutputDir = this.getVariantScope().getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.RENDERSCRIPT_SOURCE_OUTPUT_DIR, taskName, "out");
        }

        @Override
        public void handleProvider(TaskProvider<? extends RenderscriptCompile> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setRenderscriptCompileTask(taskProvider);
        }

        @Override
        public void configure(RenderscriptCompile renderscriptTask) {
            super.configure(renderscriptTask);
            VariantScope scope = this.getVariantScope();
            BaseVariantData variantData = scope.getVariantData();
            GradleVariantConfiguration config2 = variantData.getVariantConfiguration();
            boolean ndkMode = config2.getRenderscriptNdkModeEnabled();
            renderscriptTask.targetApi = TaskInputHelper.memoize(config2::getRenderscriptTarget);
            renderscriptTask.supportMode = config2.getRenderscriptSupportModeEnabled();
            renderscriptTask.useAndroidX = scope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_ANDROID_X);
            renderscriptTask.ndkMode = ndkMode;
            renderscriptTask.debugBuild = ((CoreBuildType)config2.getBuildType()).isRenderscriptDebuggable();
            renderscriptTask.optimLevel = ((CoreBuildType)config2.getBuildType()).getRenderscriptOptimLevel();
            Object[] objectArray = new Object[1];
            objectArray[0] = config2::getRenderscriptSourceList;
            renderscriptTask.sourceDirs = (FileCollection)scope.getGlobalScope().getProject().files(objectArray);
            renderscriptTask.importDirs = scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.RENDERSCRIPT);
            renderscriptTask.setSourceOutputDir(this.sourceOutputDir);
            renderscriptTask.setResOutputDir(scope.getRenderscriptResOutputDir());
            renderscriptTask.setObjOutputDir(scope.getRenderscriptObjOutputDir());
            renderscriptTask.setLibOutputDir(scope.getRenderscriptLibOutputDir());
            renderscriptTask.setNdkConfig(config2.getNdkConfig());
            if (config2.getType().isTestComponent()) {
                renderscriptTask.dependsOn(new Object[]{scope.getTaskContainer().getProcessManifestTask()});
            }
        }
    }
}

