/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b\u001a0\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a \u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a8\u0006\u001c"}, d2={"findPackage", "", "type", "name", "logger", "Lorg/gradle/api/logging/Logger;", "symbolTables", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/ide/common/symbols/SymbolTable;", "generatePublicFile", "", "symbols", "publicTxt", "Ljava/io/File;", "outputDirectory", "Ljava/nio/file/Path;", "getResourceType", "Lcom/android/resources/ResourceType;", "typeString", "isPublic", "", "symbol", "Lcom/android/ide/common/symbols/Symbol;", "publicSymbols", "maybeFindPackage", "writePublicFile", "writer", "Ljava/io/Writer;", "gradle"})
public final class NamespaceRewriterKt {
    private static final String findPackage(String type, String name, Logger logger, ImmutableList<SymbolTable> symbolTables) {
        String result;
        String string = result = NamespaceRewriterKt.maybeFindPackage(type, name, logger, symbolTables);
        if (string == null) {
            String string2 = "In package " + ((SymbolTable)symbolTables.get(0)).getTablePackage() + " found unknown symbol of type " + type + " and name " + name + '.';
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private static final String maybeFindPackage(String type, String name, Logger logger, ImmutableList<SymbolTable> symbolTables) {
        String canonicalName = SymbolUtils.canonicalizeValueResourceName((String)name);
        ArrayList<String> packages = null;
        String result = null;
        for (SymbolTable table : symbolTables) {
            if (!table.containsSymbol(NamespaceRewriterKt.getResourceType(type), canonicalName)) continue;
            if (result == null) {
                result = table.getTablePackage();
                continue;
            }
            if (packages == null) {
                packages = new ArrayList<String>();
            }
            packages.add(table.getTablePackage());
        }
        if (packages != null && !packages.isEmpty()) {
            logger.warn("In package " + ((SymbolTable)symbolTables.get(0)).getTablePackage() + " multiple options found " + "in its dependencies for resource " + type + ' ' + name + ". " + "Using " + result + ", other available: " + Joiner.on((String)", ").join((Iterable)packages));
        }
        return result;
    }

    private static final ResourceType getResourceType(String typeString) {
        ResourceType resourceType = ResourceType.fromClassName((String)typeString);
        if (resourceType == null) {
            String string = "Unknown type '" + typeString + '\'';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void generatePublicFile(@NotNull SymbolTable symbols, @Nullable File publicTxt, @NotNull Path outputDirectory) {
        SymbolTable publicSymbols;
        SymbolTable symbolTable;
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Path values = outputDirectory.resolve("values");
        Files.createDirectories(values, new FileAttribute[0]);
        Path publicXml = values.resolve("auto-namespace-public.xml");
        if (Files.exists(publicXml, new LinkOption[0])) {
            String string = "Internal error: Auto namespaced public XML file already exists: " + (Function0)new Function0<Path>(publicXml){
                final /* synthetic */ Path $publicXml;

                public final Path invoke() {
                    return this.$publicXml.toAbsolutePath();
                }
                {
                    this.$publicXml = path;
                    super(0);
                }
            };
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (publicTxt != null && Files.exists(publicTxt.toPath(), new LinkOption[0])) {
            SymbolTable symbolTable2 = SymbolIo.readFromPublicTxtFile((File)publicTxt, (String)symbols.getTablePackage());
            symbolTable = symbolTable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable2, (String)"SymbolIo.readFromPublicT\u2026xt, symbols.tablePackage)");
        } else {
            symbolTable = publicSymbols = symbols;
        }
        if (publicSymbols.getSymbols().isEmpty()) {
            return;
        }
        Closeable closeable = Files.newBufferedWriter(publicXml, new OpenOption[0]);
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            BufferedWriter bufferedWriter = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
            NamespaceRewriterKt.writePublicFile(bufferedWriter, symbols, publicSymbols);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void writePublicFile(@NotNull Writer writer, @NotNull SymbolTable symbols, @NotNull SymbolTable publicSymbols) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)symbols, (String)"symbols");
        Intrinsics.checkParameterIsNotNull((Object)publicSymbols, (String)"publicSymbols");
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.write("\n<resources>\n\n");
        boolean allPublic = Intrinsics.areEqual((Object)symbols, (Object)publicSymbols);
        Iterable $receiver$iv = symbols.getResourceTypes();
        for (Object element$iv : $receiver$iv) {
            ResourceType resourceType = (ResourceType)element$iv;
            boolean bl = false;
            Iterable $receiver$iv2 = symbols.getSymbolByResourceType(resourceType);
            for (Object element$iv2 : $receiver$iv2) {
                Symbol symbol = (Symbol)element$iv2;
                boolean bl2 = false;
                if (!allPublic && !NamespaceRewriterKt.isPublic(symbol, publicSymbols)) continue;
                writer.write("    <public name=\"");
                writer.write(symbol.getName());
                writer.write("\" type=\"");
                writer.write(resourceType.getName());
                writer.write("\" />\n");
            }
        }
        writer.write("\n</resources>\n");
    }

    public static final boolean isPublic(@NotNull Symbol symbol, @NotNull SymbolTable publicSymbols) {
        Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
        Intrinsics.checkParameterIsNotNull((Object)publicSymbols, (String)"publicSymbols");
        return publicSymbols.containsSymbol(symbol.getResourceType(), symbol.getCanonicalName());
    }

    public static final /* synthetic */ String access$findPackage(String type, String name, Logger logger, ImmutableList symbolTables) {
        return NamespaceRewriterKt.findPackage(type, name, logger, (ImmutableList<SymbolTable>)symbolTables);
    }

    public static final /* synthetic */ String access$maybeFindPackage(String type, String name, Logger logger, ImmutableList symbolTables) {
        return NamespaceRewriterKt.maybeFindPackage(type, name, logger, (ImmutableList<SymbolTable>)symbolTables);
    }
}

