/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.builder.packaging.JarMerger;
import com.android.builder.utils.ZipEntryUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class LibraryBaseTransform
extends Transform {
    protected final File mainClassLocation;
    protected final File localJarsLocation;
    private String packagePath;
    private final Supplier<String> packageNameSupplier;
    protected final boolean packageBuildConfig;
    protected final BuildableArtifact typedefRecipe;
    protected List<ExcludeListProvider> excludeListProviders;

    public LibraryBaseTransform(File mainClassLocation, File localJarsLocation, BuildableArtifact typedefRecipe, Supplier<String> packageNameSupplier, boolean packageBuildConfig) {
        this.mainClassLocation = mainClassLocation;
        this.localJarsLocation = localJarsLocation;
        this.typedefRecipe = typedefRecipe;
        this.packageNameSupplier = packageNameSupplier;
        this.packageBuildConfig = packageBuildConfig;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.typedefRecipe != null) {
            return ImmutableList.of((Object)SecondaryFile.nonIncremental((Supplier)this.typedefRecipe));
        }
        return ImmutableList.of();
    }

    public void addExcludeListProvider(ExcludeListProvider provider) {
        if (this.excludeListProviders == null) {
            this.excludeListProviders = Lists.newArrayList();
        }
        this.excludeListProviders.add(provider);
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JARS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.PROJECT_ONLY;
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        if (this.localJarsLocation == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.localJarsLocation);
    }

    protected List<Pattern> computeExcludeList() {
        ArrayList excludes = Lists.newArrayListWithExpectedSize((int)5);
        excludes.add(".*/R.class$");
        excludes.add(".*/R\\$(.*).class$");
        if (this.packagePath == null) {
            this.packagePath = this.packageNameSupplier.get().replace(".", "/");
        }
        excludes.add(this.packagePath + "/Manifest.class$");
        excludes.add(this.packagePath + "/Manifest\\$(.*).class$");
        if (!this.packageBuildConfig) {
            excludes.add(this.packagePath + "/BuildConfig.class$");
        }
        if (this.excludeListProviders != null) {
            for (ExcludeListProvider provider : this.excludeListProviders) {
                List<String> list = provider.getExcludeList();
                if (list == null) continue;
                excludes.addAll(list);
            }
        }
        return excludes.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    protected void processLocalJars(List<QualifiedContent> qualifiedContentList) throws IOException {
        Iterator<QualifiedContent> iterator = qualifiedContentList.iterator();
        while (iterator.hasNext()) {
            QualifiedContent content2 = iterator.next();
            if (!(content2 instanceof JarInput)) continue;
            LibraryBaseTransform.copyJarWithContentFilter(content2.getFile(), new File(this.localJarsLocation, content2.getFile().getName()), JarMerger.CLASSES_ONLY);
            iterator.remove();
        }
        if (!qualifiedContentList.isEmpty()) {
            try (JarMerger jarMerger = new JarMerger(new File(this.localJarsLocation, "otherclasses.jar").toPath(), JarMerger.CLASSES_ONLY);){
                for (QualifiedContent content3 : qualifiedContentList) {
                    jarMerger.addDirectory(content3.getFile().toPath());
                }
            }
        }
    }

    protected static void copyJarWithContentFilter(File from, File to, List<Pattern> excludes) throws IOException {
        LibraryBaseTransform.copyJarWithContentFilter(from, to, (String archivePath) -> LibraryBaseTransform.checkEntry(excludes, archivePath));
    }

    protected static void copyJarWithContentFilter(File from, File to, Predicate<String> filter) throws IOException {
        byte[] buffer = new byte[4096];
        try (Closer closer = Closer.create();){
            ZipEntry entry;
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(to));
            BufferedOutputStream bos = (BufferedOutputStream)closer.register((Closeable)new BufferedOutputStream(fos));
            ZipOutputStream zos = (ZipOutputStream)closer.register((Closeable)new ZipOutputStream(bos));
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(from));
            BufferedInputStream bis = (BufferedInputStream)closer.register((Closeable)new BufferedInputStream(fis));
            ZipInputStream zis = (ZipInputStream)closer.register((Closeable)new ZipInputStream(bis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String name = entry.getName();
                if (entry.isDirectory() || filter != null && !filter.test(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                if (!ZipEntryUtils.isValidZipEntryName((ZipEntry)newEntry)) {
                    throw new InvalidPathException(newEntry.getName(), "Entry name contains invalid characters");
                }
                newEntry.setLastModifiedTime(JarMerger.ZERO_TIME);
                newEntry.setLastAccessTime(JarMerger.ZERO_TIME);
                newEntry.setCreationTime(JarMerger.ZERO_TIME);
                zos.putNextEntry(newEntry);
                while ((count = zis.read(buffer)) != -1) {
                    zos.write(buffer, 0, count);
                }
                zos.closeEntry();
                zis.closeEntry();
            }
        }
    }

    protected static boolean checkEntry(List<Pattern> patterns, String name) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }

    protected static void mergeInputsToLocation(List<QualifiedContent> qualifiedContentList, File toFile, boolean forIntermediateJar, Predicate<String> filter, JarMerger.Transformer typedefRemover) throws IOException {
        Predicate<String> filterAndOnlyClasses = JarMerger.CLASSES_ONLY.and(filter);
        try (JarMerger jarMerger = new JarMerger(toFile.toPath());){
            for (QualifiedContent content2 : qualifiedContentList) {
                Predicate<String> thisFilter;
                boolean hasResources = content2.getContentTypes().contains(QualifiedContent.DefaultContentType.RESOURCES);
                Predicate<String> predicate = thisFilter = hasResources || forIntermediateJar ? filter : filterAndOnlyClasses;
                if (content2 instanceof JarInput) {
                    jarMerger.addJar(content2.getFile().toPath(), thisFilter, null);
                    continue;
                }
                jarMerger.addDirectory(content2.getFile().toPath(), thisFilter, typedefRemover, null);
            }
        }
    }

    public static interface ExcludeListProvider {
        public List<String> getExcludeList();
    }
}

