/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.store.FeatureInfoList;
import com.android.build.gradle.internal.tasks.databinding.ExportApplicationIdsParams;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/tasks/databinding/ExportApplicationIdsRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/databinding/ExportApplicationIdsParams;", "(Lcom/android/build/gradle/internal/tasks/databinding/ExportApplicationIdsParams;)V", "getParams", "()Lcom/android/build/gradle/internal/tasks/databinding/ExportApplicationIdsParams;", "run", "", "gradle"})
public final class ExportApplicationIdsRunnable
implements Runnable {
    @NotNull
    private final ExportApplicationIdsParams params;

    @Override
    public void run() {
        Set packages = new LinkedHashSet();
        for (File featureSplitDeclaration : this.params.getFeatureDeclarations()) {
            try {
                FeatureSplitDeclaration loaded;
                FeatureSplitDeclaration featureSplitDeclaration2 = loaded = FeatureSplitDeclaration.load(featureSplitDeclaration);
                Intrinsics.checkExpressionValueIsNotNull((Object)featureSplitDeclaration2, (String)"loaded");
                String string = featureSplitDeclaration2.getApplicationId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loaded.applicationId");
                packages.add(string);
            }
            catch (FileNotFoundException e) {
                throw (Throwable)new BuildException("Cannot read features split declaration file", (Throwable)e);
            }
        }
        FileUtils.cleanOutputDir((File)this.params.getPackageListOutFolder());
        this.params.getPackageListOutFolder().mkdirs();
        new FeatureInfoList(packages).serialize(new File(this.params.getPackageListOutFolder(), "all_features.json"));
    }

    @NotNull
    public final ExportApplicationIdsParams getParams() {
        return this.params;
    }

    @Inject
    public ExportApplicationIdsRunnable(@NotNull ExportApplicationIdsParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
    }
}

