/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.structureplugin;

import com.android.build.gradle.internal.tasks.structureplugin.AndroidBuildConfig;
import com.android.build.gradle.internal.tasks.structureplugin.DependencyType;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleInfo;
import com.android.build.gradle.internal.tasks.structureplugin.ModuleType;
import com.android.build.gradle.internal.tasks.structureplugin.PoetDependenciesInfo;
import com.android.build.gradle.internal.tasks.structureplugin.PoetResourceInfo;
import com.android.build.gradle.internal.tasks.structureplugin.SourceFilesInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/tasks/structureplugin/JavaModuleInfoJsonAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/gradle/internal/tasks/structureplugin/ModuleInfo;", "()V", "read", "input", "Lcom/google/gson/stream/JsonReader;", "readAndroidBuildConfig", "Lcom/android/build/gradle/internal/tasks/structureplugin/AndroidBuildConfig;", "readDependencies", "", "Lcom/android/build/gradle/internal/tasks/structureplugin/PoetDependenciesInfo;", "readResources", "Lcom/android/build/gradle/internal/tasks/structureplugin/PoetResourceInfo;", "readSourceFilesInfo", "Lcom/android/build/gradle/internal/tasks/structureplugin/SourceFilesInfo;", "write", "", "output", "Lcom/google/gson/stream/JsonWriter;", "data", "writeAndroidFields", "writeDependencies", "writeSourceFilesInfo", "language", "", "gradle"})
public final class JavaModuleInfoJsonAdapter
extends TypeAdapter<ModuleInfo> {
    public void write(@NotNull JsonWriter output2, @NotNull ModuleInfo data) {
        Intrinsics.checkParameterIsNotNull((Object)output2, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        output2.beginObject();
        output2.name("moduleName").value(data.getName());
        String string = data.getType().toString();
        JsonWriter jsonWriter = output2.name("moduleType");
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        jsonWriter.value(string4);
        this.writeSourceFilesInfo(output2, "java", data.getJavaSourceInfo());
        if (data.getUseKotlin()) {
            output2.name("useKotlin").value(data.getUseKotlin());
        }
        this.writeSourceFilesInfo(output2, "kotlin", data.getKotlinSourceInfo());
        this.writeAndroidFields(output2, data);
        this.writeDependencies(output2, data);
        output2.endObject();
    }

    private final void writeSourceFilesInfo(JsonWriter output2, String language, SourceFilesInfo data) {
        if (data.isEmpty()) {
            return;
        }
        output2.name(language);
        output2.beginObject();
        output2.name("packages").value((Number)data.getPackages());
        output2.name("classesPerPackage").value((Number)data.getClassesPerPackage());
        output2.name("methodsPerClass").value((Number)data.getMethodsPerClass());
        output2.name("fieldsPerClass").value((Number)data.getFieldsPerClass());
        output2.endObject();
    }

    private final void writeDependencies(JsonWriter output2, ModuleInfo data) {
        output2.name("dependencies").beginArray();
        Iterable $receiver$iv = data.getDependencies();
        for (Object element$iv : $receiver$iv) {
            PoetDependenciesInfo it = (PoetDependenciesInfo)element$iv;
            output2.beginObject().name(it.getType().getJsonValue()).value(it.getDependency()).name("method").value(it.getScope()).endObject();
        }
        output2.endArray();
    }

    private final void writeAndroidFields(JsonWriter output2, ModuleInfo data) {
        if (data.getType() != ModuleType.ANDROID) {
            return;
        }
        output2.name("androidBuildConfig").beginObject().name("minSdkVersion").value((Number)data.getAndroidBuildConfig().getMinSdkVersion()).name("targetSdkVersion").value((Number)data.getAndroidBuildConfig().getTargetSdkVersion()).name("compileSdkVersion").value((Number)data.getAndroidBuildConfig().getCompileSdkVersion()).endObject();
        output2.name("activityCount").value((Number)data.getActivityCount());
        output2.name("hasLaunchActivity").value(data.getHasLaunchActivity());
        output2.name("resourcesConfig").beginObject().name("stringCount").value((Number)data.getResources().getStringCount()).name("imageCount").value((Number)data.getResources().getImageCount()).name("layoutCount").value((Number)data.getResources().getLayoutCount()).endObject();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ModuleInfo read(@NotNull JsonReader input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        ModuleInfo data = new ModuleInfo(null, null, null, false, null, null, 0, false, null, null, 1023, null);
        JsonReader $receiver$iv = input;
        $receiver$iv.beginObject();
        while ($receiver$iv.hasNext()) {
            void it;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.nextName(), (String)"nextName()");
            JsonReader $receiver = $receiver$iv;
            switch (it) {
                case "moduleName": {
                    String string = $receiver.nextString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nextString()");
                    data.setName(string);
                    break;
                }
                case "moduleType": {
                    String string;
                    String string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.nextString(), (String)"nextString()");
                    ModuleInfo moduleInfo = data;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                    moduleInfo.setType(ModuleType.valueOf(string));
                    break;
                }
                case "java": {
                    data.setJavaSourceInfo(this.readSourceFilesInfo(input));
                    break;
                }
                case "useKotlin": {
                    data.setUseKotlin($receiver.nextBoolean());
                    break;
                }
                case "kotlin": {
                    data.setKotlinSourceInfo(this.readSourceFilesInfo(input));
                    break;
                }
                case "dependencies": {
                    data.setDependencies(this.readDependencies($receiver));
                    break;
                }
                case "activityCount": {
                    data.setActivityCount($receiver.nextInt());
                    break;
                }
                case "hasLaunchActivity": {
                    data.setHasLaunchActivity($receiver.nextBoolean());
                    break;
                }
                case "androidBuildConfig": {
                    data.setAndroidBuildConfig(this.readAndroidBuildConfig($receiver));
                    break;
                }
                case "resourcesConfig": {
                    data.setResources(this.readResources($receiver));
                    break;
                }
                default: {
                    $receiver.skipValue();
                }
            }
        }
        $receiver$iv.endObject();
        return data;
    }

    /*
     * WARNING - void declaration
     */
    private final SourceFilesInfo readSourceFilesInfo(JsonReader input) {
        int packages = 0;
        int classesPerPackage = 0;
        int methodsPerClass = 0;
        int fieldsPerClass = 0;
        JsonReader $receiver$iv = input;
        $receiver$iv.beginObject();
        while ($receiver$iv.hasNext()) {
            void it;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.nextName(), (String)"nextName()");
            JsonReader $receiver = $receiver$iv;
            switch (it) {
                case "packages": {
                    packages = $receiver.nextInt();
                    break;
                }
                case "classesPerPackage": {
                    classesPerPackage = $receiver.nextInt();
                    break;
                }
                case "methodsPerClass": {
                    methodsPerClass = $receiver.nextInt();
                    break;
                }
                case "fieldsPerClass": {
                    fieldsPerClass = $receiver.nextInt();
                    break;
                }
                default: {
                    $receiver.skipValue();
                }
            }
        }
        $receiver$iv.endObject();
        return new SourceFilesInfo(packages, classesPerPackage, methodsPerClass, fieldsPerClass);
    }

    /*
     * Unable to fully structure code
     */
    private final List<PoetDependenciesInfo> readDependencies(JsonReader input) {
        dependencies = new ArrayList<E>();
        $receiver$iv = input;
        $receiver$iv.beginArray();
        while ($receiver$iv.hasNext()) {
            $receiver = $receiver$iv;
            type = null;
            dependency = null;
            scope = null;
            $receiver$iv = $receiver;
            $receiver$iv.beginObject();
            block6: while ($receiver$iv.hasNext()) {
                block10: {
                    Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.nextName(), (String)"nextName()");
                    $receiver = $receiver$iv;
                    var11_11 = it;
                    switch (var11_11.hashCode()) {
                        case 166208699: {
                            if (!var11_11.equals("library")) ** break;
                            break;
                        }
                        case -1077554975: {
                            if (!var11_11.equals("method")) ** break;
                            break block10;
                        }
                        case -870351081: {
                            if (!var11_11.equals("moduleName")) ** break;
                            type = DependencyType.MODULE;
                            dependency = $receiver.nextString();
                            continue block6;
                        }
                    }
                    type = DependencyType.EXTERNAL_LIBRARY;
                    dependency = $receiver.nextString();
                    continue;
                }
                scope = $receiver.nextString();
                continue;
                $receiver.skipValue();
            }
            $receiver$iv.endObject();
            v0 = type;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            v1 = scope;
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            v2 = dependency;
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            dependencies.add(new PoetDependenciesInfo(v0, v1, v2));
        }
        $receiver$iv.endArray();
        return dependencies;
    }

    /*
     * WARNING - void declaration
     */
    private final PoetResourceInfo readResources(JsonReader input) {
        int stringCount = 0;
        int imageCount = 0;
        int layoutCount = 0;
        JsonReader $receiver$iv = input;
        $receiver$iv.beginObject();
        while ($receiver$iv.hasNext()) {
            void it;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.nextName(), (String)"nextName()");
            JsonReader $receiver = $receiver$iv;
            switch (it) {
                case "stringCount": {
                    stringCount = $receiver.nextInt();
                    break;
                }
                case "imageCount": {
                    imageCount = $receiver.nextInt();
                    break;
                }
                case "layoutCount": {
                    layoutCount = $receiver.nextInt();
                    break;
                }
                default: {
                    $receiver.skipValue();
                }
            }
        }
        $receiver$iv.endObject();
        return new PoetResourceInfo(stringCount, imageCount, layoutCount);
    }

    /*
     * WARNING - void declaration
     */
    private final AndroidBuildConfig readAndroidBuildConfig(JsonReader input) {
        AndroidBuildConfig buildConfig = new AndroidBuildConfig(0, 0, 0, 7, null);
        JsonReader $receiver$iv = input;
        $receiver$iv.beginObject();
        while ($receiver$iv.hasNext()) {
            void it;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.nextName(), (String)"nextName()");
            JsonReader $receiver = $receiver$iv;
            switch (it) {
                case "minSdkVersion": {
                    buildConfig.setMinSdkVersion($receiver.nextInt());
                    break;
                }
                case "targetSdkVersion": {
                    buildConfig.setTargetSdkVersion($receiver.nextInt());
                    break;
                }
                case "compileSdkVersion": {
                    buildConfig.setCompileSdkVersion($receiver.nextInt());
                    break;
                }
                default: {
                    $receiver.skipValue();
                }
            }
        }
        $receiver$iv.endObject();
        return buildConfig;
    }
}

