/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.DexParams;
import com.android.build.gradle.internal.tasks.DexingRunnable;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.builder.core.SerializableMessageReceiver;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001%B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010#\u001a\u00020$H\u0007R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR&\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8G@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00148G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R2\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8G@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryDexingTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "executor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lcom/android/build/api/artifact/BuildableArtifact;", "classes", "getClasses", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setClasses", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "Lcom/android/ide/common/blame/MessageReceiver;", "messageReceiver", "getMessageReceiver", "()Lcom/android/ide/common/blame/MessageReceiver;", "setMessageReceiver", "(Lcom/android/ide/common/blame/MessageReceiver;)V", "", "minSdkVersion", "getMinSdkVersion", "()I", "setMinSdkVersion", "(I)V", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "output", "getOutput", "()Lorg/gradle/api/provider/Provider;", "setOutput", "(Lorg/gradle/api/provider/Provider;)V", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "doAction", "", "CreationAction", "gradle"})
public class LibraryDexingTask
extends AndroidVariantTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private BuildableArtifact classes;
    @NotNull
    private Provider<Directory> output;
    private int minSdkVersion;
    @NotNull
    private MessageReceiver messageReceiver;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final BuildableArtifact getClasses() {
        BuildableArtifact buildableArtifact = this.classes;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        return buildableArtifact;
    }

    private final void setClasses(BuildableArtifact buildableArtifact) {
        this.classes = buildableArtifact;
    }

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getOutput() {
        return this.output;
    }

    private final void setOutput(Provider<Directory> provider) {
        this.output = provider;
    }

    @Input
    public final int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    private final void setMinSdkVersion(int n) {
        this.minSdkVersion = n;
    }

    @Internal
    @NotNull
    public final MessageReceiver getMessageReceiver() {
        MessageReceiver messageReceiver = this.messageReceiver;
        if (messageReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageReceiver");
        }
        return messageReceiver;
    }

    private final void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void doAction() {
        Closeable closeable = (Closeable)this.workers;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            MessageReceiver messageReceiver = this.messageReceiver;
            if (messageReceiver == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"messageReceiver");
            }
            MessageReceiver messageReceiver2 = (MessageReceiver)new SerializableMessageReceiver(messageReceiver);
            BuildableArtifact buildableArtifact = this.classes;
            if (buildableArtifact == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
            }
            File file = (File)CollectionsKt.single((Iterable)((Iterable)buildableArtifact));
            Object object = this.output.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"output.get()");
            File file2 = ((Directory)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"output.get().asFile");
            it.submit(DexingRunnable.class, (Serializable)new DexParams(this.minSdkVersion, messageReceiver2, file, file2));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public LibraryDexingTask(@NotNull ObjectFactory objectFactory, @NotNull WorkerExecutor executor) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.workers = Workers.INSTANCE.getWorker(executor, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.output = (Provider)directoryProperty;
        this.minSdkVersion = 1;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getClasses$p(LibraryDexingTask $this) {
        BuildableArtifact buildableArtifact = $this.classes;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classes");
        }
        return buildableArtifact;
    }

    public static final /* synthetic */ int access$getMinSdkVersion$p(LibraryDexingTask $this) {
        return $this.minSdkVersion;
    }

    @NotNull
    public static final /* synthetic */ Provider access$getOutput$p(LibraryDexingTask $this) {
        return $this.output;
    }

    @NotNull
    public static final /* synthetic */ MessageReceiver access$getMessageReceiver$p(LibraryDexingTask $this) {
        MessageReceiver messageReceiver = $this.messageReceiver;
        if (messageReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageReceiver");
        }
        return messageReceiver;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryDexingTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/LibraryDexingTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "output", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<LibraryDexingTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<LibraryDexingTask> type;
        private Provider<Directory> output;
        @NotNull
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<LibraryDexingTask> getType() {
            return this.type;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            this.output = BuildArtifactsHolder.createDirectory$default(this.scope.getArtifacts(), InternalArtifactType.DEX, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull LibraryDexingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.classes = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.LIBRARY_CLASSES);
            AndroidVersion androidVersion = this.scope.getMinSdkVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"scope.minSdkVersion");
            task.minSdkVersion = androidVersion.getFeatureLevel();
            Provider<Directory> provider = this.output;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            }
            task.output = provider;
            GlobalScope globalScope = this.scope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
            MessageReceiver messageReceiver = globalScope.getMessageReceiver();
            Intrinsics.checkExpressionValueIsNotNull((Object)messageReceiver, (String)"scope.globalScope.messageReceiver");
            task.messageReceiver = messageReceiver;
        }

        @NotNull
        public final VariantScope getScope() {
            return this.scope;
        }

        public CreationAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            super(scope);
            this.scope = scope;
            String string = this.scope.getTaskName("dex");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.getTaskName(\"dex\")");
            this.name = string;
            this.type = LibraryDexingTask.class;
        }
    }
}

